/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.immersion.events.EventType;
import zombieworldproject.zombieracore.managers.item.bases.equitable.EquitableTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.BackpackItemBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.CustomLeatherArmorItemBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.food.CannedFoodItemBase;
import zombieworldproject.zombieracore.managers.item.bases.food.FoodItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.AmmoTypes;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeItemBase;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeUpgradeHandler;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeUpgradeTypes;
import zombieworldproject.zombieracore.managers.item.bases.melee.ZEMeleeManager;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.Junk;
import zombieworldproject.zombieracore.managers.item.stats.BonusStats;
import zombieworldproject.zombieracore.managers.item.stats.ZEBonusStats;
import zombieworldproject.zombieracore.managers.props.PropType;
import zombieworldproject.zombieracore.managers.props.ZEPropManager;

public class ZombiEraConfig {
    private FileConfiguration config;

    public ZombiEraConfig() {
        File configFile = new File(ZombiEraCore.instance.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.createDefault(false);
        }
        this.loadSettings();
    }

    public void initialize() {
        File configFile = new File(ZombiEraCore.instance.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.createDefault(true);
        } else {
            this.reloadConfigs();
        }
    }

    public boolean reloadConfigs() {
        try {
            this.config = null;
            FileConfiguration cfg = this.getConfig();
            ZombiEraCore.getRecipeManager().clear();
            ZombiEraCore.debugInfo("Config: RELOAD");
            ZombiEraCore.getOtherManager().loadBlockedBlockUses();
            ZombiEraCore.debugInfo("Config: Loading Game settings...");
            this.loadSettings();
            ZombiEraCore.debugInfo("Config: Game settings loaded.");
            ZombiEraCore.getRealTimeManager().enable();
            ZombiEraCore.getRealTimeManager().setDayLengthInTicks(ZombiEraSettings.TIME_DAY_TICKS.intValue());
            ZombiEraCore.getItemManager().clearAll();
            ZombiEraCore.getItemManager().Initialize();
            ZombiEraCore.debugInfo("Config: Loading armed guns...");
            this.loadArmedGuns();
            ZombiEraCore.debugInfo("Config: Armed guns loaded.");
            ZombiEraCore.debugInfo("Config: Loading melee weapons...");
            this.loadMeleeWeapons();
            ZombiEraCore.debugInfo("Config: Melee weapons loaded.");
            ZombiEraCore.debugInfo("Config: Loading food items...");
            this.loadFoodItems();
            ZombiEraCore.debugInfo("Config: Food items loaded.");
            ZombiEraCore.debugInfo("Config: Loading equipment items...");
            this.loadEquipmentItems();
            ZombiEraCore.debugInfo("Config: Equipment items loaded.");
            this.loadJunkItems();
            this.loadProps();
            ZombiEraCore.getPropManager().addPropItems();
            ZombiEraCore.getItemManager().updateMappedItemBases();
            ZombiEraCore.getRecipeManager().loadRecipes();
            ZombiEraCore.getItemManager().updateMappedItemBases();
            ZombiEraCore.debugInfo("Config: Loading item rarities...");
            ZombiEraCore.getRarityDropManager().clear();
            this.loadRarities();
            ZombiEraCore.debugInfo("Config: Item rarities loaded.");
            ZombiEraCore.ZEPlayerManagers.getHealthManager().reloadStatesSettings();
            this.loadEntities();
            this.loadConfigZones();
            ZombiEraCore.getTipsManager().reloadTips();
            ZombiEraCore.getEventManager().clearConfigSettings();
            this.loadEvents();
            ZombiEraCore.debugInfo("Config: Reloading spawners");
            ZombiEraCore.getLocalSpawnerManager().reloadConfig();
            ZombiEraCore.debugInfo("Config: All configs have been loaded!");
            return true;
        }
        catch (Exception ignore) {
            ZombiEraCore.debugInfo("ERROR: " + String.valueOf(ignore));
            return false;
        }
    }

    public void loadEvents() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("events");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                EventType eventType = EventType.valueOf((String)config.get(String.format("events.%s.type", key)));
                Integer minTicks = (Integer)config.get(String.format("events.%s.minTicks", key));
                Integer maxTicks = (Integer)config.get(String.format("events.%s.maxTicks", key));
                Integer minPlayers = (Integer)config.get(String.format("events.%s.minPlayers", key));
                ZombiEraCore.debugInfo("Event: " + key + " has been loaded. Type: " + String.valueOf((Object)eventType));
                ZombiEraCore.getEventManager().loadEventFromConfig(eventType, minTicks, maxTicks, minPlayers);
            }
        }
    }

    public void loadProps() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("props");
        ZEPropManager propManager = ZombiEraCore.getPropManager();
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                PropType type = PropType.DEFAULT;
                if (config.isSet(String.format("props.%s.type", key))) {
                    type = PropType.valueOf((String)config.get(String.format("props.%s.type", key)));
                }
                switch (type) {
                    case DEFAULT: {
                        Integer nbtId = (Integer)config.get(String.format("props.%s.nbt", key));
                        String display = (String)config.get(String.format("props.%s.display", key));
                        Boolean marker = true;
                        if (config.isSet(String.format("props.%s.marker", key))) {
                            marker = (Boolean)config.get(String.format("props.%s.marker", key));
                        }
                        Boolean setArmZero = true;
                        if (config.isSet(String.format("props.%s.setArmZero", key))) {
                            setArmZero = (Boolean)config.get(String.format("props.%s.setArmZero", key));
                        }
                        Boolean isSaved = true;
                        if (config.isSet(String.format("props.%s.saved", key))) {
                            isSaved = (Boolean)config.get(String.format("props.%s.saved", key));
                        }
                        String handler = null;
                        if (config.isSet(String.format("props.%s.handler", key))) {
                            handler = (String)config.get(String.format("props.%s.handler", key));
                        }
                        ZombiEraCore.debugInfo(String.format("Loaded prop: %s", key));
                        propManager.loadDefaultProp(key, nbtId, display, marker, isSaved, setArmZero, handler);
                        break;
                    }
                    case LOOT: {
                        String prop1 = (String)config.get(String.format("props.%s.props.closed", key));
                        String prop2 = (String)config.get(String.format("props.%s.props.opened", key));
                        String rarityGroup = null;
                        if (config.isSet(String.format("props.%s.rarityGroup", key))) {
                            rarityGroup = (String)config.get(String.format("props.%s.rarityGroup", key));
                        }
                        Boolean openAnimation = true;
                        if (config.isSet(String.format("props.%s.openAnimation", key))) {
                            openAnimation = (Boolean)config.get(String.format("props.%s.openAnimation", key));
                        }
                        ZombiEraCore.debugInfo(String.format("Setting lootable for: %s", key));
                        propManager.loadLootProp(prop1, prop2, openAnimation, rarityGroup);
                    }
                }
            }
        }
    }

    public void loadJunkItems() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("items.junk");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                Integer nbtId = (Integer)config.get(String.format("items.junk.%s.nbt_id", key));
                String name = (String)config.get(String.format("items.junk.%s.name", key));
                String rarity = (String)config.get(String.format("items.junk.%s.rarity", key));
                Integer dropWeight = (Integer)config.get(String.format("items.junk.%s.dropWeight", key));
                ZombiEraCore.debugInfo("Junk item loaded with key:" + key);
                new Junk(nbtId, name, key, dropWeight, rarity);
            }
        }
    }

    public void loadConfigZones() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("zones");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                ZombiEraCore.getZoneManager().addConfigZone(key);
            }
        }
    }

    public void loadEntities() {
        ZombiEraCore.getEntityManager().clear();
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("entity");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                String name = (String)config.get(String.format("entity.%s.name", key));
                String vanillaEntity = (String)config.get(String.format("entity.%s.vanillaEntity", key));
                Double health = (Double)config.get(String.format("entity.%s.health", key));
                String handler = (String)config.get(String.format("entity.%s.handler", key));
                Boolean globalSpawn = (Boolean)config.get(String.format("entity.%s.globalSpawn.enabled", key));
                Integer spawnWeight = (Integer)config.get(String.format("entity.%s.globalSpawn.weight", key));
                HashMap<String, String> clothes = null;
                ConfigurationSection configSectionClothes = config.getConfigurationSection(String.format("entity.%s.clothes", key));
                if (configSectionClothes != null) {
                    clothes = new HashMap<String, String>();
                    if (config.isSet(String.format("entity.%s.clothes.head", key))) {
                        clothes.put("head", (String)config.get(String.format("entity.%s.clothes.head", key)));
                    }
                    if (config.isSet(String.format("entity.%s.clothes.chest", key))) {
                        clothes.put("chest", (String)config.get(String.format("entity.%s.clothes.chest", key)));
                    }
                    if (config.isSet(String.format("entity.%s.clothes.legs", key))) {
                        clothes.put("legs", (String)config.get(String.format("entity.%s.clothes.legs", key)));
                    }
                    if (config.isSet(String.format("entity.%s.clothes.boots", key))) {
                        clothes.put("boots", (String)config.get(String.format("entity.%s.clothes.boots", key)));
                    }
                }
                ZombiEraCore.getEntityManager().addEntity(key, name, vanillaEntity, handler, health, clothes, globalSpawn, spawnWeight);
                ZombiEraCore.debugInfo("Added entity with key: " + key);
            }
        }
    }

    public void loadSettings() {
        FileConfiguration config = this.getConfig();
        ZombiEraSettings.DEFAULT_GAMEMODE = GameMode.valueOf((String)((String)config.get("ZombiEra.settings.default.gamemode")).toUpperCase());
        ZombiEraSettings.TIME_DAY_TICKS = (Integer)config.get("ZombiEra.settings.time.day.ticks");
        ZombiEraSettings.TIME_DAY_START = (String)config.get("ZombiEra.settings.time.day.start");
        ZombiEraSettings.TIME_DAY_END = (String)config.get("ZombiEra.settings.time.day.end");
        ZombiEraSettings.TIME_WORLD = (String)config.get("ZombiEra.settings.time.world");
        ZombiEraSettings.REMOTE_API_KEY = (String)config.get("ZombiEra.remote.api.key");
        ZombiEraSettings.SEND_TIPS_ENABLED = (Boolean)config.get("ZombiEra.settings.tips.enabled");
        ZombiEraSettings.SEND_TIPS_DELAY = (Integer)config.get("ZombiEra.settings.tips.delay");
        ZombiEraSettings.ENTITY_MANAGER_UPDATE_TICKS = (Integer)config.get("ZombiEra.settings.entities.entity-manager-update-ticks");
        ZombiEraSettings.CANCEL_SUN_IGNITE_ENTITIES = (Boolean)config.get("ZombiEra.settings.entities.cancel-sun-ignites-entities");
        ZombiEraSettings.ENTITY_MANAGER_DESPAWN_DISTANCE = (Double)config.get("ZombiEra.settings.entities.despawn-distance");
        ZombiEraSettings.ENTITIY_MANAGER_DESPAWN_DELAY = (Integer)config.get("ZombiEra.settings.entities.despawn-delay-ticks");
        ZombiEraSettings.ENTITIES_PER_PLAYER_DAY = (Integer)config.get("ZombiEra.settings.entities.per-player.day");
        ZombiEraSettings.ENTITIES_PER_PLAYER_NIGHT = (Integer)config.get("ZombiEra.settings.entities.per-player.night");
        ZombiEraSettings.ENTITIES_PER_PLAYER_KILL_SAFETY_DELAY = (Integer)config.get("ZombiEra.settings.entities.per-player.safety-delay-secs");
        ZombiEraSettings.WOLF_ATTACK_PLAYER_RANGE = (Integer)config.get("ZombiEra.settings.entities.wolf.attack-range");
        ZombiEraSettings.WOLF_UPDATE_TICKS = (Integer)config.get("ZombiEra.settings.entities.wolf.update-in-ticks");
        ZombiEraSettings.PLAYER_THIRST_MAX = (Integer)config.get("ZombiEra.settings.players.states.thirst.max-value");
        ZombiEraSettings.PLAYER_THIRST_UPDATE_TICKS = (Integer)config.get("ZombiEra.settings.players.states.thirst.update-global-ticks");
        ZombiEraSettings.PLAYER_THIRST_DAMAGE_TICKS = (Integer)config.get("ZombiEra.settings.players.states.thirst.update-damage-ticks");
        ZombiEraSettings.STAMINA_JUMP = (Double)config.get("ZombiEra.settings.players.stamina.jump");
        ZombiEraSettings.STAMINA_SPRINT = (Double)config.get("ZombiEra.settings.players.stamina.sprint.while");
        ZombiEraSettings.STAMINA_SPRINT_START = (Double)config.get("ZombiEra.settings.players.stamina.sprint.start");
        ZombiEraSettings.STAMINA_RECHARGE = (Double)config.get("ZombiEra.settings.players.stamina.recharge");
        ZombiEraSettings.NECK_BLEEDING_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.bleeding.neck.chance")).floatValue());
        ZombiEraSettings.CHEST_BLEEDING_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.bleeding.chest.chance")).floatValue());
        ZombiEraSettings.HAND_BLEEDING_LEFT_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.bleeding.hand_left.chance")).floatValue());
        ZombiEraSettings.HAND_BLEEDING_RIGHT_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.bleeding.hand_right.chance")).floatValue());
        ZombiEraSettings.LEG_BLEEDING_LEFT_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.bleeding.leg_left.chance")).floatValue());
        ZombiEraSettings.LEG_BLEEDING_RIGHT_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.bleeding.leg_right.chance")).floatValue());
        ZombiEraSettings.INFECTION_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.infection.chance")).floatValue());
        ZombiEraSettings.BROKEN_LEG_LEFT_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.fracture.leg_left.chance")).floatValue());
        ZombiEraSettings.BROKEN_LEG_RIGHT_CHANCE = Float.valueOf(((Double)config.get("ZombiEra.settings.players.states.fracture.leg_right.chance")).floatValue());
        ZombiEraSettings.NECK_BLEEDING_TIMER = (Integer)config.get("ZombiEra.settings.players.states.bleeding.neck.timer");
        ZombiEraSettings.CHEST_BLEEDING_TIMER = (Integer)config.get("ZombiEra.settings.players.states.bleeding.chest.timer");
        ZombiEraSettings.HAND_BLEEDING_LEFT_TIMER = (Integer)config.get("ZombiEra.settings.players.states.bleeding.hand_left.timer");
        ZombiEraSettings.HAND_BLEEDING_RIGHT_TIMER = (Integer)config.get("ZombiEra.settings.players.states.bleeding.hand_right.timer");
        ZombiEraSettings.LEG_BLEEDING_LEFT_TIMER = (Integer)config.get("ZombiEra.settings.players.states.bleeding.leg_left.timer");
        ZombiEraSettings.LEG_BLEEDING_RIGHT_TIMER = (Integer)config.get("ZombiEra.settings.players.states.bleeding.leg_right.timer");
        ZombiEraSettings.INFECTION_TIMER = (Integer)config.get("ZombiEra.settings.players.states.infection.timer");
        ZombiEraSettings.BROKEN_LEG_LEFT_TIMER = (Integer)config.get("ZombiEra.settings.players.states.fracture.leg_left.timer");
        ZombiEraSettings.BROKEN_LEG_RIGHT_TIMER = (Integer)config.get("ZombiEra.settings.players.states.fracture.leg_right.timer");
        ZombiEraSettings.NECK_BLEEDING_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.bleeding.neck.damage");
        ZombiEraSettings.CHEST_BLEEDING_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.bleeding.chest.damage");
        ZombiEraSettings.HAND_BLEEDING_LEFT_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.bleeding.hand_left.damage");
        ZombiEraSettings.HAND_BLEEDING_RIGHT_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.bleeding.hand_right.damage");
        ZombiEraSettings.LEG_BLEEDING_LEFT_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.bleeding.leg_left.damage");
        ZombiEraSettings.LEG_BLEEDING_RIGHT_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.bleeding.leg_right.damage");
        ZombiEraSettings.INFECTION_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.infection.damage");
        ZombiEraSettings.BROKEN_LEG_LEFT_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.fracture.leg_left.damage");
        ZombiEraSettings.BROKEN_LEG_RIGHT_DAMAGE = (Double)config.get("ZombiEra.settings.players.states.bleeding.leg_right.damage");
        ZombiEraSettings.BARBED_WIRE_DAMAGE = (Integer)config.get("ZombiEra.settings.built-in-items.barbedwire.damage");
        ZombiEraSettings.BARBED_WIRE_DAMAGE_ZOMBIE_MULTIPLIER = (Double)config.get("ZombiEra.settings.built-in-items.barbedwire.zombie-damage-multiplier");
        ZombiEraSettings.BARBED_WIRE_SLOWNESS = (Boolean)config.get("ZombiEra.settings.built-in-items.barbedwire.causes-slowness-enabled");
        ZombiEraSettings.BARBED_WIRE_SLOWNESS_MULTIPLIER = (Integer)config.get("ZombiEra.settings.built-in-items.barbedwire.slowness-multiplier");
        ZombiEraSettings.BARBED_WIRE_DAMAGE_PLAYER_ONLY = (Boolean)config.get("ZombiEra.settings.built-in-items.barbedwire.damage-players-only");
        ZombiEraSettings.BARBED_WIRE_BLOCK = (String)config.get("ZombiEra.settings.built-in-items.barbedwire.material");
        ZombiEraSettings.BARBED_WIRE_DROP_ON_DESTROY = (Boolean)config.get("ZombiEra.settings.built-in-items.barbedwire.drop-on-destroy");
        ZombiEraSettings.BARBED_WIRE_UPDATE_TICKS = (Integer)config.get("ZombiEra.settings.built-in-items.barbedwire.update-in-ticks");
    }

    public void loadArmedGuns() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("items.weapons.armed");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                String name = (String)config.get(String.format("items.weapons.armed.%s.name", key));
                Integer id = (Integer)config.get(String.format("items.weapons.armed.%s.nbt", key));
                Integer zoomId = (Integer)config.get(String.format("items.weapons.armed.%s.zoom-nbt", key));
                Double damage = (Double)config.get(String.format("items.weapons.armed.%s.damage", key));
                Integer durability = (Integer)config.get(String.format("items.weapons.armed.%s.durability", key));
                String rarity = (String)config.get(String.format("items.weapons.armed.%s.rarity", key));
                Double bulletvelocity = (Double)config.get(String.format("items.weapons.armed.%s.bullet-velocity", key));
                Integer shootDelayTicks = (Integer)config.get(String.format("items.weapons.armed.%s.shootDelayTicks", key));
                Double recoilX = (Double)config.get(String.format("items.weapons.armed.%s.recoil.x", key));
                Double recoilY = (Double)config.get(String.format("items.weapons.armed.%s.recoil.y", key));
                Integer dropWeight = (Integer)config.get(String.format("items.weapons.armed.%s.dropWeight", key));
                Integer maxAmmo = (Integer)config.get(String.format("items.weapons.armed.%s.maxAmmo", key));
                AmmoTypes ammoType = AmmoTypes.valueOf((String)config.get(String.format("items.weapons.armed.%s.ammoType", key)));
                Integer reloadInTicks = (Integer)config.get(String.format("items.weapons.armed.%s.reloadInTicks", key));
                String fireSound = (String)config.get(String.format("items.weapons.armed.%s.fireSound", key));
                String reloadSound = (String)config.get(String.format("items.weapons.armed.%s.reloadSound", key));
                Double maxRangeDamage = (Double)config.get(String.format("items.weapons.armed.%s.maxRangeDamage", key));
                Double headMultiplier = (Double)config.get(String.format("items.weapons.armed.%s.multipliers.head", key));
                Double bodyMultiplier = (Double)config.get(String.format("items.weapons.armed.%s.multipliers.body", key));
                Double legMultiplier = (Double)config.get(String.format("items.weapons.armed.%s.multipliers.leg", key));
                Integer scopeNbtId = (Integer)config.get(String.format("items.weapons.armed.%s.scopeNbtId", key));
                Integer zoomMultiplier = (Integer)config.get(String.format("items.weapons.armed.%s.zoomMultiplier", key));
                Integer sprintNbtId = (Integer)config.get(String.format("items.weapons.armed.%s.sprintNbtId", key));
                Double walkSlowness = (Double)config.get(String.format("items.weapons.armed.%s.walkSlowness", key));
                Integer equipTicks = (Integer)config.get(String.format("items.weapons.armed.%s.equipTicks", key));
                BonusStats bonusStats = ZEBonusStats.getBonusStatsForConfigItem(config, String.format("items.weapons.armed.%s", key));
                new ArmedGunItemBase(key, name, id, zoomId, durability, damage, shootDelayTicks, rarity, bulletvelocity, recoilX, recoilY, dropWeight, maxAmmo, ammoType, reloadInTicks, fireSound, reloadSound, maxRangeDamage, headMultiplier, bodyMultiplier, legMultiplier, scopeNbtId, zoomMultiplier, sprintNbtId, walkSlowness, equipTicks, bonusStats);
                ZombiEraCore.debugInfo(String.format("Config: Armed Gun %s loaded, nbt_id: %s", key, id));
            }
        }
    }

    public void loadFoodItems() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("items.food");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                String name = (String)config.get(String.format("items.food.%s.name", key));
                Integer id = (Integer)config.get(String.format("items.food.%s.nbt", key));
                Boolean drink = (Boolean)config.get(String.format("items.food.%s.drink", key));
                Integer rotten_chance = (Integer)config.get(String.format("items.food.%s.rotten_chance", key));
                Boolean stackable = (Boolean)config.get(String.format("items.food.%s.stackable", key));
                Integer hunger = (Integer)config.get(String.format("items.food.%s.add.hunger", key));
                Integer water = (Integer)config.get(String.format("items.food.%s.add.water", key));
                String rarity = (String)config.get(String.format("items.food.%s.rarity", key));
                Integer dropWeight = (Integer)config.get(String.format("items.food.%s.dropWeight", key));
                Float saturationLevel = Float.valueOf(((Double)config.get(String.format("items.food.%s.saturationLevel", key))).floatValue());
                new FoodItemBase(key, name, id, drink, rotten_chance, hunger, water, rarity, stackable, dropWeight, saturationLevel);
                ZombiEraCore.debugInfo(String.format("Config: Food item %s loaded, nbt_id: %s", key, id));
            }
        }
        if ((configSection = config.getConfigurationSection("items.cannedfood")) != null) {
            for (String key : configSection.getKeys(false)) {
                String nameClosed = (String)config.get(String.format("items.cannedfood.%s.closed.name", key));
                String nameOpened = (String)config.get(String.format("items.cannedfood.%s.opened.name", key));
                Integer nbtClosed = (Integer)config.get(String.format("items.cannedfood.%s.closed.nbt", key));
                Integer nbtOpened = (Integer)config.get(String.format("items.cannedfood.%s.opened.nbt", key));
                Boolean drink = (Boolean)config.get(String.format("items.cannedfood.%s.drink", key));
                Integer rotten_chance = (Integer)config.get(String.format("items.cannedfood.%s.rotten_chance", key));
                Integer hunger = (Integer)config.get(String.format("items.cannedfood.%s.add.hunger", key));
                Integer water = (Integer)config.get(String.format("items.cannedfood.%s.add.water", key));
                String rarity = (String)config.get(String.format("items.cannedfood.%s.rarity", key));
                Integer dropWeight = (Integer)config.get(String.format("items.cannedfood.%s.dropWeight", key));
                Float saturationLevel = Float.valueOf(((Double)config.get(String.format("items.cannedfood.%s.saturationLevel", key))).floatValue());
                new CannedFoodItemBase(key, nameOpened, nameClosed, nbtOpened, nbtClosed, drink, rotten_chance, hunger, water, rarity, dropWeight, saturationLevel);
                ZombiEraCore.debugInfo(String.format("Config: Closed/Opened Food item %s loaded, nbtIdClosed: %s, nbtIdOpened: %s", key, nbtClosed, nbtOpened));
            }
        }
    }

    public void loadMeleeWeapons() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("items.weapons.melee");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                String name = (String)config.get(String.format("items.weapons.melee.%s.name", key));
                Integer id = (Integer)config.get(String.format("items.weapons.melee.%s.nbt", key));
                Double damage = (Double)config.get(String.format("items.weapons.melee.%s.damage", key));
                Integer durability = (Integer)config.get(String.format("items.weapons.melee.%s.durability", key));
                String rarity = (String)config.get(String.format("items.weapons.melee.%s.rarity", key));
                Integer dropWeight = (Integer)config.get(String.format("items.weapons.melee.%s.dropWeight", key));
                Double attackSpeed = (Double)config.get(String.format("items.weapons.melee.%s.attackSpeed", key));
                ArrayList<MeleeUpgradeHandler> meleeUpgradeHandlers = new ArrayList<MeleeUpgradeHandler>();
                if (config.isSet(String.format("items.weapons.melee.%s.handler", key))) {
                    String[] handlerArray;
                    String handlers = (String)config.get(String.format("items.weapons.melee.%s.handler", key));
                    for (String handler : handlerArray = handlers.split(",")) {
                        MeleeUpgradeTypes type = MeleeUpgradeTypes.valueOf(handler);
                        meleeUpgradeHandlers.add(ZEMeleeManager.getHandler(type));
                    }
                }
                BonusStats bonusStats = ZEBonusStats.getBonusStatsForConfigItem(config, String.format("items.weapons.melee.%s", key));
                new MeleeItemBase(key, name, id, damage, durability, rarity, dropWeight, attackSpeed, meleeUpgradeHandlers, bonusStats);
                ZombiEraCore.debugInfo(String.format("Config: Melee weapon %s loaded, nbt_id: %s", key, id));
            }
        }
    }

    public void loadRarities() {
        ConfigurationSection configSection2;
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("items.rarities");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                String color = (String)config.get(String.format("items.rarities.%s.color", key));
                ZombiEraCore.getRarityDropManager().addRarity(key, color);
            }
        }
        ZombiEraCore.getRarityDropManager().generateRarities();
        ZombiEraCore.debugInfo("Creating rarity groups...");
        configSection = config.getConfigurationSection("items.rarityGroups");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                configSection2 = config.getConfigurationSection(String.format("items.rarityGroups.%s", key));
                if (configSection2 == null) continue;
                for (String key2 : configSection2.getKeys(false)) {
                    if (key2.equals("crateRespawnLootInSeconds")) continue;
                    ZombiEraCore.getRarityDropManager().addGroup(key, key2, (Integer)config.get(String.format("items.rarityGroups.%s.%s.rarityWeight", key, key2)), (Integer)config.get(String.format("items.rarityGroups.%s.%s.itemCountMin", key, key2)), (Integer)config.get(String.format("items.rarityGroups.%s.%s.itemCountMax", key, key2)), (Integer)config.get(String.format("items.rarityGroups.%s.crateRespawnLootInSeconds", key)), (Integer)config.get(String.format("items.rarityGroups.%s.maxIterations", key)));
                }
            }
        }
        ZombiEraCore.debugInfo(String.format("Created: %s rarity groups", ZombiEraCore.getRarityDropManager().groupRarities.size()));
        ZombiEraCore.getRarityDropManager().groupRarities.forEach((name, group) -> ZombiEraCore.debugInfo("Rarity Group: " + name));
        ZombiEraCore.debugInfo("Done creating rarity groups.");
        ZombiEraCore.debugInfo("Loading entity drops...");
        configSection = config.getConfigurationSection("items.entity");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                configSection2 = config.getConfigurationSection(String.format("items.entity.%s.drops", key));
                if (configSection2 == null) continue;
                for (String key2 : configSection2.getKeys(false)) {
                    Integer dropChance = (Integer)config.get(String.format("items.entity.%s.drops.%s.dropChance", key, key2));
                    ZombiEraCore.getRarityDropManager().addEntityRarityGroup(key, key2, dropChance);
                    ZombiEraCore.debugInfo("Added loot for entity: " + key);
                }
            }
        }
    }

    public void loadEquipmentItems() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection configSection = config.getConfigurationSection("items.equipment");
        if (configSection != null) {
            for (String key : configSection.getKeys(false)) {
                String displayName = (String)config.get(String.format("items.equipment.%s.name", key));
                Integer id = (Integer)config.get(String.format("items.equipment.%s.nbt_id", key));
                String stringType = (String)config.get(String.format("items.equipment.%s.slot", key));
                String rarity = (String)config.get(String.format("items.equipment.%s.rarity", key));
                Integer dropWeight = (Integer)config.get(String.format("items.equipment.%s.dropWeight", key));
                Double armor = (Double)config.get(String.format("items.equipment.%s.armor", key));
                EquitableTypes type = EquitableTypes.valueOf(stringType);
                Double radProtection = (Double)config.get(String.format("items.equipment.%s.radProtection", key));
                Double walkSpeed = (Double)config.get(String.format("items.equipment.%s.walkSpeed", key));
                Double scratchArmor = (Double)config.get(String.format("items.equipment.%s.scratchArmor", key));
                Double biteArmor = (Double)config.get(String.format("items.equipment.%s.biteArmor", key));
                Double sneakDistance = (Double)config.get(String.format("items.equipment.%s.sneakDistance", key));
                Integer durability = 100;
                if (config.isSet(String.format("items.equipment.%s.durability", key))) {
                    durability = (Integer)config.get(String.format("items.equipment.%s.durability", key));
                }
                if (type.equals((Object)EquitableTypes.BACKPACK)) {
                    Integer inventorySize = (Integer)config.get(String.format("items.equipment.%s.inventorySize", key));
                    new BackpackItemBase(key, displayName, id, type, rarity, dropWeight, armor, radProtection, inventorySize, scratchArmor, biteArmor, sneakDistance, durability);
                } else if (type.equals((Object)EquitableTypes.LEATHER_BOOTS) || type.equals((Object)EquitableTypes.LEATHER_LEGGINGS) || type.equals((Object)EquitableTypes.LEATHER_CHESTPLATE) || type.equals((Object)EquitableTypes.LEATHER_HELMET)) {
                    String hexColor = (String)config.get(String.format("items.equipment.%s.hexColor", key));
                    new CustomLeatherArmorItemBase(key, displayName, id, type, rarity, dropWeight, armor, radProtection, walkSpeed, hexColor, scratchArmor, biteArmor, sneakDistance, durability);
                } else {
                    new EquitableItemBase(key, displayName, id, type, rarity, dropWeight, armor, radProtection, walkSpeed, scratchArmor, biteArmor, sneakDistance, durability);
                }
                ZombiEraCore.debugInfo(String.format("Config: Equipment item %s loaded, nbt_id: %s", key, id));
            }
        }
    }

    public void createDefault(boolean reload) {
        FileConfiguration cfg = ZombiEraCore.instance.getConfig();
        ZombiEraCore.debugInfo("Creating...");
        cfg.options().copyDefaults(true);
        ZombiEraCore.instance.saveConfig();
        if (reload) {
            this.reloadConfigs();
        }
    }

    private FileConfiguration getConfig() {
        if (this.config == null) {
            this.config = YamlConfiguration.loadConfiguration((File)new File(ZombiEraCore.instance.getDataFolder(), "config.yml"));
        }
        return this.config;
    }
}

