/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import zombieworldproject.zombieracore.ZombiEraConfig;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.commands.cmds.BlueprintsCommand;
import zombieworldproject.zombieracore.commands.cmds.EquipmentCommand;
import zombieworldproject.zombieracore.commands.cmds.EventCommand;
import zombieworldproject.zombieracore.commands.cmds.GiveItemCommand;
import zombieworldproject.zombieracore.commands.cmds.HealCommand;
import zombieworldproject.zombieracore.commands.cmds.KeycardCommand;
import zombieworldproject.zombieracore.commands.cmds.LocalChatCommand;
import zombieworldproject.zombieracore.commands.cmds.LocationsCommand;
import zombieworldproject.zombieracore.commands.cmds.LootCommand;
import zombieworldproject.zombieracore.commands.cmds.NPCCommand;
import zombieworldproject.zombieracore.commands.cmds.PlayerDoorCommand;
import zombieworldproject.zombieracore.commands.cmds.PropCommand;
import zombieworldproject.zombieracore.commands.cmds.ReloadCommand;
import zombieworldproject.zombieracore.commands.cmds.SpawnerCommand;
import zombieworldproject.zombieracore.commands.cmds.StopCommand;
import zombieworldproject.zombieracore.commands.cmds.StructureCommand;
import zombieworldproject.zombieracore.commands.cmds.SuicideCommand;
import zombieworldproject.zombieracore.commands.cmds.SummonCommand;
import zombieworldproject.zombieracore.commands.cmds.TimeCommand;
import zombieworldproject.zombieracore.commands.cmds.WeatherCommand;
import zombieworldproject.zombieracore.commands.cmds.WipeCommand;
import zombieworldproject.zombieracore.commands.cmds.ZoneCommand;
import zombieworldproject.zombieracore.commands.cmds.balance.BalanceCommand;
import zombieworldproject.zombieracore.commands.cmds.balance.PayCommand;
import zombieworldproject.zombieracore.commands.cmds.spawn.EditRandomSpawnsCommands;
import zombieworldproject.zombieracore.commands.cmds.spawn.RandomSpawnCommand;
import zombieworldproject.zombieracore.commands.cmds.spawn.SetSpawnCommand;
import zombieworldproject.zombieracore.commands.cmds.spawn.SpawnCommand;
import zombieworldproject.zombieracore.commands.tabcompleters.BalanceTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.BlueprintsTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.EditRandomSpawnsTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.EventTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.GiveItemTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.HealTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.KeycardTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.LocalChatTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.LocationsTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.LootTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.NPCTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.PayTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.PlayerDoorTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.PropTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.SpawnerTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.StructureTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.SummonTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.TimeTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.WeatherTabComplete;
import zombieworldproject.zombieracore.commands.tabcompleters.ZoneTabComplete;
import zombieworldproject.zombieracore.handlers.ChunkHandler;
import zombieworldproject.zombieracore.handlers.EntitiesHandler;
import zombieworldproject.zombieracore.handlers.InventoryHandler;
import zombieworldproject.zombieracore.handlers.PacketHandler;
import zombieworldproject.zombieracore.handlers.PlayerHandler;
import zombieworldproject.zombieracore.handlers.RecipeHandler;
import zombieworldproject.zombieracore.handlers.WorldHandler;
import zombieworldproject.zombieracore.managers.ZEBossBarManager;
import zombieworldproject.zombieracore.managers.ZEIconsManager;
import zombieworldproject.zombieracore.managers.ZEOtherManager;
import zombieworldproject.zombieracore.managers.ZESoundManager;
import zombieworldproject.zombieracore.managers.ZESpawnManager;
import zombieworldproject.zombieracore.managers.ZETipsManager;
import zombieworldproject.zombieracore.managers.door.ZEDoorManager;
import zombieworldproject.zombieracore.managers.entity.ZEEntityManager;
import zombieworldproject.zombieracore.managers.immersion.ZETimeManager;
import zombieworldproject.zombieracore.managers.immersion.ZEWorldImmersionSoundManager;
import zombieworldproject.zombieracore.managers.immersion.events.ZEEventManager;
import zombieworldproject.zombieracore.managers.immersion.weather.ZEWeatherManager;
import zombieworldproject.zombieracore.managers.item.ZEItemManager;
import zombieworldproject.zombieracore.managers.item.ZERarityDropManager;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEBackpackManager;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.gun.ZEGunManager;
import zombieworldproject.zombieracore.managers.loot.ZELootCrateManager;
import zombieworldproject.zombieracore.managers.npc.ZENPCManager;
import zombieworldproject.zombieracore.managers.player.ZECombatLogManager;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.ZETitleOverlayManager;
import zombieworldproject.zombieracore.managers.player.messages.ZESpecialMessageManager;
import zombieworldproject.zombieracore.managers.player.skills.ZESkillsManager;
import zombieworldproject.zombieracore.managers.player.states.ZEStateManager;
import zombieworldproject.zombieracore.managers.props.ZEPropManager;
import zombieworldproject.zombieracore.managers.recipes.ZERecipeManager;
import zombieworldproject.zombieracore.managers.spawners.LocalSpawnerManager;
import zombieworldproject.zombieracore.managers.zones.ZEZoneManager;
import zombieworldproject.zombieracore.remote.api.ApiClient;
import zombieworldproject.zombieracore.remote.database.DBManager;
import zombieworldproject.zombieracore.world.ZEChunkGenerator;
import zombieworldproject.zombieracore.world.structuremanager.ZEStructureManager;

public final class ZombiEraCore
extends JavaPlugin {
    public static ZombiEraCore instance;
    public ZEEventManager eventManager;
    public ZEWorldImmersionSoundManager worldImmersionSoundManager;
    private DBManager databaseManager;
    private ZEItemManager itemManager;
    private ZELootCrateManager lootManager;
    private ZERarityDropManager rarityDropManager;
    private ZEPropManager propManager;
    private ZEEntityManager entityManager;
    private ZESoundManager soundManager;
    private ZENPCManager npcManager;
    private ZESpecialMessageManager playerActionBarManager;
    private ZEGunManager playerBulletsManager;
    private ZombiEraConfig zombiEraConfig;
    private ZEStateManager playerHealthManager;
    private ZEBackpackManager backpackManager;
    private ZEZoneManager zoneManager;
    private ZESpawnManager spawnManager;
    private ZEDoorManager doorManager;
    private ZETimeManager realTimeManager;
    private ZERecipeManager recipeManager;
    private ZEBossBarManager bossBarManager;
    private ZETipsManager tipsManager;
    private ZEOtherManager otherManager;
    private ZEIconsManager iconsManager;
    private ZESkillsManager skillsManager;
    private boolean licenceStop = false;
    private ZECombatLogManager combatLogManager;
    private ZEWeatherManager weatherManager;
    private ZETitleOverlayManager titleOverlayManager;
    private LocalSpawnerManager localSpawnerManager;

    public static void debugInfo(String msg) {
        Bukkit.getServer().getConsoleSender().sendMessage(String.format("[%s]: ", ZombiEraSettings.PLUGIN_NAME) + msg);
    }

    public static void playerInfo(CommandSender sender, String msg) {
        sender.sendMessage(String.format("%s[%s]%s: %s", ChatColor.YELLOW, ZombiEraSettings.PLUGIN_NAME, ChatColor.WHITE, msg));
    }

    public static void playerInfo(Player player, String msg) {
        player.sendMessage(String.format("%s[%s]%s: %s", ChatColor.YELLOW, ZombiEraSettings.PLUGIN_NAME, ChatColor.WHITE, msg));
    }

    public static void allPlayerInfo(String msg) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(String.format("%s[%s]%s: %s", ChatColor.YELLOW, ZombiEraSettings.PLUGIN_NAME, ChatColor.WHITE, msg));
        }
    }

    public static ZEOtherManager getOtherManager() {
        return ZombiEraCore.instance.otherManager;
    }

    public static ZombiEraConfig getZombiEraConfigManager() {
        return ZombiEraCore.instance.zombiEraConfig;
    }

    public static ZEItemManager getItemManager() {
        return ZombiEraCore.instance.itemManager;
    }

    public static ZELootCrateManager getLootManager() {
        return ZombiEraCore.instance.lootManager;
    }

    public static ZERarityDropManager getRarityDropManager() {
        return ZombiEraCore.instance.rarityDropManager;
    }

    public static ZEPropManager getPropManager() {
        return ZombiEraCore.instance.propManager;
    }

    public static ZEEntityManager getEntityManager() {
        return ZombiEraCore.instance.entityManager;
    }

    public static ZESoundManager getSoundManager() {
        return ZombiEraCore.instance.soundManager;
    }

    public static ZENPCManager getNPCManager() {
        return ZombiEraCore.instance.npcManager;
    }

    public static ZEBackpackManager getBackpackManager() {
        return ZombiEraCore.instance.backpackManager;
    }

    public static ZEZoneManager getZoneManager() {
        return ZombiEraCore.instance.zoneManager;
    }

    public static ZESpawnManager getSpawnManager() {
        return ZombiEraCore.instance.spawnManager;
    }

    public static ZEDoorManager getDoorManager() {
        return ZombiEraCore.instance.doorManager;
    }

    public static ZERecipeManager getRecipeManager() {
        return ZombiEraCore.instance.recipeManager;
    }

    public static ZEBossBarManager getBossBarManager() {
        return ZombiEraCore.instance.bossBarManager;
    }

    public static ZETipsManager getTipsManager() {
        return ZombiEraCore.instance.tipsManager;
    }

    public static ZEIconsManager getIconsManager() {
        return ZombiEraCore.instance.iconsManager;
    }

    public static ZESkillsManager getSkillsManager() {
        return ZombiEraCore.instance.skillsManager;
    }

    public static ZEEventManager getEventManager() {
        return ZombiEraCore.instance.eventManager;
    }

    public static ZETimeManager getRealTimeManager() {
        return ZombiEraCore.instance.realTimeManager;
    }

    public static ZEWorldImmersionSoundManager getWorldImmersionSoundManager() {
        return ZombiEraCore.instance.worldImmersionSoundManager;
    }

    public static ZEWeatherManager getWeatherManager() {
        return ZombiEraCore.instance.weatherManager;
    }

    public static ZETitleOverlayManager getTitleOverlayManager() {
        return ZombiEraCore.instance.titleOverlayManager;
    }

    public static ZECombatLogManager getCombatLogManager() {
        return ZombiEraCore.instance.combatLogManager;
    }

    public static LocalSpawnerManager getLocalSpawnerManager() {
        return ZombiEraCore.instance.localSpawnerManager;
    }

    public static void importantDebugInfo(String msg) {
        ZombiEraCore.debugInfo(" ");
        ZombiEraCore.debugInfo(String.valueOf(ChatColor.YELLOW) + "----------------------------- " + String.valueOf(ChatColor.WHITE) + ZombiEraSettings.PLUGIN_NAME + String.valueOf(ChatColor.YELLOW) + " -----------------------------");
        ZombiEraCore.debugInfo(" ");
        String[] lines = msg.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            ZombiEraCore.debugInfo(lines[i]);
        }
        ZombiEraCore.debugInfo(" ");
        ZombiEraCore.debugInfo(String.valueOf(ChatColor.YELLOW) + "-----------------------------" + "-".repeat(ZombiEraSettings.PLUGIN_NAME.length() + 2) + "-----------------------------");
        ZombiEraCore.debugInfo(" ");
    }

    public boolean verify_api() {
        String baseUrl = "https://zombiera.net";
        String verifyUrl = "https://zombiera.net/api/verify_key";
        String apiKey = ZombiEraSettings.REMOTE_API_KEY;
        ApiClient client = new ApiClient(baseUrl, verifyUrl, apiKey);
        return client.validateKey();
    }

    public void onEnable() {
        instance = this;
        this.zombiEraConfig = new ZombiEraConfig();
        ZombiEraCore.importantDebugInfo(String.valueOf(ChatColor.AQUA) + "Important Notice: Never attempt to reload the plugin using commands like /reload or plugins such as PlugMan. Doing so can be risky and may lead to unexpected issues. The only safe and recommended method to reload the plugin is by restarting your server. If you need to refresh configuration settings, use the command /zreload instead.\n" + String.valueOf(ChatColor.AQUA) + "Please be aware that if you use /reload, specific property entities may cease to function, and other features could also be affected. To restore full functionality, it's essential to restart your server after reloading the plugin.");
        this.iconsManager = new ZEIconsManager();
        this.recipeManager = new ZERecipeManager();
        this.itemManager = new ZEItemManager();
        this.lootManager = new ZELootCrateManager();
        this.rarityDropManager = new ZERarityDropManager();
        this.propManager = new ZEPropManager();
        this.entityManager = new ZEEntityManager();
        this.soundManager = new ZESoundManager();
        this.npcManager = new ZENPCManager();
        this.playerHealthManager = new ZEStateManager();
        this.playerActionBarManager = new ZESpecialMessageManager();
        this.playerBulletsManager = new ZEGunManager();
        this.backpackManager = new ZEBackpackManager();
        this.bossBarManager = new ZEBossBarManager();
        this.zoneManager = new ZEZoneManager();
        this.spawnManager = new ZESpawnManager();
        this.doorManager = new ZEDoorManager();
        this.eventManager = new ZEEventManager();
        this.tipsManager = new ZETipsManager();
        this.realTimeManager = new ZETimeManager();
        this.skillsManager = new ZESkillsManager();
        this.otherManager = new ZEOtherManager();
        this.combatLogManager = new ZECombatLogManager();
        this.worldImmersionSoundManager = new ZEWorldImmersionSoundManager();
        this.weatherManager = new ZEWeatherManager();
        this.weatherManager.run();
        this.worldImmersionSoundManager.run();
        this.localSpawnerManager = new LocalSpawnerManager();
        this.titleOverlayManager = new ZETitleOverlayManager();
        this.rarityDropManager.Initialize();
        ZEStructureManager.loadFileStructures();
        this.zombiEraConfig.initialize();
        if (!this.verify_api()) {
            ZombiEraCore.debugInfo("Invalid API key! Please get one at https://zombiera.net");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            this.licenceStop = true;
            return;
        }
        ZombiEraCore.debugInfo("API key verified!");
        this.propManager.initialize();
        this.npcManager.initialize();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                ZEScoreBoardManager.Initialize();
                ZEPlayerManagers.getSpecialMessagesManager().Initialize();
            }
        });
        this.localSpawnerManager.run();
        new EntitiesHandler(this);
        new PlayerHandler(this);
        new WorldHandler(this);
        new InventoryHandler(this);
        new ChunkHandler(this);
        new RecipeHandler(this);
        PacketHandler packetHandler = new PacketHandler();
        packetHandler.addPacketListeners();
        this.getCommand("zgive").setExecutor((CommandExecutor)new GiveItemCommand());
        this.getCommand("zreload").setExecutor((CommandExecutor)new ReloadCommand());
        this.getCommand("zsummon").setExecutor((CommandExecutor)new SummonCommand());
        this.getCommand("zshowequipment").setExecutor((CommandExecutor)new EquipmentCommand());
        this.getCommand("zstructure").setExecutor((CommandExecutor)new StructureCommand());
        this.getCommand("znpc").setExecutor((CommandExecutor)new NPCCommand());
        this.getCommand("zprop").setExecutor((CommandExecutor)new PropCommand());
        this.getCommand("zloot").setExecutor((CommandExecutor)new LootCommand());
        this.getCommand("zzone").setExecutor((CommandExecutor)new ZoneCommand());
        this.getCommand("zspawn").setExecutor((CommandExecutor)new SpawnCommand());
        this.getCommand("zsetspawn").setExecutor((CommandExecutor)new SetSpawnCommand());
        this.getCommand("zrandomspawn").setExecutor((CommandExecutor)new RandomSpawnCommand());
        this.getCommand("zeditrandomspawns").setExecutor((CommandExecutor)new EditRandomSpawnsCommands());
        this.getCommand("zsuicide").setExecutor((CommandExecutor)new SuicideCommand());
        this.getCommand("zkeycard").setExecutor((CommandExecutor)new KeycardCommand());
        this.getCommand("zevent").setExecutor((CommandExecutor)new EventCommand());
        this.getCommand("zlocalchat").setExecutor((CommandExecutor)new LocalChatCommand());
        this.getCommand("zbalance").setExecutor((CommandExecutor)new BalanceCommand());
        this.getCommand("zpay").setExecutor((CommandExecutor)new PayCommand());
        this.getCommand("zdoor").setExecutor((CommandExecutor)new PlayerDoorCommand());
        this.getCommand("zblueprints").setExecutor((CommandExecutor)new BlueprintsCommand());
        this.getCommand("zstop").setExecutor((CommandExecutor)new StopCommand());
        this.getCommand("zweather").setExecutor((CommandExecutor)new WeatherCommand());
        this.getCommand("zlocations").setExecutor((CommandExecutor)new LocationsCommand());
        this.getCommand("zwipe").setExecutor((CommandExecutor)new WipeCommand());
        this.getCommand("zheal").setExecutor((CommandExecutor)new HealCommand());
        this.getCommand("ztime").setExecutor((CommandExecutor)new TimeCommand());
        this.getCommand("zspawner").setExecutor((CommandExecutor)new SpawnerCommand());
        this.getCommand("zgive").setTabCompleter((TabCompleter)new GiveItemTabComplete());
        this.getCommand("zsummon").setTabCompleter((TabCompleter)new SummonTabComplete());
        this.getCommand("zstructure").setTabCompleter((TabCompleter)new StructureTabComplete());
        this.getCommand("znpc").setTabCompleter((TabCompleter)new NPCTabComplete());
        this.getCommand("zprop").setTabCompleter((TabCompleter)new PropTabComplete());
        this.getCommand("zloot").setTabCompleter((TabCompleter)new LootTabComplete());
        this.getCommand("zzone").setTabCompleter((TabCompleter)new ZoneTabComplete());
        this.getCommand("zeditrandomspawns").setTabCompleter((TabCompleter)new EditRandomSpawnsTabComplete());
        this.getCommand("zkeycard").setTabCompleter((TabCompleter)new KeycardTabComplete());
        this.getCommand("zevent").setTabCompleter((TabCompleter)new EventTabComplete());
        this.getCommand("zlocalchat").setTabCompleter((TabCompleter)new LocalChatTabComplete());
        this.getCommand("zpay").setTabCompleter((TabCompleter)new PayTabComplete());
        this.getCommand("zdoor").setTabCompleter((TabCompleter)new PlayerDoorTabComplete());
        this.getCommand("zbalance").setTabCompleter((TabCompleter)new BalanceTabComplete());
        this.getCommand("zblueprints").setTabCompleter((TabCompleter)new BlueprintsTabComplete());
        this.getCommand("zweather").setTabCompleter((TabCompleter)new WeatherTabComplete());
        this.getCommand("zlocations").setTabCompleter((TabCompleter)new LocationsTabComplete());
        this.getCommand("zheal").setTabCompleter((TabCompleter)new HealTabComplete());
        this.getCommand("ztime").setTabCompleter((TabCompleter)new TimeTabComplete());
        this.getCommand("zspawner").setTabCompleter((TabCompleter)new SpawnerTabComplete());
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.playerHealthManager.onPlayerJoin(player);
        }
    }

    public void onDisable() {
        if (!this.licenceStop) {
            ZombiEraCore.debugInfo("Saving player equipment...");
            List<ZEEquipmentsManager.EquipmentInventory> inventoryList = ZEEquipmentsManager.playerEquipmentInventories.values().stream().toList();
            for (int i = 0; i < inventoryList.size(); ++i) {
                inventoryList.get(i).playerLeave();
            }
            ZombiEraCore.debugInfo("Deleting props...");
            this.propManager.deleteAllUnsavedProps();
            ZombiEraCore.getNPCManager().disablePlugin();
            ZombiEraCore.getBossBarManager().disablePlugin();
        }
        ZombiEraCore.debugInfo("Shutting down!");
    }

    public ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, String id) {
        if (worldName == null) {
            ZombiEraCore.$$$reportNull$$$0(0);
        }
        ZombiEraCore.debugInfo("ZombieWorldChunkGenerator is being used!");
        return new ZEChunkGenerator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "worldName", "zombieworldproject/zombieracore/ZombiEraCore", "getDefaultWorldGenerator"));
    }

    public static class ZEPlayerManagers {
        public static ZESpecialMessageManager getSpecialMessagesManager() {
            return ZombiEraCore.instance.playerActionBarManager;
        }

        public static ZEGunManager getGunsManager() {
            return ZombiEraCore.instance.playerBulletsManager;
        }

        public static ZEStateManager getHealthManager() {
            return ZombiEraCore.instance.playerHealthManager;
        }
    }
}

