/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.commands.cmds;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class BlueprintsCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (sender == null) {
            BlueprintsCommand.$$$reportNull$$$0(0);
        }
        if (cmd == null) {
            BlueprintsCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            BlueprintsCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can run this command!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 2 && args[0].equalsIgnoreCase("learned")) {
            int page;
            try {
                page = Integer.parseInt(args[1]) - 1;
            }
            catch (NumberFormatException e) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "Page must be a number!");
                return true;
            }
            List<List<String>> pages = MiscUtils.splitAndSortList(ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth((Player)player).knownBlueprints, 54);
            if (pages.isEmpty()) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "You have no blueprints learned!");
                return true;
            }
            if (page < 0 || page >= pages.size()) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "No such page of blueprints!");
                return true;
            }
            List<String> blueprints = pages.get(page);
            Inventory inventory = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_BLUE) + "Learned Blueprints"));
            blueprints.forEach(val -> {
                try {
                    String id = val.split("bp_")[1];
                    ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(id);
                    if (itemBase != null) {
                        inventory.addItem(new ItemStack[]{itemBase.getItem()});
                    }
                }
                catch (Exception ex) {
                    ZombiEraCore.debugInfo("Failed to load blueprint: " + val);
                }
            });
            player.openInventory(inventory);
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("unlearned")) {
            int page;
            try {
                page = Integer.parseInt(args[1]) - 1;
            }
            catch (NumberFormatException e) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "Page must be a number!");
                return true;
            }
            List<String> known = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth((Player)player).knownBlueprints;
            ArrayList<String> allItemNames = new ArrayList<String>(ZombiEraCore.getItemManager().getMappedItemBasesByName().keySet());
            ArrayList<String> allBlueprints = new ArrayList<String>();
            for (String name : allItemNames) {
                if (!name.contains("bp_")) continue;
                allBlueprints.add(name);
            }
            allBlueprints.removeAll(known);
            List<List<String>> pages = MiscUtils.splitAndSortList(allBlueprints, 54);
            if (pages.isEmpty()) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.GREEN) + "You\u2019ve learned all available blueprints!");
                return true;
            }
            if (page < 0 || page >= pages.size()) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "No such page of blueprints!");
                return true;
            }
            List<String> blueprints = pages.get(page);
            Inventory inventory = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_GRAY) + "Unlearned Blueprints"));
            blueprints.forEach(val -> {
                try {
                    String id = val.split("bp_")[1];
                    ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(id);
                    if (itemBase != null) {
                        inventory.addItem(new ItemStack[]{itemBase.getItem()});
                    } else {
                        ZombiEraCore.debugInfo("Missing item base for: " + id);
                    }
                }
                catch (Exception ex) {
                    ZombiEraCore.debugInfo("Invalid blueprint name: " + val);
                }
            });
            player.openInventory(inventory);
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage:");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "  /blueprints learned <page>   " + String.valueOf(ChatColor.WHITE) + "- View learned blueprints");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "  /blueprints unlearned <page> " + String.valueOf(ChatColor.WHITE) + "- View blueprints not yet learned");
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cmd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "label";
                break;
            }
        }
        objectArray[1] = "zombieworldproject/zombieracore/commands/cmds/BlueprintsCommand";
        objectArray[2] = "onCommand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

