/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.commands.cmds;

import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Door;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.door.DoorTypes;
import zombieworldproject.zombieracore.managers.door.PlayerDoor;
import zombieworldproject.zombieracore.managers.door.ZDoor;
import zombieworldproject.zombieracore.managers.door.ZEDoorManager;

public class PlayerDoorCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (sender == null) {
            PlayerDoorCommand.$$$reportNull$$$0(0);
        }
        if (cmd == null) {
            PlayerDoorCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            PlayerDoorCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can run this command!");
            return true;
        }
        Player player = (Player)sender;
        ZEDoorManager doorManager = ZombiEraCore.getDoorManager();
        Block block = player.getTargetBlock(null, 5);
        if (!(block.getBlockData() instanceof Door) || block.getType().equals((Object)Material.IRON_DOOR)) {
            ZombiEraCore.playerInfo(player, "You can interact only with a wooden door block! (Look at it)");
            return true;
        }
        if (args.length == 1 && args[0].equals("remove")) {
            ZDoor door = doorManager.getDoor(block);
            if (door == null || !door.getType().equals((Object)DoorTypes.PLAYER)) {
                ZombiEraCore.playerInfo(player, "This is not player's door!");
                return true;
            }
            PlayerDoor playerDoor = (PlayerDoor)door;
            if (playerDoor.isOwner(player)) {
                doorManager.removeLockedDoor(door);
                ItemStack doorLock = ZombiEraCore.getItemManager().getItemBase("doorlock").getItem();
                player.getInventory().addItem(new ItemStack[]{doorLock});
                ZombiEraCore.playerInfo(player, "The door lock has been successfully removed!");
                return true;
            }
            ZombiEraCore.playerInfo(player, "You cannot manage this door as you are not an owner!");
            return true;
        }
        if (args.length == 1 && args[0].equals("list")) {
            ZDoor door = doorManager.getDoorAtBlock(block);
            if (door == null || !door.getType().equals((Object)DoorTypes.PLAYER)) {
                ZombiEraCore.playerInfo(player, "This is not player's door!");
                return true;
            }
            PlayerDoor playerDoor = (PlayerDoor)door;
            if (playerDoor.isAllowed(player)) {
                List<String> UUIDs = ((PlayerDoor)door).allowedPlayersUUIDs;
                ZombiEraCore.playerInfo(player, "Allowed players to this door:");
                UUIDs.forEach(uuid -> {
                    OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
                    ZombiEraCore.playerInfo(player, offPlayer.getName());
                });
                return true;
            }
            ZombiEraCore.playerInfo(player, "You cannot manage this door as you don't have access!");
            return true;
        }
        if (args.length == 2 && args[0].equals("allow")) {
            ZDoor door = doorManager.getDoorAtBlock(block);
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                ZombiEraCore.playerInfo(player, "This player is currently not online!");
                return true;
            }
            if (targetPlayer == player) {
                ZombiEraCore.playerInfo(player, "You can't allow yourself to any door.");
                return true;
            }
            if (door == null || !door.getType().equals((Object)DoorTypes.PLAYER)) {
                ZombiEraCore.playerInfo(player, "This is not player's door!");
                return true;
            }
            PlayerDoor playerDoor = (PlayerDoor)door;
            if (playerDoor.isOwner(player)) {
                playerDoor.addPlayer(targetPlayer);
                ZombiEraCore.playerInfo(player, String.format("Player '%s' has been successfully added to this door.", args[1]));
                return true;
            }
            ZombiEraCore.playerInfo(player, "You cannot manage this door as you are not an owner!");
            return true;
        }
        if (args.length == 2 && args[0].equals("deny")) {
            ZDoor door = doorManager.getDoorAtBlock(block);
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                ZombiEraCore.playerInfo(player, "This player is currently not online!");
                return true;
            }
            if (targetPlayer == player) {
                ZombiEraCore.playerInfo(player, "You can't deny yourself from any door.");
                return true;
            }
            if (door == null || !door.getType().equals((Object)DoorTypes.PLAYER)) {
                ZombiEraCore.playerInfo(player, "This is not player's door!");
                return true;
            }
            PlayerDoor playerDoor = (PlayerDoor)door;
            if (playerDoor.isOwner(player)) {
                playerDoor.removePlayer(targetPlayer);
                ZombiEraCore.playerInfo(player, String.format("Player '%s' has been successfully denied from this door.", args[1]));
                return true;
            }
            ZombiEraCore.playerInfo(player, "You cannot manage this door as you are not an owner!");
            return true;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cmd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "label";
                break;
            }
        }
        objectArray[1] = "zombieworldproject/zombieracore/commands/cmds/PlayerDoorCommand";
        objectArray[2] = "onCommand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

