/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.commands.cmds;

import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropBase;
import zombieworldproject.zombieracore.managers.props.data.ChunkPropsData;
import zombieworldproject.zombieracore.managers.props.data.PropData;

public class PropCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (sender == null) {
            PropCommand.$$$reportNull$$$0(0);
        }
        if (cmd == null) {
            PropCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            PropCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can run this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("zombiera.admin")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don\u2019t have permission to use this command.");
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("spawn")) {
            String propName = args[1];
            if (ZombiEraCore.getPropManager().propItemsDirNames.containsKey(propName)) {
                PropBase specialProp = ZombiEraCore.getPropManager().propItems.get(ZombiEraCore.getPropManager().propItemsDirNames.get(propName));
                if (specialProp.isSaved().booleanValue()) {
                    specialProp.addPropToWorldNow(player.getLocation());
                    ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.GREEN) + "Spawned saved prop: " + String.valueOf(ChatColor.WHITE) + propName);
                } else {
                    ZombiEraCore.getPropManager().addPropToWorldNotSaved(specialProp, player.getLocation());
                    ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.YELLOW) + "Spawned temporary prop: " + String.valueOf(ChatColor.WHITE) + propName);
                }
            } else {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "No prop found with the name '" + propName + "'.");
            }
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("teleport")) {
            int id;
            try {
                id = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "Invalid prop ID! Must be a number.");
                return true;
            }
            PropData pd = ZombiEraCore.getPropManager().getPropDataById(id);
            if (pd == null) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "No prop found with ID " + id + ".");
                return true;
            }
            ZombiEraCore.getSpawnManager().tpPlayer(player, pd.getLocation());
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.GREEN) + "Teleported to prop ID " + id + ".");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("remove")) {
            Collection armorStands = player.getLocation().getNearbyEntitiesByType(ArmorStand.class, 5.0, 5.0, 5.0);
            boolean[] rememberMarkers = new boolean[armorStands.size()];
            int i = 0;
            for (Object as : armorStands) {
                rememberMarkers[i] = as.isMarker();
                if (!as.isSmall()) {
                    as.setMarker(false);
                }
                ++i;
            }
            RayTraceResult res = player.getWorld().rayTraceEntities(player.getEyeLocation().add(player.getLocation().getDirection()), player.getEyeLocation().getDirection(), 5.0, entity -> !entity.getUniqueId().equals(player.getUniqueId()));
            i = 0;
            for (ArmorStand as : armorStands) {
                if (!as.isSmall()) {
                    as.setMarker(rememberMarkers[i]);
                }
                ++i;
            }
            if (res == null) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "No entity found in view.");
                return true;
            }
            Entity entity2 = res.getHitEntity();
            if (entity2 == null) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "No entity hit in ray trace.");
                return true;
            }
            PropData pd = ZombiEraCore.getPropManager().propDataMapNotSaved.get(entity2.getEntityId());
            if (pd != null) {
                pd.deSpawn();
                ZombiEraCore.getPropManager().propDataMapNotSaved.remove(entity2.getEntityId());
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.GREEN) + "Removed temporary prop successfully!");
                return true;
            }
            Chunk chunk = entity2.getChunk();
            ChunkPropsData cpd = ZombiEraCore.getPropManager().getChunkPropsData(chunk.getX(), chunk.getZ(), chunk.getWorld());
            if (cpd != null && entity2 instanceof ArmorStand && cpd.removePropByEntityId(entity2.getEntityId())) {
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.GREEN) + "Removed saved prop successfully!");
                return true;
            }
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.YELLOW) + "Entity removed, but it wasn't a registered ZombieWorld prop.");
            entity2.remove();
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage:");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "  /prop spawn <name>" + String.valueOf(ChatColor.WHITE) + " - Spawn a prop");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "  /prop teleport <id>" + String.valueOf(ChatColor.WHITE) + " - Teleport to a prop");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "  /prop remove" + String.valueOf(ChatColor.WHITE) + " - Remove the prop you are looking at");
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cmd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "label";
                break;
            }
        }
        objectArray[1] = "zombieworldproject/zombieracore/commands/cmds/PropCommand";
        objectArray[2] = "onCommand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

