/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.commands.cmds;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.zones.ZoneTypes;

public class ZoneCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (sender == null) {
            ZoneCommand.$$$reportNull$$$0(0);
        }
        if (cmd == null) {
            ZoneCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            ZoneCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can run this command!");
            return true;
        }
        Player player = (Player)sender;
        if (player.hasPermission("zombiera.admin")) {
            if (args.length > 2 && args[0].equals("create")) {
                ZoneTypes zoneType;
                String zoneDirname = args[1];
                try {
                    zoneType = ZoneTypes.valueOf(args[2]);
                }
                catch (IllegalArgumentException exception) {
                    ZombiEraCore.playerInfo(player, "Error. This is not a valid ZoneType!");
                    return true;
                }
                String boxData = null;
                if (args[3].contains(",")) {
                    boxData = args[3];
                } else {
                    Double radius;
                    try {
                        radius = Double.parseDouble(args[3]);
                    }
                    catch (NumberFormatException exception) {
                        ZombiEraCore.playerInfo(player, "Error. Radius value must be type of Double! (e.g: 1.4)");
                        return true;
                    }
                    boxData = radius.toString();
                }
                if (zoneType.equals((Object)ZoneTypes.RADIATION)) {
                    Double hazardLevel;
                    try {
                        hazardLevel = Double.parseDouble(args[4]);
                    }
                    catch (NumberFormatException exception) {
                        ZombiEraCore.playerInfo(player, "Error. Hazard value must be type of Double! (e.g: 0 - 100)");
                        return true;
                    }
                    if (args.length == 6) {
                        String configZone = args[5];
                        ZombiEraCore.getZoneManager().addRadiationZone(zoneDirname, player.getLocation(), boxData, hazardLevel, configZone);
                    } else {
                        ZombiEraCore.getZoneManager().addRadiationZone(zoneDirname, player.getLocation(), boxData, hazardLevel);
                    }
                } else {
                    boolean success;
                    if (args.length == 5) {
                        String configZone = args[4];
                        success = ZombiEraCore.getZoneManager().addZone(zoneDirname, zoneType, player.getLocation(), boxData, configZone);
                    } else {
                        success = ZombiEraCore.getZoneManager().addZone(zoneDirname, zoneType, player.getLocation(), boxData);
                    }
                    if (!success) {
                        ZombiEraCore.playerInfo(player, "ZoneType not allowed or zone with this dirName already exists.");
                        return true;
                    }
                }
                ZombiEraCore.playerInfo(player, "Zone successfully created!");
            } else if (args.length == 1 && args[0].equals("list")) {
                ZombiEraCore.getZoneManager().printOutZonesToPlayer(player);
            } else if (args.length == 2 && args[0].equals("remove")) {
                String zoneDirname = args[1];
                boolean success = ZombiEraCore.getZoneManager().removeZone(zoneDirname);
                if (success) {
                    ZombiEraCore.playerInfo(player, "Zone removed.");
                } else {
                    ZombiEraCore.playerInfo(player, "Zone index is not in the zone manager database! Use '/zzone list' to find out!");
                }
            } else if (args.length == 1 && args[0].equals("reload")) {
                ZombiEraCore.getZoneManager().reloadZones();
                ZombiEraCore.playerInfo(player, "Zones reloaded!");
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cmd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "label";
                break;
            }
        }
        objectArray[1] = "zombieworldproject/zombieracore/commands/cmds/ZoneCommand";
        objectArray[2] = "onCommand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

