/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.handlers;

import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.npc.NPCBase;
import zombieworldproject.zombieracore.managers.props.data.ChunkPropsData;
import zombieworldproject.zombieracore.managers.props.data.PropData;

public class ChunkHandler
implements Listener {
    private final ChunkEntityManager entityManager;
    private final ChunkPropManager propManager;

    public ChunkHandler(ZombiEraCore plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.entityManager = new ChunkEntityManager();
        this.propManager = new ChunkPropManager();
    }

    @EventHandler
    public void OnChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        ChunkPropsData propsData = ZombiEraCore.getPropManager().getChunkPropsData(chunk.getX(), chunk.getZ(), event.getWorld());
        this.entityManager.processChunkEntities(chunk);
        this.propManager.handleChunkPropsOnLoad(chunk, propsData);
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        ChunkPropsData propsData = ZombiEraCore.getPropManager().getChunkPropsData(chunk.getX(), chunk.getZ(), event.getWorld());
        this.propManager.handleChunkPropsOnUnload(propsData);
        this.entityManager.cleanupChunkEntities(chunk);
    }

    private static class ChunkEntityManager {
        private static final EntityType[] EXCLUDED_ENTITY_TYPES = new EntityType[]{EntityType.PLAYER, EntityType.ITEM_FRAME, EntityType.BLOCK_DISPLAY};

        private ChunkEntityManager() {
        }

        public void processChunkEntities(Chunk chunk) {
            for (Entity entity : chunk.getEntities()) {
                if (this.isExcludedEntityType(entity)) continue;
                if (entity instanceof ArmorStand) {
                    entity.remove();
                    continue;
                }
                if (entity instanceof Villager) {
                    Villager villager = (Villager)entity;
                    this.handleVillagerEntity(villager);
                    continue;
                }
                if (ZombiEraCore.getEntityManager().isRegisteredEntity(entity.getEntityId()).booleanValue()) continue;
                entity.remove();
            }
        }

        public void cleanupChunkEntities(Chunk chunk) {
            for (Entity entity : chunk.getEntities()) {
                if (this.isExcludedEntityType(entity)) continue;
                entity.remove();
            }
        }

        private boolean isExcludedEntityType(Entity entity) {
            for (EntityType excludedType : EXCLUDED_ENTITY_TYPES) {
                if (!entity.getType().equals((Object)excludedType)) continue;
                return true;
            }
            return false;
        }

        private void handleVillagerEntity(Villager villager) {
            NPCBase npc = ZombiEraCore.getNPCManager().getNPCByLocation(villager.getLocation());
            if (npc != null) {
                npc.spawn();
                npc.setEquipment();
                ZombiEraCore.debugInfo("Respawned NPC");
            } else {
                villager.remove();
            }
        }
    }

    private static class ChunkPropManager {
        private ChunkPropManager() {
        }

        public void handleChunkPropsOnLoad(Chunk chunk, ChunkPropsData propsData) {
            this.handleUnsavedProps(chunk);
            if (propsData != null) {
                propsData.loadAll();
            }
        }

        public void handleChunkPropsOnUnload(ChunkPropsData propsData) {
            if (propsData != null) {
                propsData.unloadAll();
            }
        }

        private void handleUnsavedProps(Chunk chunk) {
            for (PropData value : ZombiEraCore.getPropManager().propDataNotSaved) {
                if (!value.getLocation().getChunk().equals((Object)chunk) || value.isSpawned().booleanValue()) continue;
                value.spawn();
            }
        }
    }
}

