/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.handlers;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.plugin.Plugin;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.handlers.entity.EntityCombustHandler;
import zombieworldproject.zombieracore.handlers.entity.EntityDamageHandler;
import zombieworldproject.zombieracore.handlers.entity.EntityDeathHandler;
import zombieworldproject.zombieracore.handlers.entity.EntityItemHandler;
import zombieworldproject.zombieracore.handlers.entity.EntityPotionHandler;
import zombieworldproject.zombieracore.handlers.entity.EntityProjectileHandler;
import zombieworldproject.zombieracore.handlers.entity.EntitySpawnHandler;
import zombieworldproject.zombieracore.handlers.entity.EntityTargetHandler;
import zombieworldproject.zombieracore.handlers.entity.EntityTradeHandler;

public class EntitiesHandler
implements Listener {
    public static Map<Integer, Integer> uniqueEggIds = new HashMap<Integer, Integer>();
    private final EntityDeathHandler deathHandler;
    private final EntityDamageHandler damageHandler;
    private final EntityTargetHandler targetHandler;
    private final EntitySpawnHandler spawnHandler;
    private final EntityItemHandler itemHandler;
    private final EntityProjectileHandler projectileHandler;
    private final EntityPotionHandler potionHandler;
    private final EntityTradeHandler tradeHandler;
    private final EntityCombustHandler combustHandler;

    public EntitiesHandler(ZombiEraCore plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.deathHandler = new EntityDeathHandler();
        this.damageHandler = new EntityDamageHandler();
        this.targetHandler = new EntityTargetHandler();
        this.spawnHandler = new EntitySpawnHandler();
        this.itemHandler = new EntityItemHandler();
        this.projectileHandler = new EntityProjectileHandler();
        this.potionHandler = new EntityPotionHandler();
        this.tradeHandler = new EntityTradeHandler();
        this.combustHandler = new EntityCombustHandler();
    }

    @EventHandler
    public void onEntityPotionEffect(EntityPotionEffectEvent event) {
        this.potionHandler.handlePotionEffect(event);
    }

    @EventHandler
    public void onSpawnItem(ItemSpawnEvent event) {
        this.itemHandler.handleItemSpawn(event);
    }

    @EventHandler
    public void onEntityDropItem(EntityDropItemEvent event) {
        this.itemHandler.handleItemDrop(event);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        this.deathHandler.handleEntityDeath(event);
    }

    @EventHandler
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        this.targetHandler.handleEntityTarget(event);
    }

    @EventHandler
    public void onEggThrow(PlayerEggThrowEvent event) {
        this.projectileHandler.handleEggThrow(event);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        this.projectileHandler.handleProjectileHit(event);
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        this.spawnHandler.handleEntitySpawn(event);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        this.damageHandler.handleEntityDamage(event);
    }

    @EventHandler
    public void onVillagerTrade(VillagerAcquireTradeEvent event) {
        this.tradeHandler.handleVillagerTrade(event);
    }

    @EventHandler
    public void OnEntityHit(EntityDamageByEntityEvent event) {
        this.damageHandler.handleEntityDamageByEntity(event);
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        this.combustHandler.handleEntityCombust(event);
    }
}

