/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.handlers;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.ItemElectricalBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.EquitableTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.loot.LootCrate;
import zombieworldproject.zombieracore.managers.player.states.ActionStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class InventoryHandler
implements Listener {
    private static final int EQUIPMENT_SLOT = 8;
    private static final int TASK_DELAY_TICKS = 1;
    private static final char PROP_INVENTORY_PREFIX = 'p';
    private static final char BACKPACK_INVENTORY_PREFIX = 'b';
    private static final String BACKPACK_RETURN_MESSAGE = "Backpack items have been returned from the backpack! (You can't store backpack inside a backpack)";
    private static final String NO_FREE_SLOT_MESSAGE = "No free slot in inventory, unable to un-equip backpack!";
    private static final String NPC_INVENTORY_IDENTIFIER = "NPC";
    private static final String BLUEPRINTS_INVENTORY_IDENTIFIER = "Blueprints";
    private static final String DATA_KEY_COUNTER = "counter";
    private static final String DATA_KEY_GUN_CAPACITY = "g_cap";

    public InventoryHandler(ZombiEraCore plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getType() == InventoryType.CHEST) {
            this.handleChestInventoryClose(event);
        }
    }

    @EventHandler
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        Player player = (Player)event.getPlayer();
        this.handleMainHandItemOnInventoryOpen(player);
        this.stopPlayerItemUsage(player);
    }

    @EventHandler
    public void onInventoryDragEvent(InventoryDragEvent event) {
        if (this.isEquipmentInventory(event) && this.isTopInventory(event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        this.handlePropInventoryClick(event);
        this.scheduleItemHeldEventProcessing(event, player);
        if (player != null) {
            if (this.handleArmorSlotClick(event, player)) {
                return;
            }
            if (this.handleZoomedPlayerClick(event, player)) {
                return;
            }
            this.handleElectricalItemClick(event, player);
        }
        if (this.handleEquipmentSlotClick(event)) {
            return;
        }
        this.handleRightClickGunAction(event, player);
        this.handleSpecialInventoryClicks(event, player);
    }

    private void handleChestInventoryClose(InventoryCloseEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            this.handleLootCrateClose(chest);
        } else if (holder == null) {
            this.handleCustomInventoryClose(event);
        }
    }

    private void handleLootCrateClose(Chest chest) {
        String position = ZombiEraCore.getLootManager().getPos(chest.getX(), chest.getY(), chest.getZ());
        LootCrate crate = ZombiEraCore.getLootManager().lootCrates.get(position);
        if (crate != null) {
            crate.resetTimer();
        }
    }

    private void handleCustomInventoryClose(InventoryCloseEvent event) {
        String title = event.getView().getTitle();
        if (title.isEmpty()) {
            return;
        }
        char typePrefix = title.charAt(0);
        Integer inventoryId = this.parseInventoryId(title, typePrefix);
        if (inventoryId == null) {
            return;
        }
        if (typePrefix == 'p') {
            this.handlePropInventoryClose(event, inventoryId);
        } else if (typePrefix == 'b') {
            this.handleBackpackInventoryClose(event, inventoryId);
        }
    }

    private Integer parseInventoryId(String title, char typePrefix) {
        try {
            String idString = title.replace(String.valueOf(typePrefix), "");
            return Integer.parseInt(idString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void handlePropInventoryClose(InventoryCloseEvent event, Integer inventoryId) {
        PropData propData = this.getPropData(inventoryId);
        if (propData != null && propData.isLootAble().booleanValue()) {
            propData.getLootAblePropData().closeInventoryEvent(event);
            propData.getLootAblePropData().resetTimer();
        }
    }

    private void handleBackpackInventoryClose(InventoryCloseEvent event, Integer backpackId) {
        Player player = (Player)event.getPlayer();
        boolean itemsReturned = ZombiEraCore.getBackpackManager().giveBackpackItemsBack(player, backpackId);
        if (itemsReturned) {
            ZombiEraCore.playerInfo(player, BACKPACK_RETURN_MESSAGE);
        }
        ZombiEraCore.getBackpackManager().saveBackpackToFile(backpackId, player);
    }

    private PropData getPropData(Integer propId) {
        PropData propData = ZombiEraCore.getPropManager().propDataMap.get(propId);
        if (propData == null) {
            propData = ZombiEraCore.getPropManager().propDataMapNotSaved.get(propId);
        }
        return propData;
    }

    private void handleMainHandItemOnInventoryOpen(Player player) {
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        if (this.hasCustomModelData(mainHandItem)) {
            int itemId = mainHandItem.getItemMeta().getCustomModelData();
            ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(itemId);
            if (itemBase instanceof UsableItemBase) {
                UsableItemBase usableItemBase = (UsableItemBase)itemBase;
                usableItemBase.playerOpenInventoryEvent(player, mainHandItem);
            }
        }
    }

    private void stopPlayerItemUsage(Player player) {
        PlayerHealth playerHealth = this.getPlayerHealth(player);
        playerHealth.stopUsingItem();
    }

    private boolean isEquipmentInventory(InventoryDragEvent event) {
        return event.getView().getTitle().equals(ZEEquipmentsManager.EquipmentTitle);
    }

    private boolean isTopInventory(InventoryDragEvent event) {
        return event.getView().getTopInventory() == event.getInventory();
    }

    private void handlePropInventoryClick(InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder != null) {
            return;
        }
        String title = event.getView().getTitle();
        if (title.isEmpty()) {
            return;
        }
        char typePrefix = title.charAt(0);
        if (typePrefix != 'p') {
            return;
        }
        Integer propId = this.parseInventoryId(title, typePrefix);
        if (propId == null) {
            return;
        }
        PropData propData = this.getPropData(propId);
        if (propData != null && propData.isLootAble().booleanValue()) {
            propData.getLootAblePropData().clickInventory(event);
        }
    }

    private void scheduleItemHeldEventProcessing(final InventoryClickEvent event, final Player player) {
        final ItemStack itemBeforeClick = player.getInventory().getItemInMainHand();
        new BukkitRunnable(){

            public void run() {
                InventoryHandler.this.processItemHeldChanges(event, player, itemBeforeClick);
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 1L);
    }

    private void processItemHeldChanges(InventoryClickEvent event, Player player, ItemStack itemBeforeClick) {
        ItemStack itemAfterClick = player.getInventory().getItemInMainHand();
        ItemStack draggedItem = event.getCursor();
        this.handleDraggedItemEvent(player, draggedItem);
        this.handleMainHandItemChanges(player, itemBeforeClick, itemAfterClick);
    }

    private void handleDraggedItemEvent(Player player, ItemStack draggedItem) {
        if (this.hasCustomModelData(draggedItem)) {
            int itemId = draggedItem.getItemMeta().getCustomModelData();
            ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(itemId);
            if (itemBase instanceof UsableItemBase) {
                UsableItemBase usableItemBase = (UsableItemBase)itemBase;
                usableItemBase.playerItemHeldEvent(player, false, draggedItem);
            }
        }
    }

    private void handleMainHandItemChanges(Player player, ItemStack itemBefore, ItemStack itemAfter) {
        if (itemBefore.equals((Object)itemAfter)) {
            return;
        }
        if (this.isAir(itemBefore)) {
            this.handleItemAppeared(player, itemAfter);
            this.handleItemDisappeared(player, itemBefore);
        } else if (this.isAir(itemAfter)) {
            this.handleItemDisappeared(player, itemBefore);
        } else {
            this.handleItemAppeared(player, itemAfter);
        }
    }

    private void handleItemAppeared(Player player, ItemStack item) {
        if (this.hasCustomModelData(item)) {
            int itemId = item.getItemMeta().getCustomModelData();
            ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(itemId);
            if (itemBase instanceof UsableItemBase) {
                UsableItemBase usableItemBase = (UsableItemBase)itemBase;
                usableItemBase.playerItemHeldEvent(player, true, item);
            }
        }
    }

    private void handleItemDisappeared(Player player, ItemStack item) {
        if (this.hasCustomModelData(item)) {
            int itemId = item.getItemMeta().getCustomModelData();
            ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(itemId);
            if (itemBase instanceof UsableItemBase) {
                UsableItemBase usableItemBase = (UsableItemBase)itemBase;
                usableItemBase.playerItemHeldEvent(player, false, item);
            }
        }
    }

    private boolean handleArmorSlotClick(InventoryClickEvent event, Player player) {
        if (event.getSlotType() != InventoryType.SlotType.ARMOR) {
            return false;
        }
        ItemStack armorItem = player.getInventory().getItem(event.getSlot());
        if (armorItem != null) {
            this.moveArmorToInventory(player, event.getSlot(), armorItem);
            this.scheduleEquipmentUpdate(player);
            event.setCancelled(true);
        }
        return true;
    }

    private void moveArmorToInventory(Player player, int slot, ItemStack armorItem) {
        player.getInventory().addItem(new ItemStack[]{armorItem});
        player.getInventory().setItem(slot, null);
    }

    private void scheduleEquipmentUpdate(Player player) {
        final ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (equipmentInventory != null) {
            new BukkitRunnable(){

                public void run() {
                    equipmentInventory.setItems();
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 1L);
        }
    }

    private boolean handleZoomedPlayerClick(InventoryClickEvent event, Player player) {
        if (ZombiEraCore.ZEPlayerManagers.getGunsManager().getZoomedPlayer(player) != null) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    private void handleElectricalItemClick(InventoryClickEvent event, Player player) {
        ItemElectricalBase electricalItem;
        PlayerHealth playerHealth = this.getPlayerHealth(player);
        if (!playerHealth.getLastActionState().equals((Object)ActionStates.USED_ELECTRIC_ITEM)) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (!this.hasCustomModelData(clickedItem)) {
            return;
        }
        int itemId = clickedItem.getItemMeta().getCustomModelData();
        ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(itemId);
        if (itemBase instanceof ItemElectricalBase && (electricalItem = (ItemElectricalBase)((Object)itemBase)).doesNeedBattery()) {
            Integer capacity = (Integer)playerHealth.getDataStorage().getData(DATA_KEY_COUNTER);
            ItemUtils.setCapacity(clickedItem, capacity);
        }
    }

    private boolean handleEquipmentSlotClick(InventoryClickEvent event) {
        if (event.getSlot() == 8 && event.getClickedInventory().getType() == InventoryType.PLAYER) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    private void handleRightClickGunAction(InventoryClickEvent event, Player player) {
        if (event.getClick() != ClickType.RIGHT) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (!this.hasCustomModelData(clickedItem)) {
            return;
        }
        int itemId = clickedItem.getItemMeta().getCustomModelData();
        ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(itemId);
        if (itemBase instanceof ArmedGunItemBase) {
            ArmedGunItemBase gunItem = (ArmedGunItemBase)itemBase;
            this.handleGunUnloading(event, player, clickedItem, gunItem);
        }
    }

    private void handleGunUnloading(InventoryClickEvent event, Player player, ItemStack gunItem, ArmedGunItemBase gunItemBase) {
        event.setCancelled(true);
        PlayerHealth playerHealth = this.getPlayerHealth(player);
        Integer bullets = this.getBulletCount(playerHealth, gunItem);
        if (bullets > 0) {
            this.giveAmmoToPlayer(player, gunItemBase, bullets);
            this.resetGunAmmo(playerHealth, gunItem);
        }
    }

    private Integer getBulletCount(PlayerHealth playerHealth, ItemStack gunItem) {
        Integer tempBullets = (Integer)playerHealth.getDataStorage().getData(DATA_KEY_GUN_CAPACITY);
        return tempBullets != null ? tempBullets : ItemUtils.getCapacity(gunItem);
    }

    private void giveAmmoToPlayer(Player player, ArmedGunItemBase gunItemBase, Integer bullets) {
        ItemStack ammoItem = ZombiEraCore.getItemManager().ammoTypesItems.get((Object)gunItemBase.ammoType).getItem();
        ammoItem.setAmount(bullets.intValue());
        player.getInventory().addItem(new ItemStack[]{ammoItem});
    }

    private void resetGunAmmo(PlayerHealth playerHealth, ItemStack gunItem) {
        Integer tempBullets = (Integer)playerHealth.getDataStorage().getData(DATA_KEY_GUN_CAPACITY);
        if (tempBullets != null) {
            playerHealth.getDataStorage().setData(DATA_KEY_GUN_CAPACITY, 0);
        }
        ItemUtils.setCapacity(gunItem, 0);
    }

    private void handleSpecialInventoryClicks(InventoryClickEvent event, Player player) {
        String inventoryTitle = event.getView().getTitle();
        if (inventoryTitle.contains(NPC_INVENTORY_IDENTIFIER) && this.isTopInventoryClick(event)) {
            ZombiEraCore.getNPCManager().onClickInventory(event, inventoryTitle);
        } else if (inventoryTitle.contains(BLUEPRINTS_INVENTORY_IDENTIFIER)) {
            event.setCancelled(true);
        } else if (inventoryTitle.equals(ZEEquipmentsManager.EquipmentTitle) && this.isTopInventoryClick(event)) {
            this.handleEquipmentInventoryClick(event, player);
        }
    }

    private boolean isTopInventoryClick(InventoryClickEvent event) {
        return event.getView().getTopInventory() == event.getClickedInventory() && event.getWhoClicked() instanceof Player;
    }

    private void handleEquipmentInventoryClick(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (!this.hasItemMeta(clickedItem)) {
            return;
        }
        String displayName = clickedItem.getItemMeta().getDisplayName();
        if (this.isShowEquipmentItem(displayName)) {
            this.executeShowEquipmentCommand(player);
            return;
        }
        if (this.hasCustomModelData(clickedItem)) {
            this.handleEquipmentItemClick(event, player, clickedItem);
        }
    }

    private boolean isShowEquipmentItem(String displayName) {
        ItemStack showEquipmentItem = ZEEquipmentsManager.defaultItems.get("showEquipment");
        return displayName.equals(showEquipmentItem.getItemMeta().getDisplayName());
    }

    private void executeShowEquipmentCommand(Player player) {
        player.performCommand("zshowequipment");
        player.closeInventory();
    }

    private void handleEquipmentItemClick(InventoryClickEvent event, Player player, ItemStack clickedItem) {
        int itemId = clickedItem.getItemMeta().getCustomModelData();
        ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(itemId);
        if (itemBase instanceof EquitableItemBase) {
            EquitableItemBase equitableItem = (EquitableItemBase)itemBase;
            if (equitableItem.type.equals((Object)EquitableTypes.BACKPACK)) {
                this.handleBackpackClick(event, player, clickedItem);
            }
        }
    }

    private void handleBackpackClick(InventoryClickEvent event, Player player, ItemStack backpackItem) {
        event.setCancelled(true);
        if (event.getClick().isRightClick()) {
            this.openBackpack(player, backpackItem);
        } else if (event.getClick().isLeftClick()) {
            this.unequipBackpack(event, player, backpackItem);
        }
    }

    private void openBackpack(Player player, ItemStack backpackItem) {
        int backpackId = ZombiEraCore.getBackpackManager().getID(backpackItem);
        ZombiEraCore.getBackpackManager().openBackPack(player, backpackId);
    }

    private void unequipBackpack(InventoryClickEvent event, Player player, ItemStack backpackItem) {
        if (player.getInventory().firstEmpty() == -1) {
            ZombiEraCore.playerInfo(player, NO_FREE_SLOT_MESSAGE);
            return;
        }
        player.getInventory().addItem(new ItemStack[]{backpackItem});
        event.getInventory().setItem(event.getSlot(), ZEEquipmentsManager.freeItemBackpack);
        this.scheduleEquipmentUpdate(player);
    }

    private boolean hasCustomModelData(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData();
    }

    private boolean hasItemMeta(ItemStack item) {
        return item != null && item.hasItemMeta();
    }

    private boolean isAir(ItemStack item) {
        return item.getType() == Material.AIR;
    }

    private PlayerHealth getPlayerHealth(Player player) {
        return ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
    }
}

