/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.handlers;

import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.ItemElectricalBase;
import zombieworldproject.zombieracore.managers.item.bases.ItemInsertSlot;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.food.CannedFoodItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.ScopedGunInfo;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.npc.NPCBase;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.states.ActionStates;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.player.states.PlayerStats;
import zombieworldproject.zombieracore.managers.props.ZEPropManager;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandClaimerProp;
import zombieworldproject.zombieracore.misc.other.ResourcePack;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class PlayerHandler
implements Listener {
    private static final String EQUIPMENT_ITEM_KEY = "equipment";
    private static final String BLUEPRINT_PREFIX = "bp_%s";
    private static final String CANOPENER_KEY = "canopener";
    private static final String PLAYER_DEATH_PROP = "player_death_prop";
    private static final String PLAYER_UUID_KEY = "player_uuid";
    private static final String DATABASE_KEY = "database";
    private static final String PLAYER_KEY = "player";
    private static final String COUNTER_KEY = "counter";
    private static final int EQUIPMENT_SLOT = 8;
    private static final int SNEAK_DELAY_TICKS = 12;
    private static final int PRONE_UPDATE_INTERVAL = 3;
    private static final int ITEM_HELD_DELAY = 1;
    private static final int SPRINT_ANIMATION_DELAY = 1;
    private static final int SPAWN_DELAY = 1;
    private static final int MIN_SLOT = 1;
    private static final int MAX_SLOT = 9;
    private static final float NORMAL_WALK_SPEED = 0.2f;
    private static final float PRONE_WALK_SPEED = 0.0f;
    private static final int SLOW_EFFECT_DURATION = 4;
    private static final int SLOW_EFFECT_AMPLIFIER = 10;
    private static final int ROTTEN_FLESH_SICKNESS_CHANCE = 70;
    private static final int MINIMUM_PRONE_PRESSES = 2;
    public static final Map<Player, ItemStack> playerEggThrows = new HashMap<Player, ItemStack>();
    private final List<Player> pronePlayers = new ArrayList<Player>();
    private final Map<Player, List<Player>> sneakPressTracker = new HashMap<Player, List<Player>>();
    private final ZombiEraCore plugin;

    public PlayerHandler(ZombiEraCore plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.sendWelcomeMessage(player);
        this.setupPlayerOnJoin(player);
        ZombiEraCore.getEntityManager().onPlayerJoin(event);
        this.applyResourcePackIfEnabled(player);
        event.setJoinMessage(this.createJoinMessage(player));
        this.handleItemHeldOnJoin(player);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        this.getPlayerStats(event.getPlayer()).playerMoveEvent(event);
    }

    @EventHandler
    public void onPlayerEquipArmor(PlayerArmorChangeEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = event.getNewItem();
        if (this.isBrokenEquitableItem(newItem)) {
            this.handleBrokenArmorEquip(event, player);
            return;
        }
        this.updateEquipmentInventory(player);
    }

    @EventHandler
    public void onPlayerMessage(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        PlayerHealth playerHealth = this.getPlayerHealth(player);
        if (playerHealth.isInserting().booleanValue()) {
            this.handleItemInsertion(event, player, playerHealth);
        } else {
            this.handleNormalChat(event, player);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.handleNPCInteraction(event, villager);
        }
    }

    @EventHandler
    public void onPlayerGlideEvent(EntityToggleGlideEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.isPlayerProne(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJumpEvent(PlayerJumpEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerProne(player)) {
            event.setCancelled(true);
            return;
        }
        if (this.isInSurvivalMode(player)) {
            ZombiEraCore.getBossBarManager().onPlayerJumpToggle(event);
        }
    }

    @EventHandler
    void onPlayerSprintToggle(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        if (this.isInSurvivalMode(player)) {
            ZombiEraCore.getBossBarManager().onPlayerSprintToggle(event);
        }
        if (!event.isCancelled()) {
            ZombiEraCore.ZEPlayerManagers.getGunsManager().sprintGunAnimation(event.isSprinting(), player);
        }
    }

    @EventHandler
    public void onPlayerToggleSneaking(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        this.updateEquipmentSneakState(player, event.isSneaking());
        this.handleProneLogic(player, event.isSneaking());
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        ZombiEraCore.getCombatLogManager().checkCombat(player);
        event.setQuitMessage(this.createLeaveMessage(player));
        this.cleanupPlayerData(player);
        this.handleItemHeldOnLeave(player);
        this.savePlayerStates(player);
        this.cleanupEquipmentInventory(player);
        this.resetPlayerGunStates(player);
        ZombiEraCore.getBossBarManager().onPlayerLeave(player);
        ZombiEraCore.getEntityManager().onPlayerQuit(event);
    }

    @EventHandler
    public void onPlayerItemSwitch(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        ScopedGunInfo scopeInfo = ZombiEraCore.ZEPlayerManagers.getGunsManager().getZoomedPlayer(player);
        if (this.isScopedWeaponActive(scopeInfo)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerItemPickup(PlayerPickupItemEvent event) {
        ItemStack item = event.getItem().getItemStack();
        if (this.hasCustomModelData(item)) {
            this.scheduleItemHeldCheck(event.getPlayer(), item.getItemMeta().getCustomModelData());
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ZombiEraCore.debugInfo("trigger");
        this.getPlayerHealth(player).stopUsingItem();
        this.scheduleSprintAnimation(player, player.isSprinting());
        this.handleItemUnheld(player, event.getPreviousSlot());
        this.handleItemHeld(player, event.getNewSlot());
        ZombiEraCore.ZEPlayerManagers.getGunsManager().setAllZoomedGunsToUnzoomed(player);
    }

    @EventHandler
    public void onPlayerItemSwap(PlayerSwapHandItemsEvent event) {
        this.handleItemSwap(event.getOffHandItem(), event, false);
        this.handleItemSwap(event.getMainHandItem(), event, true);
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent event) {
        Entity entity;
        if (this.isFallDamage(event) && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            ZombiEraCore.ZEPlayerManagers.getHealthManager().playerFall(event, player);
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        Player player;
        Recipe recipe = event.getRecipe();
        ItemStack item = recipe.getResult();
        if (!this.handleCraftingItem(item, player = (Player)event.getWhoClicked())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        ItemStack item = event.getItem();
        Material itemType = item.getType();
        if (this.isConsumableZEItem(itemType)) {
            this.handleZEItemConsumption(item, event);
        } else if (itemType == Material.ROTTEN_FLESH) {
            this.handleRottenFleshConsumption(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        if (this.isEquipmentItem(droppedItem)) {
            event.setCancelled(true);
            return;
        }
        this.handleUsableItemDrop(player, droppedItem);
        this.handleElectricalItemDrop(player, droppedItem);
        this.handleScopedWeaponDrop(player, event);
    }

    @EventHandler
    void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        event.setDeathMessage(null);
        ZombiEraCore.ZEPlayerManagers.getHealthManager().onPlayerDeath(player);
        ZombiEraCore.getEntityManager().onPlayerDeathEvent(event);
        this.handleScopedWeaponOnDeath(player, event);
        this.createPlayerDeathProp(player, event);
        this.updateKillerStats(event);
    }

    @EventHandler
    void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.isCommandTeleport(event)) {
            this.respawnEquipmentInventory(event.getPlayer());
        }
    }

    @EventHandler
    void onPlayerSpawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        ZombiEraCore.getCombatLogManager().removeCombat(player);
        this.setupPlayerInventoryOnSpawn(player);
        this.respawnEquipmentInventory(player);
        this.schedulePlayerSpawn(player);
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        ZombiEraCore.getPropManager().onEntityClickEvent(event);
    }

    @EventHandler
    void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (this.isPhysicalAction(event)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.shouldCancelBlockInteraction(event, player)) {
            event.setCancelled(true);
            return;
        }
        if (this.handleSpecialBlockInteractions(event, player)) {
            return;
        }
        this.handleGeneralItemInteraction(event, player);
    }

    private void sendWelcomeMessage(Player player) {
        String name = player.getDisplayName();
        player.sendMessage(String.format("          Welcome to %sZombi%sEra %s%s%s!\n   Developed by %sPoruTo#4271%s | %swww.poruto.me%s\n             Designed by %sDzuggy#2275%s", ChatColor.RED, ChatColor.GREEN, ChatColor.YELLOW, name, ChatColor.WHITE, ChatColor.AQUA, ChatColor.WHITE, ChatColor.BLUE, ChatColor.WHITE, ChatColor.GOLD, ChatColor.WHITE));
        player.sendMessage("");
        player.sendMessage(String.format(" %s\u00a9 2023 %sZombi%sEra%s Official. All Rights Reserved.\n", ChatColor.GRAY, ChatColor.RED, ChatColor.GREEN, ChatColor.GRAY));
        player.sendMessage(String.format(" %sZombi%sEra%s Official and all related elements are trademarks and intellectual property owned by authors of %sZombi%sEra%s Official.", ChatColor.RED, ChatColor.GREEN, ChatColor.GRAY, ChatColor.RED, ChatColor.GREEN, ChatColor.GRAY) + " Any unauthorized use, reproduction, or distribution of this plugin or its content is strictly prohibited and may result in legal action.");
    }

    private void setupPlayerOnJoin(Player player) {
        ZombiEraCore.ZEPlayerManagers.getHealthManager().onPlayerJoin(player);
        player.getInventory().setItem(8, this.getEquipmentItem());
        ZEScoreBoardManager.setScoreBoardPlayer(player);
        player.setGameMode(ZombiEraSettings.DEFAULT_GAMEMODE);
        if (ZombiEraSettings.HIDE_PLAYER_NAME_TAGS.booleanValue()) {
            ZEScoreBoardManager.addPlayerToHiddenNameTeam(player);
        }
        this.initializePlayerEntityList(player);
        ZombiEraCore.getSkillsManager().updateTabForPlayer(player);
        ZombiEraCore.getRecipeManager().onPlayerJoinAddRecipes(player);
        ZombiEraCore.getBossBarManager().onPlayerJoin(player);
    }

    private void applyResourcePackIfEnabled(Player player) {
        if (ZombiEraSettings.AUTO_USE_OFFICIAL_RP.booleanValue()) {
            try {
                player.setResourcePack(ZombiEraSettings.RP_URL, ResourcePack.getResourcePackMD5(ZombiEraSettings.RP_MD5_URL), true);
                ZombiEraCore.debugInfo("RP used");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to apply resource pack", e);
            }
        }
    }

    private String createJoinMessage(Player player) {
        return String.format("%s%s joined the game!", player.getDisplayName(), ChatColor.YELLOW);
    }

    private String createLeaveMessage(Player player) {
        return String.format("%s%s left the game!", player.getDisplayName(), ChatColor.YELLOW);
    }

    private ItemStack getEquipmentItem() {
        return ZombiEraCore.getItemManager().usableItems.get(EQUIPMENT_ITEM_KEY).getItem();
    }

    private void initializePlayerEntityList(Player player) {
        ZombiEraCore.getEntityManager().perPlayerEntities.putIfAbsent(player, new ArrayList());
    }

    private void handleItemHeldOnJoin(Player player) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.hasCustomModelData(itemInHand)) {
            this.handleUsableItemHeld(player, itemInHand, true);
        }
    }

    private void handleItemHeldOnLeave(Player player) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.hasCustomModelData(itemInHand)) {
            this.handleUsableItemHeld(player, itemInHand, false);
        }
    }

    private void cleanupPlayerData(Player player) {
        ZombiEraCore.getEntityManager().perPlayerEntities.remove(player);
        this.sneakPressTracker.remove(player);
        this.pronePlayers.remove(player);
    }

    private void savePlayerStates(Player player) {
        ZombiEraCore.ZEPlayerManagers.getHealthManager().onPlayerLeave(player);
    }

    private void cleanupEquipmentInventory(Player player) {
        ZEEquipmentsManager.EquipmentInventory inv = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (inv != null) {
            inv.playerLeave();
        }
    }

    private void resetPlayerGunStates(Player player) {
        ZombiEraCore.ZEPlayerManagers.getGunsManager().setAllZoomedGunsToUnzoomed(player);
    }

    private boolean hasCustomModelData(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData();
    }

    private void handleUsableItemHeld(Player player, ItemStack item, boolean isHeld) {
        int id = item.getItemMeta().getCustomModelData();
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(id);
        if (base instanceof UsableItemBase) {
            UsableItemBase usableItemBase = (UsableItemBase)base;
            usableItemBase.playerItemHeldEvent(player, isHeld, item);
        }
    }

    private void handleItemUnheld(Player player, int slot) {
        ItemStack item = player.getInventory().getItem(slot);
        if (this.hasCustomModelData(item)) {
            this.handleUsableItemHeld(player, item, false);
        }
    }

    private void handleItemHeld(Player player, int slot) {
        ItemStack item = player.getInventory().getItem(slot);
        if (this.hasCustomModelData(item)) {
            this.handleUsableItemHeld(player, item, true);
        }
    }

    private void handleItemSwap(ItemStack item, PlayerSwapHandItemsEvent event, boolean isMainHand) {
        if (!this.hasCustomModelData(item)) {
            return;
        }
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(item.getItemMeta().getCustomModelData());
        if (base instanceof UsableItemBase) {
            UsableItemBase usable = (UsableItemBase)base;
            usable.playerSwapItemEvent(event, usable, item, isMainHand);
        }
    }

    private void handleUsableItemDrop(Player player, ItemStack item) {
        if (this.hasCustomModelData(item)) {
            this.handleUsableItemHeld(player, item, false);
        }
    }

    private boolean isEquipmentItem(ItemStack item) {
        return this.hasCustomModelData(item) && item.getItemMeta().getCustomModelData() == this.getEquipmentItem().getItemMeta().getCustomModelData();
    }

    private boolean isBrokenEquitableItem(ItemStack item) {
        if (!this.hasCustomModelData(item)) {
            return false;
        }
        int id = item.getItemMeta().getCustomModelData();
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(id);
        return base instanceof EquitableItemBase && ItemUtils.getDurability(item) == 0;
    }

    private void handleBrokenArmorEquip(PlayerArmorChangeEvent event, Player player) {
        ZombiEraCore.playerInfo(player, "Item is broken, can't equip!");
        this.restoreOldArmor(event, player);
        this.handleDroppedArmor(event, player);
    }

    private void restoreOldArmor(PlayerArmorChangeEvent event, Player player) {
        PlayerArmorChangeEvent.SlotType type = event.getSlotType();
        PlayerInventory inventory = player.getInventory();
        switch (type) {
            case HEAD: {
                inventory.setHelmet(event.getOldItem());
                break;
            }
            case CHEST: {
                inventory.setChestplate(event.getOldItem());
                break;
            }
            case LEGS: {
                inventory.setLeggings(event.getOldItem());
                break;
            }
            case FEET: {
                inventory.setBoots(event.getOldItem());
            }
        }
    }

    private void handleDroppedArmor(PlayerArmorChangeEvent event, Player player) {
        if (player.getInventory().firstEmpty() == -1) {
            player.getLocation().getWorld().dropItem(player.getLocation(), event.getNewItem());
        } else {
            player.getInventory().addItem(new ItemStack[]{event.getNewItem()});
        }
    }

    private void updateEquipmentInventory(Player player) {
        ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (equipmentInventory != null) {
            equipmentInventory.setItems();
        }
    }

    private void updateEquipmentSneakState(Player player, boolean isSneaking) {
        ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (equipmentInventory != null) {
            equipmentInventory.toggleSneak(isSneaking);
        }
    }

    private void respawnEquipmentInventory(Player player) {
        ZEEquipmentsManager.EquipmentInventory equipInv = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (equipInv != null) {
            equipInv.playerRespawn();
        }
    }

    private void handleItemInsertion(AsyncPlayerChatEvent event, Player player, PlayerHealth playerHealth) {
        event.setCancelled(true);
        playerHealth.stopInserting();
        Integer slot = this.parseSlotNumber(event.getMessage(), player);
        if (slot == null) {
            return;
        }
        this.processItemInsertion(player, slot);
    }

    private Integer parseSlotNumber(String message, Player player) {
        try {
            int slot = Integer.parseInt(message);
            if (slot < 1 || slot > 9) {
                ZombiEraCore.playerInfo(player, "Slot number should be 1-9!");
                return null;
            }
            return slot;
        }
        catch (NumberFormatException exception) {
            ZombiEraCore.playerInfo(player, "This is not a number!");
            return null;
        }
    }

    private void processItemInsertion(Player player, int slot) {
        ItemStack slotItem;
        PlayerInventory inventory = player.getInventory();
        ItemStack mainHand = inventory.getItemInMainHand();
        if (!this.canInsertItem(mainHand, slotItem = inventory.getItem(slot - 1))) {
            return;
        }
        int handId = mainHand.getItemMeta().getCustomModelData();
        ItemBase mainItemBase = ZombiEraCore.getItemManager().getItemBase(handId);
        if (mainItemBase instanceof ItemInsertSlot) {
            ItemInsertSlot itemInsertSlot = (ItemInsertSlot)((Object)mainItemBase);
            itemInsertSlot.insertItem(player, slotItem);
        }
    }

    private boolean canInsertItem(ItemStack mainHand, ItemStack slotItem) {
        return this.hasCustomModelData(mainHand) && this.hasCustomModelData(slotItem);
    }

    private void handleNormalChat(AsyncPlayerChatEvent event, Player player) {
        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addAboveHeadMessage(player, event.getMessage(), ZombiEraSettings.ABOVE_HEAD_MESSAGE_DELAY);
    }

    private void handleNPCInteraction(PlayerInteractEntityEvent event, Villager villager) {
        int entityId = villager.getEntityId();
        NPCBase npc = ZombiEraCore.getNPCManager().npcList.get(entityId);
        if (npc != null) {
            npc.getNpcHandler().openInventory(event.getPlayer(), npc);
        }
    }

    private boolean isPlayerProne(Player player) {
        return this.pronePlayers.contains(player);
    }

    private void handleProneLogic(Player player, boolean isSneaking) {
        if (isSneaking) {
            this.trackSneakPress(player);
        }
        if (this.shouldEnterProneMode(player)) {
            this.enterProneMode(player);
        } else if (this.isPlayerProne(player)) {
            this.exitProneMode(player);
        }
    }

    private void trackSneakPress(final Player player) {
        this.sneakPressTracker.computeIfAbsent(player, k -> new ArrayList()).add(player);
        new BukkitRunnable(){

            public void run() {
                List<Player> presses = PlayerHandler.this.sneakPressTracker.get(player);
                if (presses != null && !presses.isEmpty()) {
                    presses.remove(0);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 12L);
    }

    private boolean shouldEnterProneMode(Player player) {
        List<Player> presses = this.sneakPressTracker.get(player);
        return !this.isPlayerProne(player) && presses != null && presses.size() >= 2 && player.isOnGround();
    }

    private void enterProneMode(Player player) {
        this.pronePlayers.add(player);
        this.startProneEffectLoop(player);
    }

    private void startProneEffectLoop(final Player player) {
        new BukkitRunnable(){

            public void run() {
                if (PlayerHandler.this.isPlayerProne(player)) {
                    PlayerHandler.this.applyProneEffects(player);
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 3L);
    }

    private void applyProneEffects(Player player) {
        player.setGliding(true);
        if (player.isSprinting()) {
            this.setPlayerSpeed(player, 0.2f);
        } else {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 4, 10));
            this.setPlayerSpeed(player, 0.0f);
            player.setVelocity(new Vector(0, 0, 0));
        }
    }

    private void exitProneMode(Player player) {
        player.setGliding(false);
        this.setPlayerSpeed(player, 0.2f);
        this.pronePlayers.remove(player);
    }

    private void setPlayerSpeed(Player player, float speed) {
        player.setWalkSpeed(speed);
        player.setFlySpeed(speed);
    }

    private boolean handleCraftingItem(ItemStack item, Player player) {
        if (!item.hasItemMeta() || !item.getItemMeta().hasCustomModelData()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        int id = meta.getCustomModelData();
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(id);
        if (base instanceof CannedFoodItemBase) {
            player.getInventory().addItem(new ItemStack[]{ZombiEraCore.getItemManager().getItemBase(CANOPENER_KEY).getItem()});
            return true;
        }
        return this.checkBlueprintRequirement(base, player);
    }

    private boolean checkBlueprintRequirement(ItemBase base, Player player) {
        String bpDirname = String.format(BLUEPRINT_PREFIX, base.getDirName());
        ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(bpDirname);
        if (itemBase == null) {
            return true;
        }
        PlayerHealth ph = this.getPlayerHealth(player);
        if (!ph.doesKnowBlueprint(bpDirname)) {
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "You need a blueprint to craft this item!");
            return false;
        }
        return true;
    }

    private boolean isConsumableZEItem(Material itemType) {
        return itemType == Material.HONEY_BOTTLE || itemType == Material.APPLE;
    }

    private void handleZEItemConsumption(ItemStack item, PlayerItemConsumeEvent event) {
        ZombiEraCore.debugInfo("APPLE");
        if (this.hasCustomModelData(item)) {
            int id = item.getItemMeta().getCustomModelData();
            ZombiEraCore.getItemManager().handleItem((Integer)id, event);
        }
    }

    private void handleRottenFleshConsumption(Player player) {
        if (MiscUtils.generateChange(70.0f)) {
            this.getPlayerHealth(player).setSickness(HealthStates.STOMACH_SICKNESS, true);
        }
    }

    private void handleElectricalItemDrop(Player player, ItemStack droppedItem) {
        ItemElectricalBase itemElectricalBase;
        PlayerHealth ph = this.getPlayerHealth(player);
        if (!ph.getLastActionState().equals((Object)ActionStates.USED_ELECTRIC_ITEM) || !this.hasCustomModelData(droppedItem)) {
            return;
        }
        int id = droppedItem.getItemMeta().getCustomModelData();
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(id);
        if (base instanceof ItemElectricalBase && (itemElectricalBase = (ItemElectricalBase)((Object)base)).doesNeedBattery()) {
            Integer capacity = (Integer)ph.getDataStorage().getData(COUNTER_KEY);
            ItemUtils.setCapacity(droppedItem, capacity);
        }
    }

    private void handleScopedWeaponDrop(Player player, PlayerDropItemEvent event) {
        ScopedGunInfo sInfo = ZombiEraCore.ZEPlayerManagers.getGunsManager().getZoomedPlayer(player);
        if (sInfo != null) {
            event.setCancelled(true);
        }
    }

    private void handleScopedWeaponOnDeath(Player player, PlayerDeathEvent event) {
        ScopedGunInfo sInfo = ZombiEraCore.ZEPlayerManagers.getGunsManager().getZoomedPlayer(player);
        if (sInfo == null || sInfo.gun.scopeNbtId == 0) {
            return;
        }
        ZombiEraCore.ZEPlayerManagers.getGunsManager().unZoomPlayer(player);
        this.removeScopeFromDrops(event.getDrops(), sInfo.gun.scopeNbtId);
    }

    private void removeScopeFromDrops(List<ItemStack> drops, int scopeNbtId) {
        drops.removeIf(item -> this.hasCustomModelData((ItemStack)item) && item.getItemMeta().getCustomModelData() == scopeNbtId);
    }

    private void createPlayerDeathProp(Player player, PlayerDeathEvent event) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(event.getDrops());
        event.getDrops().clear();
        ZEEquipmentsManager.EquipmentInventory equipInv = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (equipInv != null) {
            items.addAll(equipInv.playerDeath());
        }
        items.remove(this.getEquipmentItem());
        ZEPropManager propManager = ZombiEraCore.getPropManager();
        PropData pd = propManager.addPropToWorldNotSaved(propManager.getPropByDirName(PLAYER_DEATH_PROP), player.getLocation());
        pd.setPropMetaData(PLAYER_UUID_KEY, player.getUniqueId().toString());
        pd.getLootAblePropData().setInventory(items);
    }

    private void updateKillerStats(PlayerDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        if (killer != null) {
            this.getPlayerStats(killer).addPlayerKill();
        }
    }

    private void setupPlayerInventoryOnSpawn(Player player) {
        player.getInventory().setItem(8, this.getEquipmentItem());
    }

    private void schedulePlayerSpawn(final Player player) {
        new BukkitRunnable(){

            public void run() {
                ZombiEraCore.getSpawnManager().spawnPlayerAtSpawn(player);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private boolean shouldCancelBlockInteraction(PlayerInteractEvent event, Player player) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null) {
            return false;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        return ZombiEraCore.getOtherManager().isUseBlocked(event.getClickedBlock().getType()) && (mainHand.getType() == Material.AIR || !mainHand.getType().isBlock());
    }

    private boolean handleSpecialBlockInteractions(PlayerInteractEvent event, Player player) {
        if (event.getClickedBlock() == null) {
            return false;
        }
        Material blockType = event.getClickedBlock().getType();
        if (blockType == Material.CHEST) {
            ZombiEraCore.getLootManager().interactWithChestEvent(event);
            return true;
        }
        if (event.getClickedBlock().getBlockData() instanceof Door) {
            ZombiEraCore.getDoorManager().rightClickAtDoor(event);
            return true;
        }
        if (event.getClickedBlock().getBlockData() instanceof TrapDoor) {
            return this.handleTrapDoorInteraction(event, player);
        }
        return false;
    }

    private boolean handleTrapDoorInteraction(PlayerInteractEvent event, Player player) {
        PropData pd = LandClaimerProp.isClaimed(event.getClickedBlock().getLocation());
        if (pd == null) {
            return false;
        }
        JSONObject database = (JSONObject)pd.getPropMetaData(DATABASE_KEY);
        if (database == null || !database.containsKey((Object)PLAYER_KEY)) {
            return false;
        }
        String playerUUID = (String)database.get((Object)PLAYER_KEY);
        if (!player.getUniqueId().toString().equals(playerUUID)) {
            ZombiEraCore.playerInfo(player, "You can only interact with this within your land claim.");
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    private void handleGeneralItemInteraction(PlayerInteractEvent event, Player player) {
        ZombiEraCore.getPropManager().onEntityClickEvent(event);
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (!this.hasCustomModelData(itemInHand)) {
            return;
        }
        int id = itemInHand.getItemMeta().getCustomModelData();
        ZombiEraCore.getItemManager().handleItem((Integer)id, event);
    }

    private void scheduleItemHeldCheck(final Player player, final int itemId) {
        new BukkitRunnable(){

            public void run() {
                ItemStack mainItem = player.getInventory().getItemInMainHand();
                if (PlayerHandler.this.hasCustomModelData(mainItem) && mainItem.getItemMeta().getCustomModelData() == itemId) {
                    PlayerHandler.this.handleUsableItemHeld(player, mainItem, true);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private void scheduleSprintAnimation(final Player player, final boolean isSprinting) {
        new BukkitRunnable(){

            public void run() {
                ZombiEraCore.ZEPlayerManagers.getGunsManager().sprintGunAnimation(isSprinting, player);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private PlayerStats getPlayerStats(Player player) {
        return this.getPlayerHealth(player).getPlayerStats();
    }

    private PlayerHealth getPlayerHealth(Player player) {
        return ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
    }

    private boolean isInSurvivalMode(Player player) {
        return !player.getGameMode().equals((Object)GameMode.CREATIVE);
    }

    private boolean isScopedWeaponActive(ScopedGunInfo scopeInfo) {
        return scopeInfo != null && scopeInfo.gun.scopeNbtId != 0;
    }

    private boolean isFallDamage(EntityDamageEvent event) {
        return event.getCause() == EntityDamageEvent.DamageCause.FALL;
    }

    private boolean isCommandTeleport(PlayerTeleportEvent event) {
        return event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND;
    }

    private boolean isPhysicalAction(PlayerInteractEvent event) {
        return event.getAction() == Action.PHYSICAL;
    }
}

