/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.door.DoorTypes;
import zombieworldproject.zombieracore.managers.door.ZDoor;
import zombieworldproject.zombieracore.world.PopulatorData;

public class WorldHandler
implements Listener {
    private static final String MAIN_WORLD_NAME = "world";
    private static final int WORLD_LOAD_CHECK_INTERVAL_TICKS = 1;
    private static final int BLOCK_QUEUE_PROCESS_INTERVAL_TICKS = 20;
    private static final int MAX_BLOCKS_PER_TICK = 500;
    private static final int FIRE_EXTINGUISH_DELAY_TICKS = 200;
    public static WorldHandler instance;
    public World WorldInstance;
    public List<PopulatorData.DefaultBlockData> blockQueue;

    public WorldHandler(ZombiEraCore plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.initialize();
    }

    @EventHandler
    public void onEntityBlockChangeEvent(EntityChangeBlockEvent event) {
        if (event.getEntity().getType() == EntityType.FALLING_BLOCK) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWeatherChangeEvent(WeatherChangeEvent event) {
        if (event.getCause() != WeatherChangeEvent.Cause.PLUGIN) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFireSpread(final BlockBurnEvent event) {
        if (event.getIgnitingBlock().getType() == Material.FIRE) {
            new BukkitRunnable(){

                public void run() {
                    event.getIgnitingBlock().setType(Material.AIR);
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 200L);
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockSpreadEvent(BlockSpreadEvent event) {
        if (event.getBlock().getType() == Material.VINE) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityBreakDoorEvent(EntityBreakDoorEvent event) {
        event.setCancelled(true);
        BlockData blockData = event.getBlock().getBlockData();
        if (!(blockData instanceof Door)) {
            return;
        }
        Door doorBlock = (Door)blockData;
        ZDoor zDoor = ZombiEraCore.getDoorManager().getDoor(event.getBlock());
        if (zDoor != null && zDoor.getType() == DoorTypes.PLAYER) {
            return;
        }
        if (!doorBlock.isOpen()) {
            doorBlock.setOpen(true);
            event.getBlock().setBlockData((BlockData)doorBlock);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        ZombiEraCore.getDoorManager().loadDoors(world);
        ZombiEraCore.getSpawnManager().loadSpawns(world);
        ZombiEraCore.getPropManager().loadDataForWorld(world);
        ZombiEraCore.getZoneManager().loadZonesFromFile(world);
        ZombiEraCore.getNPCManager().reloadNPCs(world);
        ZombiEraCore.getLootManager().loadDataFromFile(world);
    }

    public void initialize() {
        instance = this;
        if (Bukkit.getWorld((String)MAIN_WORLD_NAME) != null) {
            this.loadAll();
        }
    }

    public void loadAll() {
        this.initializeBlockQueue();
        this.startWorldLoadTask();
        this.startBlockQueueProcessor();
    }

    private void initializeBlockQueue() {
        this.blockQueue = Collections.synchronizedList(new ArrayList());
    }

    private void startWorldLoadTask() {
        new BukkitRunnable(){

            public void run() {
                WorldHandler.this.WorldInstance = Bukkit.getWorld((String)WorldHandler.MAIN_WORLD_NAME);
                if (WorldHandler.this.WorldInstance != null) {
                    ZombiEraCore.debugInfo("The instance of the World has been loaded!");
                    if (ZombiEraSettings.ON_RELOAD_KILL_ENTITIES.booleanValue()) {
                        WorldHandler.this.removeAllEntities();
                        ZombiEraCore.debugInfo("All entities removed!");
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
    }

    private void removeAllEntities() {
        for (Entity entity : this.WorldInstance.getEntities()) {
            if (!(entity instanceof LivingEntity) || entity instanceof Player || entity instanceof ArmorStand) continue;
            entity.remove();
        }
    }

    private void startBlockQueueProcessor() {
        new BukkitRunnable(){

            public void run() {
                if (WorldHandler.this.WorldInstance != null) {
                    WorldHandler.this.processBlockQueue();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 20L);
    }

    private void processBlockQueue() {
        ArrayList<PopulatorData.DefaultBlockData> copyBlockQueue = new ArrayList<PopulatorData.DefaultBlockData>(this.blockQueue);
        int blocksProcessed = 0;
        for (PopulatorData.DefaultBlockData blockData : copyBlockQueue) {
            if (blocksProcessed >= 500) break;
            blockData.apply(this.WorldInstance);
            this.blockQueue.remove(blockData);
            ++blocksProcessed;
        }
    }
}

