/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.handlers.entity;

import org.bukkit.Chunk;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BodyPart;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.Bullet;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BulletResult;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeItemBase;
import zombieworldproject.zombieracore.managers.item.stats.StatType;
import zombieworldproject.zombieracore.managers.item.stats.ZEBonusStats;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.ChunkPropsData;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class EntityDamageHandler {
    public void handleEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if ((event.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE_TICK)) && ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).isInSafeZone()) {
                event.setCancelled(true);
                return;
            }
        }
        if (event.getEntity() instanceof Mob) {
            ZombiEraCore.getEntityManager().handleEntityDamageEvent(event);
        }
    }

    public void handleEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity player;
        Entity entity;
        Entity damager = event.getDamager();
        Entity entity2 = event.getDamager();
        if (entity2 instanceof Player) {
            Player player1 = (Player)entity2;
            ZombiEraCore.getCombatLogManager().logCombat(player1);
        }
        if ((entity2 = event.getEntity()) instanceof Player) {
            Player player2 = (Player)entity2;
            ZombiEraCore.getCombatLogManager().logCombat(player2);
        }
        if ((entity = event.getEntity()) instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            if (damager instanceof Player) {
                player = (Player)damager;
                ZombiEraCore.getPropManager().onEntityClickEvent(armorStand, (Player)player);
                return;
            }
        }
        if (event.isCancelled()) {
            return;
        }
        player = event.getEntity();
        if (!(player instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity3 = (LivingEntity)player;
        if (entity3 instanceof Player) {
            player = (Player)entity3;
            this.handlePlayerDamage(event, (Player)player, damager);
        }
        if ((entity = event.getDamager()) instanceof Snowball) {
            Snowball bullet = (Snowball)entity;
            this.handleBulletDamage(event, entity3, bullet);
        } else {
            this.handleMeleeDamage(event, entity3, damager);
        }
    }

    private void handlePlayerDamage(EntityDamageByEntityEvent event, Player player, Entity damager) {
        if (ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).isInSafeZone() && (damager instanceof Player || damager instanceof Projectile)) {
            event.setCancelled(true);
            return;
        }
        if (!(damager instanceof Projectile) && !player.isBlocking()) {
            ZombiEraCore.ZEPlayerManagers.getHealthManager().entityMeleeHitPlayer(player, damager);
        }
    }

    private void handleBulletDamage(EntityDamageByEntityEvent event, LivingEntity entity, Snowball bullet) {
        Integer entityId = bullet.getEntityId();
        if (ZombiEraCore.ZEPlayerManagers.getGunsManager().uniqueIds.containsKey(entityId)) {
            ZEEquipmentsManager.EquipmentInventory equipInv;
            Player player;
            Bullet bulletItem = ZombiEraCore.ZEPlayerManagers.getGunsManager().uniqueIds.get(entityId);
            ZombiEraCore.ZEPlayerManagers.getGunsManager().uniqueIds.remove(entityId);
            double totalProtection = 0.0;
            BulletResult result = bulletItem.getBulletMultiplier(event.getEntity(), event.getDamager(), bulletItem);
            bulletItem.gun.getShootHandler().onProjectileHit((Entity)entity, result);
            if (entity instanceof Player) {
                player = (Player)entity;
                ZombiEraCore.ZEPlayerManagers.getHealthManager().bulletHitPlayer(player, result);
                ZombiEraCore.getCombatLogManager().logCombat(player);
            }
            if (entity instanceof Player && (equipInv = ZEEquipmentsManager.playerEquipmentInventories.get(player = (Player)entity)) != null) {
                equipInv.damageBodyPartEquipment(result.bodyPart);
                switch (result.bodyPart) {
                    case BODY: {
                        totalProtection += equipInv.getChestProtection().doubleValue();
                        break;
                    }
                    case LEG: {
                        totalProtection += equipInv.getLegProtection().doubleValue();
                        break;
                    }
                    case HEAD: {
                        totalProtection += equipInv.getHeadProtection().doubleValue();
                    }
                }
            }
            event.setCancelled(true);
            String damageStr = ZEBonusStats.getBonusValue(bulletItem.gunItem, StatType.DAMAGE);
            double damageAdjustment = 0.0;
            if (damageStr != null) {
                damageAdjustment = Double.parseDouble(damageStr);
            }
            double finalDamage = result.totalMultiplier * (1.0 - totalProtection / 100.0) + damageAdjustment;
            System.out.println("Final Damage: " + finalDamage);
            entity.damage(finalDamage);
            if (entity instanceof ArmorStand) {
                this.handleArmorStandBulletHit(entity, event, result);
            }
        }
    }

    private void handleArmorStandBulletHit(LivingEntity entity, EntityDamageByEntityEvent event, BulletResult result) {
        PropHandler handler;
        PropData pd;
        Chunk chunk = entity.getChunk();
        ChunkPropsData cpd = ZombiEraCore.getPropManager().getChunkPropsData(chunk.getX(), chunk.getZ(), chunk.getWorld());
        if (cpd != null && (pd = cpd.findPropByEntityId(entity.getEntityId())) != null && (handler = pd.prop.getPropHandler()) != null) {
            handler.onBulletHit(event.getDamager(), result, pd);
        }
    }

    private void handleMeleeDamage(EntityDamageByEntityEvent event, LivingEntity entity, Entity damager) {
        if (damager instanceof Player) {
            Player player = (Player)damager;
            this.handlePlayerHitsEntity(event, entity, player);
        } else if (damager instanceof Entity && entity instanceof Player) {
            Player player = (Player)entity;
            this.handleEntityHitsPlayer(event, player);
        }
    }

    private void handlePlayerHitsEntity(EntityDamageByEntityEvent event, LivingEntity entity, Player player) {
        PlayerInventory playerInv = player.getInventory();
        ItemStack item = playerInv.getItemInMainHand();
        if (ZombiEraCore.ZEPlayerManagers.getGunsManager().meleeLocked.contains(player)) {
            ZombiEraCore.getEntityManager().handleEntityDamageByEntityEvent(event);
            event.setCancelled(true);
            return;
        }
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData()) {
            this.handleMeleeItemHit(event, entity, player, item);
        }
        if (entity instanceof Player) {
            Player playerDamaged = (Player)entity;
            this.applyPlayerProtection(event, playerDamaged);
        }
        if (!ZombiEraCore.ZEPlayerManagers.getGunsManager().meleeLocked.contains(player)) {
            this.initiateMeleeCooldown(event, player);
        }
    }

    private void handleMeleeItemHit(EntityDamageByEntityEvent event, LivingEntity entity, Player player, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        int id = meta.getCustomModelData();
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(id);
        if (base instanceof MeleeItemBase) {
            MeleeItemBase meleeItemBase = (MeleeItemBase)base;
            player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).setBaseValue(0.5);
            meleeItemBase.playerHitsEntity(player, (Entity)entity);
            Integer durabilityNow = ItemUtils.getDurability(item);
            if (durabilityNow != null && durabilityNow != 0) {
                durabilityNow = durabilityNow - 1;
                ItemUtils.setDurability(item, durabilityNow);
                ZEBonusStats.editEntityDamageByEntityEvent(event, item);
                ZombiEraCore.debugInfo("Damage: " + event.getDamage());
            } else {
                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Item is broken!", 5);
                ZombiEraCore.getSoundManager().playSound(player, "melee_broken");
                event.setCancelled(true);
            }
        }
    }

    private void applyPlayerProtection(EntityDamageByEntityEvent event, Player playerDamaged) {
        ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(playerDamaged);
        if (equipmentInventory != null) {
            event.setDamage(Math.max(event.getDamage() * (1.0 - equipmentInventory.getChestProtection() / 100.0), 1.0));
            equipmentInventory.damageBodyPartEquipment(BodyPart.BODY);
        }
    }

    private void initiateMeleeCooldown(EntityDamageByEntityEvent event, final Player player) {
        ZombiEraCore.ZEPlayerManagers.getGunsManager().meleeLocked.add(player);
        ZombiEraCore.getEntityManager().handleEntityDamageByEntityEvent(event);
        new BukkitRunnable(){

            public void run() {
                if (player.getAttackCooldown() == 1.0f) {
                    player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).setBaseValue(4.0);
                    player.playSound(player.getLocation(), Sound.UI_TOAST_IN, 1.0f, 0.2f);
                    ZombiEraCore.ZEPlayerManagers.getGunsManager().meleeLocked.remove(player);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 5L);
    }

    private void handleEntityHitsPlayer(EntityDamageByEntityEvent event, Player player) {
        ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        if (equipmentInventory != null) {
            event.setDamage(Math.max(event.getDamage() * (1.0 - equipmentInventory.getChestProtection() / 100.0), 1.0));
            equipmentInventory.damageBodyPartEquipment(BodyPart.BODY);
        }
        ZombiEraCore.getEntityManager().handleEntityDamageByEntityEvent(event);
    }
}

