/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.handlers.entity;

import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;

public class EntityTargetHandler {
    public void handleEntityTarget(EntityTargetLivingEntityEvent event) {
        LivingEntity target = event.getTarget();
        if (target instanceof Player) {
            Player player = (Player)target;
            Entity entity = event.getEntity();
            if (entity instanceof Creature) {
                ZEEquipmentsManager.EquipmentInventory equipmentInventory;
                Creature creature = (Creature)entity;
                if (player.getLocation().distance(creature.getLocation()) > (double)(ZombiEraSettings.BULLET_ATTRACTS_ZOMBIES_DISTANCE + 10)) {
                    event.setCancelled(true);
                }
                if ((equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player)) != null) {
                    Double creatureDistance = creature.getLocation().distance(player.getLocation());
                    if (creatureDistance <= 5.0) {
                        return;
                    }
                    Double deltaDistance = creatureDistance - equipmentInventory.getSneakDistance();
                    if (deltaDistance <= equipmentInventory.getSneakDistance()) {
                        event.setCancelled(true);
                    }
                }
            }
        }
        if (event.isCancelled()) {
            return;
        }
        String entityName = ZombiEraCore.getEntityManager().getRegisteredName(event.getEntity().getEntityId());
        if (entityName != null) {
            EntityBase base = ZombiEraCore.getEntityManager().getEntityBaseByName(entityName);
            ZombiEraCore.getEntityManager().handleEntityTargetLivingEntity(event, base);
        }
        if (event.isCancelled()) {
            return;
        }
        event.setCancelled(target == null || event.getTarget().getType() != EntityType.PLAYER && event.getTarget().getType() != EntityType.VILLAGER);
    }
}

