/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers;

import org.bukkit.Location;
import org.bukkit.util.Vector;

class SoundInfo {
    public Location finalLocation;
    public Float volume;
    public Float pitch;
    Location playerLocation;
    Location sourceLocation;
    Double maxDistance;

    public SoundInfo(Location playerLocation, Location sourceLocation, Double maxDistance) {
        this.playerLocation = playerLocation;
        this.sourceLocation = sourceLocation;
        this.maxDistance = maxDistance;
    }

    public boolean calculate() {
        double distance = this.sourceLocation.distance(this.playerLocation);
        if (distance <= this.maxDistance) {
            Vector direction = this.sourceLocation.toVector().subtract(this.playerLocation.toVector()).normalize();
            double offsetDistance = 10.0;
            double xOffset = direction.getX() * offsetDistance;
            double yOffset = direction.getY() * offsetDistance;
            double zOffset = direction.getZ() * offsetDistance;
            this.finalLocation = this.playerLocation.clone().add(xOffset, yOffset, zOffset);
            this.volume = Float.valueOf((float)(1.0 - distance / this.maxDistance));
            Vector playerDirection = this.playerLocation.getDirection().normalize();
            double dotProduct = direction.dot(playerDirection);
            this.pitch = Float.valueOf(this.calculatePitch(dotProduct));
            return true;
        }
        return false;
    }

    private float calculatePitch(double dotProduct) {
        double thresholdAngle = 0.8;
        if (dotProduct < -thresholdAngle) {
            return 0.1f;
        }
        return (float)Math.max(0.1, 1.0 - Math.pow(1.0 - Math.abs(dotProduct), 2.0));
    }
}

