/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;

public class ZEBossBarManager {
    private final Map<Player, Map<String, BossBar>> bossBarMap = new HashMap<Player, Map<String, BossBar>>();

    public void onPlayerJoin(Player player) {
        if (player == null) {
            return;
        }
        HashMap<String, BossBar> playerBars = new HashMap<String, BossBar>();
        this.bossBarMap.put(player, playerBars);
        BossBar coordsBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        coordsBar.setProgress(0.0);
        coordsBar.addPlayer(player);
        playerBars.put("coords", coordsBar);
        BossBar staminaBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        staminaBar.addPlayer(player);
        playerBars.put("stamina", staminaBar);
        this.staminaBarRecharge(player);
    }

    public void staminaBarRecharge(final Player player) {
        if (player == null) {
            return;
        }
        final BossBar staminaBar = this.getStaminaBar(player);
        if (staminaBar == null) {
            return;
        }
        final PlayerHealth playerHealth = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (playerHealth == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!ZEBossBarManager.this.bossBarMap.containsKey(player)) {
                    this.cancel();
                    return;
                }
                if (!player.isSprinting() && player.isOnGround()) {
                    double newStamina = Math.min(playerHealth.getStamina() + ZombiEraSettings.STAMINA_RECHARGE, 100.0);
                    playerHealth.setStamina(newStamina);
                    staminaBar.setProgress(newStamina / 100.0);
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 10L);
    }

    public void onPlayerLeave(Player player) {
        if (player == null) {
            return;
        }
        Map<String, BossBar> bars = this.bossBarMap.remove(player);
        if (bars != null) {
            bars.values().forEach(BossBar::removeAll);
        }
    }

    public BossBar getStaminaBar(Player player) {
        Map<String, BossBar> bars = this.bossBarMap.get(player);
        if (bars == null) {
            return null;
        }
        return bars.get("stamina");
    }

    public void playerOutOfStamina(Player player) {
        if (player == null) {
            return;
        }
        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Not enough stamina!", 5);
        player.setSprinting(false);
        player.setVelocity(new Vector(0, 0, 0));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 20, 1));
    }

    public void onPlayerSprintToggle(PlayerToggleSprintEvent event) {
        if (event == null || !event.isSprinting()) {
            return;
        }
        final Player player = event.getPlayer();
        final PlayerHealth playerHealth = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (playerHealth == null) {
            return;
        }
        final BossBar staminaBar = this.getStaminaBar(player);
        if (staminaBar == null) {
            return;
        }
        if (playerHealth.getStamina() > ZombiEraSettings.STAMINA_SPRINT_START) {
            playerHealth.setStamina(playerHealth.getStamina() - ZombiEraSettings.STAMINA_SPRINT_START);
            new BukkitRunnable(){

                public void run() {
                    if (player.isSprinting() && playerHealth.getStamina() > 0.0) {
                        double newStamina = Math.max(playerHealth.getStamina() - ZombiEraSettings.STAMINA_SPRINT, 0.0);
                        playerHealth.setStamina(newStamina);
                        if (newStamina == 0.0) {
                            ZEBossBarManager.this.playerOutOfStamina(player);
                            this.cancel();
                            return;
                        }
                        staminaBar.setProgress(newStamina / 100.0);
                    } else {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 10L);
        } else {
            this.playerOutOfStamina(player);
            event.setCancelled(true);
        }
    }

    public void onPlayerJumpToggle(PlayerJumpEvent event) {
        if (event == null) {
            return;
        }
        Player player = event.getPlayer();
        PlayerHealth playerHealth = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (playerHealth == null) {
            return;
        }
        BossBar staminaBar = this.getStaminaBar(player);
        if (staminaBar == null) {
            return;
        }
        if (playerHealth.getStamina() >= ZombiEraSettings.STAMINA_JUMP + 3.0) {
            double newStamina = Math.max(playerHealth.getStamina() - ZombiEraSettings.STAMINA_JUMP, 0.0);
            playerHealth.setStamina(newStamina);
            staminaBar.setProgress(newStamina / 100.0);
        } else {
            this.playerOutOfStamina(player);
            event.setCancelled(true);
        }
    }

    public void showPlayerCoords(Player player) {
        if (player == null) {
            return;
        }
        Map<String, BossBar> bars = this.bossBarMap.get(player);
        if (bars == null) {
            return;
        }
        BossBar coordsBar = bars.get("coords");
        if (coordsBar == null) {
            return;
        }
        Location location = player.getLocation();
        if (location == null) {
            return;
        }
        int[] arcadeTime = ZombiEraCore.getRealTimeManager().getCurrentArcadeTimePublic();
        int currentHour = arcadeTime[0];
        int currentMinute = arcadeTime[1];
        coordsBar.setTitle(String.format("X: %d Y: %d Z: %d | WWW.%sZOMBI%sERA%s.NET | %d:%02d", location.getBlockX(), location.getBlockY(), location.getBlockZ(), ChatColor.GREEN, ChatColor.RED, ChatColor.WHITE, currentHour, currentMinute));
    }

    public void disablePlugin() {
        this.bossBarMap.values().forEach(bars -> bars.values().forEach(BossBar::removeAll));
        this.bossBarMap.clear();
    }
}

