/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import zombieworldproject.zombieracore.ZombiEraCore;

public class ZEOtherManager {
    private final List<Material> blockedBlockUse = new ArrayList<Material>();

    public void loadBlockedBlockUses() {
        this.blockedBlockUse.clear();
        File configFile = new File(ZombiEraCore.instance.getDataFolder(), "config.yml");
        if (!configFile.exists() || !configFile.canRead()) {
            ZombiEraCore.debugInfo("Config file not found or unreadable: " + configFile.getAbsolutePath());
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        List blockedContainersString = config.getStringList("ZombiEra.settings.blockedBlockUse");
        if (blockedContainersString == null || blockedContainersString.isEmpty()) {
            ZombiEraCore.debugInfo("No blocked block uses found in config.");
            return;
        }
        for (String blockedContainer : blockedContainersString) {
            Material material;
            if (blockedContainer == null || blockedContainer.trim().isEmpty() || (material = Material.getMaterial((String)blockedContainer.trim().toUpperCase())) == null) continue;
            this.blockedBlockUse.add(material);
        }
        ZombiEraCore.debugInfo("Loaded " + this.blockedBlockUse.size() + " blocked block uses.");
    }

    public boolean isUseBlocked(Material material) {
        if (material == null) {
            return false;
        }
        return this.blockedBlockUse.contains(material);
    }

    public List<Material> getBlockedBlockUse() {
        return Collections.unmodifiableList(this.blockedBlockUse);
    }
}

