/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.SoundInfo;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZESoundManager {
    public List<String> ricochetSounds = new ArrayList<String>(){
        {
            this.add("ricochet_1");
            this.add("ricochet_2");
            this.add("ricochet_3");
            this.add("ricochet_4");
        }
    };

    public void playGunFireSound(Player player, String sound) {
        this.playSound(player.getLocation(), sound, (Double)100.0, player);
        this.playSound(player, sound);
        if (MiscUtils.generateChance(ZombiEraSettings.BULLET_ATTRACTS_ZOMBIES_CHANCE)) {
            List entities = player.getNearbyEntities((double)ZombiEraSettings.BULLET_ATTRACTS_ZOMBIES_DISTANCE.intValue(), (double)ZombiEraSettings.BULLET_ATTRACTS_ZOMBIES_DISTANCE.intValue(), (double)ZombiEraSettings.BULLET_ATTRACTS_ZOMBIES_DISTANCE.intValue());
            entities.forEach(entity -> {
                Creature creature;
                if (!(entity instanceof Player) && entity instanceof Creature && (creature = (Creature)entity).getTarget() == null) {
                    creature.setTarget((LivingEntity)player);
                }
            });
        }
    }

    public void playRandomRicochet(Location location) {
        this.playSound(location, this.ricochetSounds.get(MiscUtils.globalRandom.nextInt(this.ricochetSounds.size())));
    }

    public void stopSoundAtPlayer(Player player, String sound) {
        List entities = player.getNearbyEntities(5.0, 5.0, 5.0);
        entities.forEach(entity -> {
            if (entity instanceof Player) {
                ((Player)entity).stopSound(String.format("zw.sound.%s", sound));
            }
        });
        player.stopSound(String.format("zw.sound.%s", sound));
    }

    public void playSound(Location location, String sound) {
        location.getWorld().playSound(location, String.format("zw.sound.%s", sound), 1.0f, 1.0f);
    }

    public void playSound(Player player, String sound) {
        player.playSound(player.getLocation(), String.format("zw.sound.%s", sound), 1.0f, 1.0f);
    }

    public void playSound(Player player, String sound, float v1, float v2) {
        player.playSound(player.getLocation(), String.format("zw.sound.%s", sound), v1, v2);
    }

    public void playSound(Location location, String sound, float v1, float v2) {
        location.getWorld().playSound(location, String.format("zw.sound.%s", sound), v1, v2);
    }

    public void playSound(Location sourceLocation, String sound, Double maxDistance, Player playerOut) {
        Collection players = sourceLocation.getNearbyEntitiesByType(Player.class, maxDistance.doubleValue(), maxDistance.doubleValue());
        players.remove(playerOut);
        players.forEach(player -> {
            SoundInfo soundInfo = new SoundInfo(player.getEyeLocation(), sourceLocation, maxDistance);
            if (soundInfo.calculate()) {
                player.playSound(soundInfo.finalLocation, String.format("zw.sound.%s", sound), soundInfo.volume.floatValue(), soundInfo.pitch.floatValue());
            }
        });
    }

    public void playSound(Location sourceLocation, String sound, Double maxDistance) {
        Collection players = sourceLocation.getNearbyEntitiesByType(Player.class, maxDistance.doubleValue(), maxDistance.doubleValue());
        players.forEach(player -> {
            SoundInfo soundInfo = new SoundInfo(player.getEyeLocation(), sourceLocation, maxDistance);
            if (soundInfo.calculate()) {
                player.playSound(soundInfo.finalLocation, String.format("zw.sound.%s", sound), soundInfo.volume.floatValue(), soundInfo.pitch.floatValue());
            }
        });
    }

    public void playSound(Location sourceLocation, Sound sound, Double maxDistance) {
        Collection players = sourceLocation.getNearbyEntitiesByType(Player.class, maxDistance.doubleValue(), maxDistance.doubleValue());
        players.forEach(player -> {
            SoundInfo soundInfo = new SoundInfo(player.getEyeLocation(), sourceLocation, maxDistance);
            if (soundInfo.calculate()) {
                player.playSound(soundInfo.finalLocation, sound, soundInfo.volume.floatValue(), soundInfo.pitch.floatValue());
            }
        });
    }

    public void playSound(Location sourceLocation, Sound sound, Double maxDistance, Float pitch) {
        Collection players = sourceLocation.getNearbyEntitiesByType(Player.class, maxDistance.doubleValue(), maxDistance.doubleValue(), maxDistance.doubleValue());
        players.forEach(player -> {
            SoundInfo soundInfo = new SoundInfo(player.getEyeLocation(), sourceLocation, maxDistance);
            if (soundInfo.calculate()) {
                player.playSound(soundInfo.finalLocation, sound, soundInfo.volume.floatValue(), pitch.floatValue());
            }
        });
    }
}

