/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZESpawnManager {
    private Location globalSpawn;
    private final Map<String, Location> randomSpawnPoints = new HashMap<String, Location>();
    private File configFile;
    private boolean globalSpawnLoaded = false;

    public List<String> getRandomSpawnPointsNames() {
        return new ArrayList<String>(this.randomSpawnPoints.keySet());
    }

    public boolean spawnPlayerAtRandomSpawn(String spawnName, Player player) {
        if (spawnName == null || player == null || !this.randomSpawnPoints.containsKey(spawnName)) {
            return false;
        }
        this.tpPlayer(player, this.randomSpawnPoints.get(spawnName));
        return true;
    }

    public boolean removeRandomSpawnPoint(String name) {
        if (name == null || !this.randomSpawnPoints.containsKey(name)) {
            return false;
        }
        this.randomSpawnPoints.remove(name);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        config.set("random." + name, null);
        this.saveConfigSafely(config);
        return true;
    }

    public boolean addRandomSpawnPoint(String name, Player player) {
        if (name == null || player == null || this.randomSpawnPoints.containsKey(name)) {
            return false;
        }
        Location location = player.getLocation();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        config.set("random." + name + ".x", (Object)location.getX());
        config.set("random." + name + ".y", (Object)location.getY());
        config.set("random." + name + ".z", (Object)location.getZ());
        config.set("random." + name + ".world", (Object)location.getWorld().getName());
        this.saveConfigSafely(config);
        this.randomSpawnPoints.put(name, location.clone());
        return true;
    }

    public void setGlobalSpawn(Player player) {
        if (player == null) {
            return;
        }
        this.globalSpawn = player.getLocation();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        config.set("global.spawn.x", (Object)this.globalSpawn.getX());
        config.set("global.spawn.y", (Object)this.globalSpawn.getY());
        config.set("global.spawn.z", (Object)this.globalSpawn.getZ());
        config.set("global.spawn.world", (Object)this.globalSpawn.getWorld().getName());
        this.saveConfigSafely(config);
    }

    public void loadSpawns(World world) {
        this.configFile = new File(ZombiEraCore.instance.getDataFolder(), "spoints.yml");
        if (this.configFile.exists() && this.configFile.canRead()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
            this.loadGlobalSpawn(config);
            this.loadRandomSpawns(config, world);
        } else {
            this.createDefaultConfig();
        }
    }

    public void tpPlayer(Player player, Location location) {
        if (player == null || location == null) {
            return;
        }
        Entity passenger = player.getPassenger();
        if (passenger != null) {
            player.removePassenger(passenger);
        }
        player.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
    }

    public void spawnPlayerAtSpawn(Player player) {
        this.tpPlayer(player, this.globalSpawn);
    }

    public boolean spawnPlayerRandom(Player player) {
        if (this.randomSpawnPoints.isEmpty() || player == null) {
            return false;
        }
        ArrayList<Location> spawnList = new ArrayList<Location>(this.randomSpawnPoints.values());
        Location randomLocation = (Location)spawnList.get(MiscUtils.globalRandom.nextInt(0, spawnList.size()));
        this.tpPlayer(player, randomLocation);
        return true;
    }

    private void saveConfigSafely(YamlConfiguration config) {
        try {
            config.save(this.configFile);
        }
        catch (IOException e) {
            ZombiEraCore.debugInfo("Error saving spawn configuration: " + e.getMessage());
        }
    }

    private void loadGlobalSpawn(YamlConfiguration config) {
        if (this.globalSpawnLoaded) {
            return;
        }
        String worldName = config.getString("global.spawn.world");
        Double x = config.getDouble("global.spawn.x");
        Double y = config.getDouble("global.spawn.y");
        Double z = config.getDouble("global.spawn.z");
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            this.globalSpawn = new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
            this.globalSpawnLoaded = true;
        } else {
            ZombiEraCore.debugInfo("Global spawn world not found: " + worldName);
        }
    }

    private void loadRandomSpawns(YamlConfiguration config, World world) {
        ConfigurationSection section = config.getConfigurationSection("random");
        if (section == null || world == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            String worldName = config.getString("random." + key + ".world");
            if (!world.getName().equals(worldName)) continue;
            double x = config.getDouble("random." + key + ".x");
            double y = config.getDouble("random." + key + ".y");
            double z = config.getDouble("random." + key + ".z");
            this.randomSpawnPoints.put(key, new Location(world, x, y, z));
        }
    }

    private void createDefaultConfig() {
        try {
            if (this.configFile.createNewFile()) {
                YamlConfiguration config = new YamlConfiguration();
                config.set("global.spawn.x", (Object)0.0);
                config.set("global.spawn.y", (Object)0.0);
                config.set("global.spawn.z", (Object)0.0);
                config.set("global.spawn.world", (Object)"world");
                config.set("random.default.x", (Object)0.0);
                config.set("random.default.y", (Object)0.0);
                config.set("random.default.z", (Object)0.0);
                config.set("random.default.world", (Object)"world");
                this.saveConfigSafely(config);
                this.globalSpawn = new Location(Bukkit.getWorld((String)"world"), 0.0, 0.0, 0.0);
            }
        }
        catch (IOException e) {
            ZombiEraCore.debugInfo("Error creating default spawn config: " + e.getMessage());
        }
    }
}

