/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZETipsManager {
    private File configFile;
    private List<String> tips = new ArrayList<String>();
    private String previousTip = null;

    public ZETipsManager() {
        this.run();
    }

    public void reloadTips() {
        this.configFile = new File(ZombiEraCore.instance.getDataFolder(), "tips.yml");
        if (!this.configFile.exists()) {
            this.createTips();
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.tips = config.getStringList("tips");
        if (this.tips == null || this.tips.isEmpty()) {
            this.createTips();
            return;
        }
        this.saveConfigSafely(config);
    }

    public void createTips() {
        if (this.configFile == null) {
            this.configFile = new File(ZombiEraCore.instance.getDataFolder(), "tips.yml");
        }
        YamlConfiguration config = new YamlConfiguration();
        this.tips = new ArrayList<String>();
        this.tips.add("You can look at available recipes by clicking on the book inside your inventory.");
        this.tips.add("Guns can be reloaded with the F key.");
        this.tips.add("Safe zones have EnderChests where you can store your items.");
        this.tips.add("Traders can be found in safe zones.");
        this.tips.add("When infected, consume painkillers or antibiotics. (Antibiotics guarantee a cure.)");
        this.tips.add("If bleeding, use a bandage or MedKit.");
        this.tips.add("Some recipes require learned blueprints. (You can find blueprints while looting.)");
        this.tips.add("Most items have useful notes in their lore. (Hover over them in your inventory.)");
        this.tips.add("You can use green, blue, and red KeyCards to access locked areas.");
        this.tips.add("To go prone, stand still and double shift. To crawl forward, sprint and double shift.");
        this.tips.add("You can use junk items to craft various tools and supplies!");
        this.tips.add("Different areas have different loot types (e.g., meds: hospitals, guns: military zones).");
        this.tips.add("Worn clothes can be crafted into dirty rags.");
        this.tips.add("Dirty rags can be cleaned in water to obtain Clean Rags.");
        this.tips.add("You can drink from a water pump or fill an empty canteen by right-clicking it.");
        this.tips.add("Refill your gas canister by right-clicking a gas pump.");
        this.tips.add("To access your backpack, equip it, then right-click the gear icon in your inventory and select the backpack.");
        config.set("tips", this.tips);
        this.saveConfigSafely(config);
    }

    private void run() {
        new BukkitRunnable(){

            public void run() {
                String randomTip;
                if (ZETipsManager.this.tips.isEmpty()) {
                    ZETipsManager.this.reloadTips();
                    if (ZETipsManager.this.tips.isEmpty()) {
                        return;
                    }
                }
                if ((randomTip = ZETipsManager.this.getRandomTip()) == null) {
                    return;
                }
                int safetyCounter = 0;
                while (randomTip.equals(ZETipsManager.this.previousTip) && safetyCounter++ < 5) {
                    randomTip = ZETipsManager.this.getRandomTip();
                }
                ZETipsManager.this.previousTip = randomTip;
                String finalTip = randomTip;
                Bukkit.getOnlinePlayers().forEach(player -> ZombiEraCore.playerInfo(player, String.format("%sTIP%s%s: %s", ChatColor.DARK_AQUA, ChatColor.WHITE, ChatColor.ITALIC, finalTip)));
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 6000L);
    }

    public String getRandomTip() {
        if (this.tips.isEmpty()) {
            return null;
        }
        return this.tips.get(MiscUtils.globalRandom.nextInt(0, this.tips.size()));
    }

    private void saveConfigSafely(YamlConfiguration config) {
        try {
            config.save(this.configFile);
        }
        catch (IOException e) {
            ZombiEraCore.debugInfo("Error saving tips configuration: " + e.getMessage());
        }
    }
}

