/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.door;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.door.DoorTypes;
import zombieworldproject.zombieracore.managers.door.ZDoor;

public class PlayerDoor
extends ZDoor {
    public List<String> allowedPlayersUUIDs = new ArrayList<String>();

    public PlayerDoor(Location location) {
        super(location);
        this.type = DoorTypes.PLAYER;
    }

    public String getOwnerUUID() {
        return this.allowedPlayersUUIDs.get(0);
    }

    public boolean isAllowed(Player player) {
        return this.allowedPlayersUUIDs.contains(player.getUniqueId().toString());
    }

    public boolean isOwner(Player player) {
        return player.getUniqueId().toString().equals(this.getOwnerUUID());
    }

    public void removePlayer(Player player) {
        this.allowedPlayersUUIDs.remove(player.getUniqueId().toString());
        ZombiEraCore.getDoorManager().updateDoorData(this);
    }

    public void addPlayer(String UUID2) {
        this.allowedPlayersUUIDs.add(UUID2);
        ZombiEraCore.getDoorManager().updateDoorData(this);
    }

    public void addPlayer(Player player) {
        this.addPlayer(player.getUniqueId().toString());
    }

    public void addAllPlayers(List<String> UUIDs) {
        this.allowedPlayersUUIDs.addAll(UUIDs);
    }
}

