/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.door;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Door;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.door.DoorTypes;
import zombieworldproject.zombieracore.managers.door.KeyCardDoor;
import zombieworldproject.zombieracore.managers.door.PlayerDoor;
import zombieworldproject.zombieracore.managers.door.ZDoor;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;

public class ZEDoorManager {
    private static final String CONFIG_FILE_NAME = "lockeddoors.yml";
    private static final String DOORS_SECTION = "doors";
    private static final String POSITION_KEY_FORMAT = "%s_%s_%s";
    private static final String LOCKED_DOOR_MESSAGE = "This door is locked by a player! You don't have an access.";
    private static final String DOOR_OPENED_MESSAGE = "Player door opened.";
    private static final String DOOR_CLOSED_MESSAGE = "Player door closed.";
    private static final int ACTION_BAR_DURATION_SECONDS = 5;
    private final Map<String, ZDoor> lockedDoors = new HashMap<String, ZDoor>();
    private File configFile;

    public boolean doorExists(String key) {
        return this.lockedDoors.containsKey(key);
    }

    public boolean doorExists(Block block) {
        String key = this.getKey(block);
        return this.lockedDoors.containsKey(key);
    }

    public ZDoor getDoorAtBlock(Block block) {
        String key = this.getKey(block);
        return this.lockedDoors.get(key);
    }

    public DoorTypes getDoorType(String key) {
        return this.lockedDoors.get((Object)key).type;
    }

    public ZDoor getDoor(Block block) {
        if (this.doorExists(block)) {
            return this.getDoorAtBlock(block);
        }
        Block adjacentBlock = this.findAdjacentDoorBlock(block);
        if (adjacentBlock != null && this.doorExists(adjacentBlock)) {
            return this.getDoorAtBlock(adjacentBlock);
        }
        return null;
    }

    public String getKey(Block block) {
        return String.format(POSITION_KEY_FORMAT, block.getX(), block.getY(), block.getZ());
    }

    public void loadDoors(World world) {
        this.initializeConfigFile();
        if (!this.configFile.exists()) {
            this.createEmptyConfigFile();
            return;
        }
        this.loadDoorsFromConfig(world);
    }

    public boolean addKeyCardLockedDoor(DoorTypes type, Block block) {
        String key = this.getKey(block);
        if (this.doorExists(key)) {
            return false;
        }
        Location location = block.getLocation();
        KeyCardDoor door = new KeyCardDoor(location, type);
        this.lockedDoors.put(key, door);
        this.saveDoorToConfig(key, block, type, null);
        return true;
    }

    public boolean addPlayerDoor(Block block, Player player) {
        if (this.doorExists(block)) {
            return false;
        }
        String key = this.getKey(block);
        String playerUUID = player.getUniqueId().toString();
        ArrayList<String> allowedPlayers = new ArrayList<String>();
        allowedPlayers.add(playerUUID);
        Location location = block.getLocation();
        PlayerDoor playerDoor = new PlayerDoor(location);
        playerDoor.addAllPlayers(allowedPlayers);
        this.lockedDoors.put(key, playerDoor);
        this.saveDoorToConfig(key, block, DoorTypes.PLAYER, allowedPlayers);
        return true;
    }

    public boolean removeLockedDoor(ZDoor door) {
        return this.removeLockedDoor(door.location.getBlock());
    }

    public boolean removeLockedDoor(Block block) {
        ZDoor door = this.getDoor(block);
        if (door == null) {
            return false;
        }
        String key = this.getKey(door.location.getBlock());
        this.lockedDoors.remove(key);
        this.removeDoorFromConfig(key);
        return true;
    }

    public void removeAllDoorsForPlayer(OfflinePlayer offlinePlayer) {
        String playerUUID = offlinePlayer.getUniqueId().toString();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, ZDoor> entry : this.lockedDoors.entrySet()) {
            PlayerDoor playerDoor;
            ZDoor zDoor = entry.getValue();
            if (!(zDoor instanceof PlayerDoor) || !playerUUID.equals((playerDoor = (PlayerDoor)zDoor).getOwnerUUID())) continue;
            keysToRemove.add(entry.getKey());
        }
        if (keysToRemove.isEmpty()) {
            return;
        }
        for (String key : keysToRemove) {
            this.lockedDoors.remove(key);
            this.removeDoorFromConfig(key);
        }
        this.saveConfig();
    }

    public void updateDoorData(PlayerDoor door) {
        Block block = door.location.getBlock();
        String key = this.getKey(block);
        YamlConfiguration config = this.loadConfig();
        config.set(this.buildConfigPath(key, "players"), door.allowedPlayersUUIDs);
        this.saveConfig(config);
    }

    public void rightClickAtDoor(PlayerInteractEvent event) {
        if (this.handleDoorItemInteraction(event)) {
            return;
        }
        Player player = event.getPlayer();
        ZDoor door = this.getDoor(event.getClickedBlock());
        if (door == null) {
            return;
        }
        if (door instanceof PlayerDoor) {
            PlayerDoor playerDoor = (PlayerDoor)door;
            this.handlePlayerDoorInteraction(event, player, playerDoor);
        }
    }

    private void initializeConfigFile() {
        this.configFile = new File(ZombiEraCore.instance.getDataFolder(), CONFIG_FILE_NAME);
    }

    private void createEmptyConfigFile() {
        try {
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
            YamlConfiguration config = new YamlConfiguration();
            config.save(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create door configuration file", e);
        }
    }

    private void loadDoorsFromConfig(World world) {
        YamlConfiguration config = this.loadConfig();
        ConfigurationSection doorsSection = config.getConfigurationSection(DOORS_SECTION);
        if (doorsSection == null) {
            return;
        }
        for (String key : doorsSection.getKeys(false)) {
            String doorWorld = config.getString(this.buildConfigPath(key, "world"));
            if (!world.getName().equals(doorWorld)) continue;
            this.loadDoor(config, key, world);
        }
    }

    private void loadDoor(YamlConfiguration config, String key, World world) {
        int x = config.getInt(this.buildConfigPath(key, "x"));
        int y = config.getInt(this.buildConfigPath(key, "y"));
        int z = config.getInt(this.buildConfigPath(key, "z"));
        Location location = new Location(world, (double)x, (double)y, (double)z);
        String typeString = config.getString(this.buildConfigPath(key, "type"));
        DoorTypes doorType = DoorTypes.valueOf(typeString.toUpperCase());
        if (doorType == DoorTypes.PLAYER) {
            this.loadPlayerDoor(config, key, location);
        } else {
            this.loadKeyCardDoor(key, location, doorType);
        }
    }

    private void loadPlayerDoor(YamlConfiguration config, String key, Location location) {
        PlayerDoor playerDoor = new PlayerDoor(location);
        if (config.isSet(this.buildConfigPath(key, "players"))) {
            List playerUUIDs = config.getStringList(this.buildConfigPath(key, "players"));
            playerDoor.addAllPlayers(playerUUIDs);
        }
        this.lockedDoors.put(key, playerDoor);
    }

    private void loadKeyCardDoor(String key, Location location, DoorTypes doorType) {
        KeyCardDoor keyCardDoor = new KeyCardDoor(location, doorType);
        this.lockedDoors.put(key, keyCardDoor);
    }

    private void saveDoorToConfig(String key, Block block, DoorTypes type, List<String> allowedPlayers) {
        YamlConfiguration config = this.loadConfig();
        config.set(this.buildConfigPath(key, "x"), (Object)block.getX());
        config.set(this.buildConfigPath(key, "y"), (Object)block.getY());
        config.set(this.buildConfigPath(key, "z"), (Object)block.getZ());
        config.set(this.buildConfigPath(key, "world"), (Object)block.getWorld().getName());
        config.set(this.buildConfigPath(key, "type"), (Object)type.toString());
        if (allowedPlayers != null) {
            config.set(this.buildConfigPath(key, "players"), allowedPlayers);
        }
        this.saveConfig(config);
    }

    private void removeDoorFromConfig(String key) {
        YamlConfiguration config = this.loadConfig();
        config.set(this.buildConfigPath(key, null), null);
        this.saveConfig(config);
    }

    private Block findAdjacentDoorBlock(Block block) {
        Block upBlock = block.getRelative(BlockFace.UP);
        Block downBlock = block.getRelative(BlockFace.DOWN);
        if (upBlock.getBlockData() instanceof Door) {
            return upBlock;
        }
        if (downBlock.getBlockData() instanceof Door) {
            return downBlock;
        }
        return null;
    }

    private boolean handleDoorItemInteraction(PlayerInteractEvent event) {
        ItemStack itemInHand = event.getPlayer().getInventory().getItemInMainHand();
        if (!this.hasCustomModelData(itemInHand)) {
            return false;
        }
        int itemId = itemInHand.getItemMeta().getCustomModelData();
        ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(itemId);
        if (!(itemBase instanceof UsableItemBase)) {
            return false;
        }
        UsableItemBase usableItemBase = (UsableItemBase)itemBase;
        Object doorMetadata = usableItemBase.getMetaData("door");
        if (doorMetadata != null && Boolean.TRUE.equals(doorMetadata)) {
            usableItemBase.playerItemUseByEvent(event);
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    private void handlePlayerDoorInteraction(PlayerInteractEvent event, Player player, PlayerDoor playerDoor) {
        if (!playerDoor.isAllowed(player)) {
            event.setCancelled(true);
            ZombiEraCore.playerInfo(player, LOCKED_DOOR_MESSAGE);
            return;
        }
        Door doorData = (Door)playerDoor.location.getBlock().getBlockData();
        String message = doorData.isOpen() ? DOOR_CLOSED_MESSAGE : DOOR_OPENED_MESSAGE;
        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), message, 5);
    }

    private boolean hasCustomModelData(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasCustomModelData();
    }

    private String buildConfigPath(String key, String property) {
        if (property == null) {
            return String.format("%s.%s", DOORS_SECTION, key);
        }
        return String.format("%s.%s.%s", DOORS_SECTION, key, property);
    }

    private YamlConfiguration loadConfig() {
        return YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    private void saveConfig(YamlConfiguration config) {
        try {
            config.save(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save door configuration", e);
        }
    }

    private void saveConfig() {
        this.saveConfig(this.loadConfig());
    }
}

