/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity;

import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;

public class EntityBase {
    public String dirName;
    String name;
    String handler;
    String vanillaEntity;
    EntityType entityType;
    EntityHandler entityHandler;
    HashMap<String, String> clothes;
    HashMap<String, ItemStack> clothesItems;
    Double health;
    Boolean globalSpawn;

    public EntityBase(String dirName, String name, String handler, String vanillaEntity, Double health, HashMap<String, String> clothes, Boolean globalSpawn) {
        this.name = name;
        this.handler = handler;
        this.vanillaEntity = vanillaEntity;
        this.entityType = EntityType.valueOf((String)vanillaEntity.toUpperCase());
        this.health = health;
        this.clothes = clothes;
        this.globalSpawn = globalSpawn;
        if (clothes != null) {
            this.clothesItems = new HashMap();
            clothes.forEach((key, value) -> {
                if (value.contains("material.")) {
                    this.clothesItems.put((String)key, new ItemStack(Material.valueOf((String)value.split("\\.")[1].toUpperCase())));
                } else {
                    this.clothesItems.put((String)key, ZombiEraCore.getItemManager().getItemBase((String)value).getItem());
                }
            });
        }
        this.entityHandler = ZombiEraCore.getEntityManager().entityHandlers.get(handler);
        this.dirName = dirName;
    }

    public HashMap<String, ItemStack> getClothesItems() {
        return (HashMap)this.clothesItems.clone();
    }

    public boolean hasClothes() {
        return this.clothes != null;
    }

    public EntityHandler getEntityHandler() {
        return this.entityHandler;
    }

    public String getName() {
        return this.name;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Double getMaxHealth() {
        return this.health;
    }
}

