/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.immersion.ZEGoreManager;

public interface EntityHandler {
    public static final List<EntityType> validClothEntities = new ArrayList<EntityType>(){
        {
            this.add(EntityType.ZOMBIE);
            this.add(EntityType.HUSK);
            this.add(EntityType.SKELETON);
            this.add(EntityType.DROWNED);
        }
    };

    public LivingEntity spawnEntity(Location var1, EntityBase var2);

    default public boolean setClothes(LivingEntity entity, EntityBase entityBase) {
        if (!validClothEntities.contains(entity.getType()) || !entityBase.hasClothes()) {
            return false;
        }
        HashMap<String, ItemStack> clothItems = entityBase.getClothesItems();
        EntityEquipment equipment = entity.getEquipment();
        if (clothItems.containsKey("head")) {
            equipment.setHelmet(clothItems.get("head"));
        }
        if (clothItems.containsKey("chest")) {
            equipment.setChestplate(clothItems.get("chest"));
        }
        if (clothItems.containsKey("legs")) {
            equipment.setLeggings(clothItems.get("legs"));
        }
        if (clothItems.containsKey("boots")) {
            equipment.setBoots(clothItems.get("boots"));
        }
        return true;
    }

    default public void defaultOnEntityDeath(EntityDeathEvent event) {
        ZEGoreManager.onEntityDeath(event);
        this.onEntityDeath(event);
    }

    public void onEntityDeath(EntityDeathEvent var1);

    public void onEntityHitsPlayer(EntityDamageByEntityEvent var1);

    public void onPlayerHitsEntity(EntityDamageByEntityEvent var1);

    default public void defaultEntityHitsPlayer(EntityDamageByEntityEvent event) {
        ZEGoreManager.onEntityHit(event);
        this.onEntityHitsPlayer(event);
    }

    default public void defaultPlayerHitsEntity(EntityDamageByEntityEvent event) {
        ZEGoreManager.onEntityHit(event);
        this.onPlayerHitsEntity(event);
    }

    default public void defaultOnEntityDamage(EntityDamageEvent event) {
        this.onEntityDamage(event);
    }

    public void onEntityDamage(EntityDamageEvent var1);

    default public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
    }
}

