/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity;

import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;
import zombieworldproject.zombieracore.managers.entity.handlers.Blinder;
import zombieworldproject.zombieracore.managers.entity.handlers.Boomer;
import zombieworldproject.zombieracore.managers.entity.handlers.Clicker;
import zombieworldproject.zombieracore.managers.entity.handlers.Electrified;
import zombieworldproject.zombieracore.managers.entity.handlers.Enraged;
import zombieworldproject.zombieracore.managers.entity.handlers.Exploder;
import zombieworldproject.zombieracore.managers.entity.handlers.FastWalker;
import zombieworldproject.zombieracore.managers.entity.handlers.Jumper;
import zombieworldproject.zombieracore.managers.entity.handlers.Lifter;
import zombieworldproject.zombieracore.managers.entity.handlers.MummifiedEagle;
import zombieworldproject.zombieracore.managers.entity.handlers.Pyromancer;
import zombieworldproject.zombieracore.managers.entity.handlers.RadioactiveWalker;
import zombieworldproject.zombieracore.managers.entity.handlers.RatLover;
import zombieworldproject.zombieracore.managers.entity.handlers.Sentinel;
import zombieworldproject.zombieracore.managers.entity.handlers.Siren;
import zombieworldproject.zombieracore.managers.entity.handlers.TankWalker;
import zombieworldproject.zombieracore.managers.entity.handlers.Thief;
import zombieworldproject.zombieracore.managers.entity.handlers.UndeadWolf;
import zombieworldproject.zombieracore.managers.entity.handlers.Walker;
import zombieworldproject.zombieracore.managers.item.ZERarityDropManager;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.player.states.PlayerStats;
import zombieworldproject.zombieracore.managers.spawners.LocalSpawnerItem;
import zombieworldproject.zombieracore.managers.zones.ConfigZone;
import zombieworldproject.zombieracore.managers.zones.ZoneTypes;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZEEntityManager {
    private static final int BARBED_WIRE_SLOWNESS_DURATION_TICKS = 10;
    private static final int ENTITY_KILL_DISTANCE_BLOCKS = 30;
    private static final int ENTITY_KILL_BUFFER_SIZE = 2;
    private static final int SPAWN_DISTANCE_MIN_BLOCKS = 12;
    private static final int SPAWN_DISTANCE_RANGE_BLOCKS = 23;
    private static final double DROP_HEIGHT_OFFSET = 0.5;
    private final Map<Integer, String> livingEntities = new HashMap<Integer, String>();
    public Map<String, EntityBase> zwEntities = new HashMap<String, EntityBase>();
    public Map<String, EntityHandler> entityHandlers = new HashMap<String, EntityHandler>();
    public Map<Player, List<LivingEntity>> perPlayerEntities = new HashMap<Player, List<LivingEntity>>();
    public Map<Player, List<LocalDateTime>> playerLastKills = new HashMap<Player, List<LocalDateTime>>();
    private final Map<String, EntityBase> globalSpawnEntities = new HashMap<String, EntityBase>();
    private final List<EntityBase> globalSpawnEntitiesThreshold = new ArrayList<EntityBase>();
    private final SecureRandom random = new SecureRandom();

    public ZEEntityManager() {
        this.registerEntityHandlers();
        this.startBackgroundTasks();
    }

    private void registerEntityHandlers() {
        this.entityHandlers.put("boomer", new Boomer());
        this.entityHandlers.put("fastwalker", new FastWalker());
        this.entityHandlers.put("walker", new Walker());
        this.entityHandlers.put("mummifiedeagle", new MummifiedEagle());
        this.entityHandlers.put("tank", new TankWalker());
        this.entityHandlers.put("undeadwolf", new UndeadWolf());
        this.entityHandlers.put("blinder", new Blinder());
        this.entityHandlers.put("lifter", new Lifter());
        this.entityHandlers.put("radioactive", new RadioactiveWalker());
        this.entityHandlers.put("ratlover", new RatLover());
        this.entityHandlers.put("exploder", new Exploder());
        this.entityHandlers.put("pyromancer", new Pyromancer());
        this.entityHandlers.put("siren", new Siren());
        this.entityHandlers.put("thief", new Thief());
        this.entityHandlers.put("jumper", new Jumper());
        this.entityHandlers.put("enraged", new Enraged());
        this.entityHandlers.put("electrified", new Electrified());
        this.entityHandlers.put("clicker", new Clicker());
        this.entityHandlers.put("sentinel", new Sentinel());
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        this.playerLastKills.put(event.getPlayer(), new ArrayList());
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        this.playerLastKills.remove(event.getPlayer());
    }

    public void onPlayerDeathEvent(PlayerDeathEvent event) {
        List<LocalDateTime> killTimestamps = this.playerLastKills.get(event.getPlayer());
        if (killTimestamps != null) {
            killTimestamps.clear();
        }
    }

    public void clear() {
        this.zwEntities.clear();
        this.globalSpawnEntities.clear();
        this.globalSpawnEntitiesThreshold.clear();
    }

    public EntityBase getEntityBaseByName(String name) {
        return this.zwEntities.get(name);
    }

    public void addEntity(String dirName, String name, String vanillaEntity, String handler, Double health, HashMap<String, String> clothes, Boolean globalSpawn, Integer spawnWeight) {
        EntityBase entityBase = new EntityBase(dirName, name, handler, vanillaEntity, health, clothes, globalSpawn);
        this.zwEntities.put(dirName, entityBase);
        if (globalSpawn.booleanValue()) {
            this.globalSpawnEntities.put(dirName, entityBase);
            this.addToSpawnThreshold(entityBase, spawnWeight);
        }
    }

    private void addToSpawnThreshold(EntityBase entityBase, Integer spawnWeight) {
        for (int i = 0; i < spawnWeight; ++i) {
            this.globalSpawnEntitiesThreshold.add(entityBase);
        }
    }

    public EntityBase getRandomGlobalEntityBase() {
        if (this.globalSpawnEntitiesThreshold.isEmpty()) {
            return null;
        }
        return this.globalSpawnEntitiesThreshold.get(this.random.nextInt(this.globalSpawnEntitiesThreshold.size()));
    }

    public void registerEntity(Integer entityId, String entityName) {
        this.livingEntities.put(entityId, entityName);
    }

    public void unRegisterEntity(Integer entityId) {
        this.livingEntities.remove(entityId);
    }

    public String getRegisteredName(Integer entityId) {
        return this.livingEntities.get(entityId);
    }

    public Boolean isRegisteredEntity(Integer entityId) {
        return this.livingEntities.containsKey(entityId);
    }

    public boolean summonEntity(String name, Player player) {
        return this.summonEntity(name, player.getLocation());
    }

    public boolean summonEntity(String name, Location location) {
        EntityBase entityBase = this.zwEntities.get(name);
        if (entityBase == null) {
            return false;
        }
        LivingEntity entity = entityBase.getEntityHandler().spawnEntity(location, entityBase);
        this.registerEntity(entity.getEntityId(), name);
        return true;
    }

    public LivingEntity tryRandomSpawn(EntityBase entityBase, Location location, World world) {
        if (!this.canSpawn(entityBase.getEntityType(), location)) {
            return null;
        }
        LivingEntity entity = entityBase.entityHandler.spawnEntity(location, entityBase);
        this.registerEntity(entity.getEntityId(), entityBase.dirName);
        return entity;
    }

    public LivingEntity spawnEntity(EntityBase entityBase, Location location) {
        LivingEntity entity = entityBase.entityHandler.spawnEntity(location, entityBase);
        this.registerEntity(entity.getEntityId(), entityBase.dirName);
        return entity;
    }

    public void handleEntityTargetLivingEntity(EntityTargetLivingEntityEvent event, EntityBase entityBase) {
        entityBase.entityHandler.onEntityTargetLivingEntity(event);
    }

    public void handleEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        this.handleSpawnerEntityDeath(entity, event);
        String dirName = this.getRegisteredName(entity.getEntityId());
        if (dirName == null) {
            return;
        }
        this.updatePlayerStatsOnKill(event);
        this.trackNearbyPlayerKills(event);
        this.handleEntityDrops(event, entity, dirName);
        this.handleCustomEntityDeath(event, dirName);
        this.unRegisterEntity(entity.getEntityId());
    }

    private void handleSpawnerEntityDeath(LivingEntity entity, EntityDeathEvent event) {
        LocalSpawnerItem spawner = ZombiEraCore.getLocalSpawnerManager().getSpawnerForEntity(entity);
        if (spawner != null) {
            spawner.entityDeathEvent(event);
        }
    }

    private void updatePlayerStatsOnKill(EntityDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        if (killer != null) {
            PlayerStats stats = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(killer).getPlayerStats();
            stats.addZombieKill();
        }
    }

    private void trackNearbyPlayerKills(EntityDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        Location deathLocation = event.getEntity().getLocation();
        boolean isDay = ZombiEraCore.getRealTimeManager().isDay();
        int maxEntityAmount = isDay ? ZombiEraSettings.ENTITIES_PER_PLAYER_DAY : ZombiEraSettings.ENTITIES_PER_PLAYER_NIGHT;
        for (Player player : deathLocation.getWorld().getPlayers()) {
            if (!this.isPlayerNearby(player, deathLocation)) continue;
            this.addKillTimestamp(player, maxEntityAmount);
        }
    }

    private boolean isPlayerNearby(Player player, Location location) {
        return location.distance(player.getLocation()) <= 30.0;
    }

    private void addKillTimestamp(Player player, int maxEntityAmount) {
        List<LocalDateTime> killTimestamps = this.playerLastKills.get(player);
        if (killTimestamps == null) {
            return;
        }
        if (killTimestamps.size() < maxEntityAmount + 2) {
            killTimestamps.add(LocalDateTime.now());
            ZombiEraCore.debugInfo("Added to last kills timestamp for player " + player.getName() + " at " + String.valueOf(LocalDateTime.now()));
        }
    }

    private void handleEntityDrops(EntityDeathEvent event, LivingEntity entity, String dirName) {
        event.getDrops().clear();
        ZERarityDropManager.EntityDrop entityDrop = ZombiEraCore.getRarityDropManager().entityDrops.get(dirName);
        if (entityDrop == null) {
            return;
        }
        Location dropLocation = entity.getLocation().add(0.0, 0.5, 0.0);
        List<ItemStack> drops = entityDrop.getDrops();
        for (ItemStack item : drops) {
            if (item == null) continue;
            entity.getWorld().dropItemNaturally(dropLocation, item);
        }
    }

    private void handleCustomEntityDeath(EntityDeathEvent event, String dirName) {
        EntityBase entityBase = this.getEntityBaseByName(dirName);
        entityBase.getEntityHandler().defaultOnEntityDeath(event);
    }

    public void handleEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        String dirName = this.getRegisteredName(event.getDamager().getEntityId());
        if (dirName != null) {
            this.handleEntityAttack(event, dirName);
            return;
        }
        if (event.getDamager().getType() == EntityType.PLAYER) {
            this.handlePlayerAttack(event);
        }
    }

    private void handleEntityAttack(EntityDamageByEntityEvent event, String dirName) {
        EntityBase entityBase = this.getEntityBaseByName(dirName);
        entityBase.getEntityHandler().defaultEntityHitsPlayer(event);
    }

    private void handlePlayerAttack(EntityDamageByEntityEvent event) {
        String dirName = this.getRegisteredName(event.getEntity().getEntityId());
        if (dirName != null) {
            EntityBase entityBase = this.getEntityBaseByName(dirName);
            entityBase.getEntityHandler().defaultPlayerHitsEntity(event);
        }
    }

    public void handleEntityDamageEvent(EntityDamageEvent event) {
        String dirName = this.getRegisteredName(event.getEntity().getEntityId());
        if (dirName != null) {
            EntityBase entityBase = this.getEntityBaseByName(dirName);
            entityBase.getEntityHandler().defaultOnEntityDamage(event);
        }
    }

    public boolean canSpawn(EntityType type, Location location) {
        return switch (type) {
            case EntityType.COD, EntityType.PUFFERFISH, EntityType.TROPICAL_FISH, EntityType.SALMON, EntityType.TURTLE, EntityType.RABBIT, EntityType.DOLPHIN, EntityType.CHICKEN, EntityType.CAT, EntityType.OCELOT, EntityType.WOLF, EntityType.PIG, EntityType.ENDERMITE, EntityType.SILVERFISH, EntityType.CAVE_SPIDER, EntityType.PHANTOM, EntityType.VEX, EntityType.GUARDIAN, EntityType.SPIDER, EntityType.SQUID, EntityType.BAT, EntityType.PARROT -> this.checkBox(1, 1, location);
            case EntityType.SHEEP, EntityType.COW, EntityType.MUSHROOM_COW, EntityType.LLAMA, EntityType.SHULKER, EntityType.ZOMBIE, EntityType.HUSK, EntityType.DROWNED, EntityType.CREEPER, EntityType.BLAZE, EntityType.EVOKER, EntityType.VILLAGER, EntityType.WITCH, EntityType.VINDICATOR, EntityType.ILLUSIONER, EntityType.PILLAGER, EntityType.SKELETON, EntityType.STRAY, EntityType.SNOWMAN, EntityType.PLAYER -> this.checkBox(1, 2, location);
            case EntityType.PANDA, EntityType.POLAR_BEAR, EntityType.HORSE, EntityType.ELDER_GUARDIAN -> this.checkBox(2, 1, location);
            case EntityType.RAVAGER, EntityType.WITHER -> this.checkBox(2, 3, location);
            case EntityType.SLIME, EntityType.MAGMA_CUBE -> this.checkBox(3, 3, location);
            case EntityType.GHAST -> this.checkBox(4, 4, location);
            case EntityType.GIANT -> this.checkBox(4, 12, location);
            case EntityType.ENDER_CRYSTAL -> this.checkBox(16, 8, location);
            default -> true;
        };
    }

    public boolean checkBox(int width, int height, Location location) {
        if (location.getBlock().getRelative(BlockFace.DOWN).isEmpty()) {
            return false;
        }
        World world = location.getWorld();
        int startX = location.getBlockX();
        int startY = location.getBlockY();
        int startZ = location.getBlockZ();
        for (int x = startX; x < startX + width; ++x) {
            for (int y = startY; y < startY + height; ++y) {
                for (int z = startZ; z < startZ + width; ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    if (block.isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void startBackgroundTasks() {
        this.startBarbedWireTask();
        this.startEntityManagementTask();
    }

    private void startBarbedWireTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ZEEntityManager.this.handleBarbedWireCollision(player);
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, (long)ZombiEraSettings.BARBED_WIRE_UPDATE_TICKS.intValue());
    }

    private void handleBarbedWireCollision(Player player) {
        Location location = player.getLocation();
        Material blockType = location.getWorld().getBlockAt(location).getType();
        if (blockType != Material.valueOf((String)ZombiEraSettings.BARBED_WIRE_BLOCK)) {
            return;
        }
        player.damage((double)ZombiEraSettings.BARBED_WIRE_DAMAGE.intValue());
        if (ZombiEraSettings.BARBED_WIRE_SLOWNESS.booleanValue()) {
            this.applyBarbedWireEffects(player);
        }
    }

    private void applyBarbedWireEffects(Player player) {
        int amplifier = ZombiEraSettings.BARBED_WIRE_SLOWNESS_MULTIPLIER;
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 10, amplifier));
        player.setVelocity(new Vector(0, -1, 0));
    }

    private void startEntityManagementTask() {
        new BukkitRunnable(){

            public void run() {
                ZEEntityManager.this.perPlayerEntities.forEach((player, entities) -> ZEEntityManager.this.processPlayerEntities((Player)player, (List<LivingEntity>)entities));
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, (long)ZombiEraSettings.ENTITY_MANAGER_UPDATE_TICKS.intValue());
    }

    private void processPlayerEntities(Player player, List<LivingEntity> entities) {
        this.removeInvalidEntities(entities);
        this.handleBarbedWireDamageForEntities(entities);
        this.cleanupExpiredKillTimestamps(player);
        if (this.shouldSpawnNewEntity(player, entities)) {
            this.attemptEntitySpawn(player, entities);
        }
    }

    private void removeInvalidEntities(List<LivingEntity> entities) {
        entities.removeIf(entity -> !entity.isValid() || entity.isDead());
    }

    private void handleBarbedWireDamageForEntities(List<LivingEntity> entities) {
        if (ZombiEraSettings.BARBED_WIRE_DAMAGE_PLAYER_ONLY.booleanValue()) {
            return;
        }
        Material barbedWireMaterial = Material.valueOf((String)ZombiEraSettings.BARBED_WIRE_BLOCK);
        double damage = (double)ZombiEraSettings.BARBED_WIRE_DAMAGE.intValue() * ZombiEraSettings.BARBED_WIRE_DAMAGE_ZOMBIE_MULTIPLIER;
        for (LivingEntity entity : entities) {
            Location location = entity.getLocation();
            if (location.getWorld().getBlockAt(location).getType() != barbedWireMaterial) continue;
            entity.damage(damage);
            if (!ZombiEraSettings.BARBED_WIRE_SLOWNESS.booleanValue()) continue;
            entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 10, ZombiEraSettings.BARBED_WIRE_SLOWNESS_MULTIPLIER.intValue()));
        }
    }

    private void cleanupExpiredKillTimestamps(Player player) {
        List<LocalDateTime> killTimestamps = this.playerLastKills.get(player);
        if (killTimestamps == null) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime cutoffTime = now.minusSeconds(ZombiEraSettings.ENTITIES_PER_PLAYER_KILL_SAFETY_DELAY.intValue());
        killTimestamps.removeIf(timestamp -> {
            boolean expired = timestamp.isBefore(cutoffTime);
            if (expired) {
                ZombiEraCore.debugInfo(String.format("Removed last kill timestamp for player %s", player.getName()));
            }
            return expired;
        });
    }

    private boolean shouldSpawnNewEntity(Player player, List<LivingEntity> entities) {
        if (player.getGameMode() == GameMode.SPECTATOR || player.getGameMode() == GameMode.CREATIVE) {
            return false;
        }
        PlayerHealth playerHealth = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (playerHealth.isInSafeZone()) {
            return false;
        }
        boolean isDay = ZombiEraCore.getRealTimeManager().isDay();
        int maxEntityAmount = isDay ? ZombiEraSettings.ENTITIES_PER_PLAYER_DAY : ZombiEraSettings.ENTITIES_PER_PLAYER_NIGHT;
        int totalEntities = entities.size() + this.playerLastKills.get(player).size();
        ZombiEraCore.debugInfo(String.format("Total entities for player %s: %d", player.getName(), totalEntities));
        return totalEntities < maxEntityAmount;
    }

    private void attemptEntitySpawn(Player player, List<LivingEntity> entities) {
        EntityBase entityBase = this.selectEntityForSpawn(player);
        if (entityBase == null) {
            return;
        }
        Location spawnLocation = this.calculateSpawnLocation(player);
        if (ZombiEraCore.getZoneManager().checkForZoneAtLocation(ZoneTypes.SAFE, spawnLocation)) {
            return;
        }
        LivingEntity entity = this.tryRandomSpawn(entityBase, spawnLocation, player.getWorld());
        if (entity != null) {
            entities.add(entity);
            ZombiEraCore.debugInfo(String.format("Spawned entity %s for player %s", entityBase.dirName, player.getName()));
        }
    }

    private EntityBase selectEntityForSpawn(Player player) {
        PlayerHealth playerHealth = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        ConfigZone configZone = playerHealth.getLastConfigZone();
        if (configZone != null) {
            return configZone.getRandomSpawnEntityBase();
        }
        return this.getRandomGlobalEntityBase();
    }

    private Location calculateSpawnLocation(Player player) {
        Location playerLocation = player.getLocation().clone();
        int xOffset = (12 + this.random.nextInt(23)) * MiscUtils.randomNegativePositiveInt();
        int zOffset = (12 + this.random.nextInt(23)) * MiscUtils.randomNegativePositiveInt();
        return playerLocation.add((double)xOffset, 0.0, (double)zOffset);
    }
}

