/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import java.util.List;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class Boomer
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        final LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        entity.setCustomNameVisible(true);
        entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, Integer.MAX_VALUE, 1));
        entity.setCustomName(entityBase.getName());
        entity.getEquipment().clear();
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setCanBreakDoors(true);
            zombie.setBaby(false);
            zombie.setJumping(true);
        }
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        final World world = location.getWorld();
        final Random rand = new Random();
        new BukkitRunnable(){

            public void run() {
                if (!entity.isValid()) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    Location loc = entity.getLocation();
                    loc.add((double)(rand.nextInt(2) * MiscUtils.randomNegativePositiveInt()), 0.5, (double)(rand.nextInt(2) * MiscUtils.randomNegativePositiveInt()));
                    Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)0, (int)255, (int)0), Color.fromRGB((int)144, (int)238, (int)144), 1.0f);
                    world.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                }
                List entities = entity.getNearbyEntities(2.0, 2.0, 2.0);
                for (Entity e : entities) {
                    if (!(e instanceof Player)) continue;
                    Player player = (Player)e;
                    entity.getWorld().createExplosion(entity.getLocation(), 2.0f, false, false);
                    ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).setInfection(HealthStates.INFECTION, true);
                    for (int i = 0; i < 10; ++i) {
                        Location loc = entity.getLocation();
                        loc.add((double)(rand.nextInt(2) * MiscUtils.randomNegativePositiveInt()), 0.5, (double)(rand.nextInt(2) * MiscUtils.randomNegativePositiveInt()));
                        Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)0, (int)255, (int)0), Color.fromRGB((int)144, (int)238, (int)144), 1.0f);
                        world.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                        loc.add(0.0, 0.75, 0.0);
                        world.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                        loc.add(0.0, 0.75, 0.0);
                        world.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc, 30, (Object)dustTransition);
                    }
                    entity.remove();
                    this.cancel();
                    return;
                }
                world.playSound(entity.getLocation(), Sound.ENTITY_CREEPER_HURT, 0.5f, 0.25f);
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 80L, 20L);
        this.setClothes(entity, entityBase);
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
    }
}

