/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class Clicker
implements EntityHandler {
    public static List<String> clickerSounds = new ArrayList<String>(){
        {
            this.add("clicker1");
            this.add("clicker2");
        }
    };

    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        final LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        entity.setCustomNameVisible(true);
        entity.getEquipment().clear();
        entity.setCustomName(entityBase.getName());
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setCanBreakDoors(true);
            zombie.setBaby(false);
            zombie.setJumping(true);
        }
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        this.setClothes(entity, entityBase);
        entity.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1));
        new BukkitRunnable(){

            public void run() {
                if (entity.isValid()) {
                    if (MiscUtils.generateChange(15.0f)) {
                        ZombiEraCore.getSoundManager().playSound(entity.getLocation(), MiscUtils.getRandomEntry(clickerSounds));
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 30L);
        return entity;
    }

    @Override
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        LivingEntity livingEntity = event.getTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.isSneaking() || player.getLocation().distance(event.getEntity().getLocation()) > 8.0) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
        Player player = (Player)event.getEntity();
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 20, 3));
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
    }
}

