/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;

public class Electrified
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        final LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        entity.setCustomNameVisible(true);
        entity.getEquipment().clear();
        entity.setCustomName(entityBase.getName());
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setCanBreakDoors(true);
            zombie.setBaby(false);
            zombie.setJumping(true);
        }
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 99999, 1));
        new BukkitRunnable(){

            public void run() {
                if (entity.isValid()) {
                    ZombiEraCore.getSoundManager().playSound(entity.getLocation(), "being_tased");
                    for (int i = 0; i < 10; ++i) {
                        double randomAngle = Math.PI * 2 * new Random().nextDouble();
                        double randomElevation = Math.PI * new Random().nextDouble();
                        double x = 2.0 * Math.sin(randomElevation) * Math.cos(randomAngle);
                        double y = 2.0 * Math.sin(randomElevation) * Math.sin(randomAngle);
                        double z = 2.0 * Math.cos(randomElevation);
                        Vector offset = new Vector(x, z, y);
                        Location particleLocation = entity.getLocation().clone().add(offset);
                        entity.getLocation().getWorld().spawnParticle(Particle.FIREWORKS_SPARK, particleLocation, 10, 0.025, 0.025, 0.025, 0.025);
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 30L);
        this.setClothes(entity, entityBase);
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
        Player player = (Player)event.getEntity();
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 1));
        ZombiEraCore.getSoundManager().playSound(player.getLocation(), "taser_fire");
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
    }
}

