/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;

public class Jumper
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        final LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        entity.setCustomNameVisible(true);
        entity.getEquipment().clear();
        entity.setCustomName(entityBase.getName());
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setCanBreakDoors(true);
            zombie.setBaby(false);
            zombie.setJumping(true);
        }
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        new BukkitRunnable(){
            final Monster monster;
            {
                this.monster = (Monster)entity;
            }

            public void run() {
                if (entity.isValid()) {
                    Player player;
                    LivingEntity target = this.monster.getTarget();
                    if (target instanceof Player && (player = (Player)target).getLocation().distance(entity.getLocation()) < 8.0) {
                        Location entityLocation = entity.getLocation();
                        Location playerLocation = player.getLocation();
                        double verticalDistance = playerLocation.getY() - entityLocation.getY();
                        if (verticalDistance >= 2.0) {
                            Vector direction = playerLocation.toVector().subtract(entityLocation.toVector()).normalize();
                            double maxJumpDistance = 4.0;
                            double jumpSpeed = 0.9;
                            if (direction.length() > maxJumpDistance) {
                                direction.multiply(maxJumpDistance);
                            }
                            entity.setVelocity(direction.multiply(jumpSpeed));
                        }
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 60L);
        this.setClothes(entity, entityBase);
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
            event.setCancelled(true);
        }
    }
}

