/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class Pyromancer
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        final LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        entity.setCustomNameVisible(true);
        entity.getEquipment().clear();
        entity.setCustomName(entityBase.getName());
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setCanBreakDoors(true);
            zombie.setBaby(false);
            zombie.setJumping(true);
        }
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        final int numParticles = 10;
        final double maxRadius = 1.0;
        new BukkitRunnable(){
            final double angle = 0.0;

            public void run() {
                if (!entity.isValid()) {
                    this.cancel();
                    return;
                }
                Location loc = entity.getLocation();
                for (int i = 0; i < numParticles; ++i) {
                    double angle = Math.toRadians(Math.random() * 360.0);
                    double radius = Math.random() * maxRadius;
                    double x = loc.getX() + radius * Math.cos(angle);
                    double z = loc.getZ() + radius * Math.sin(angle);
                    Location particleLocation = new Location(loc.getWorld(), x, loc.getY() + 1.0, z);
                    loc.getWorld().spawnParticle(Particle.FLAME, particleLocation, 1, 0.02, 0.0, 0.0, 0.02);
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 30L);
        this.setClothes(entity, entityBase);
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
        Location location = event.getEntity().getLocation();
        if (MiscUtils.generateChange(25.0f) && location.getBlock().isEmpty()) {
            location.getBlock().setType(Material.FIRE);
        }
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
        Location location = event.getDamager().getLocation();
        Random random = new Random();
        int radius = 4;
        int maxAttempts = 6;
        int minAttempts = 2;
        for (int attempts = 0; attempts < random.nextInt(minAttempts, maxAttempts); ++attempts) {
            Location loc = location.clone();
            loc.add((double)(random.nextInt(0, radius) * MiscUtils.randomNegativePositiveInt()), 0.0, (double)(random.nextInt(0, radius) * MiscUtils.randomNegativePositiveInt()));
            if (!loc.getBlock().isEmpty()) continue;
            loc.getBlock().setType(Material.FIRE);
        }
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE)) {
            event.setCancelled(true);
        }
    }
}

