/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class RadioactiveWalker
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        entity.setCustomNameVisible(true);
        entity.getEquipment().clear();
        entity.setCustomName(entityBase.getName());
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setCanBreakDoors(true);
            zombie.setBaby(false);
            zombie.setJumping(true);
        }
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        this.setClothes(entity, entityBase);
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
        final Player player = (Player)event.getEntity();
        final Integer[] count = new Integer[]{0};
        new BukkitRunnable(){

            public void run() {
                ZombiEraCore.getSoundManager().playSound(player, "radiationhit", 1.0f, 1.0f + MiscUtils.globalRandom.nextFloat() * 0.15f);
                player.damage(1.0);
                count[0] = count[0] + 1;
                if (count[0] > 4) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 10L);
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
    }
}

