/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Warden;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;

public class Sentinel
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        final LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        entity.setCustomNameVisible(true);
        entity.getEquipment().clear();
        entity.setCustomName(entityBase.getName());
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setCanBreakDoors(true);
            zombie.setBaby(false);
            zombie.setJumping(true);
        }
        if (entity instanceof Warden) {
            final Warden warden = (Warden)entity;
            warden.setAggressive(true);
            warden.setAware(true);
            new BukkitRunnable(){
                final int detectPlayerRadius = 20;

                public void run() {
                    if (warden.getTarget() == null || warden.getTarget().getLocation().distance(entity.getLocation()) > 20.0) {
                        Player nearestPlayer = null;
                        double nearestDistance = Double.MAX_VALUE;
                        for (Player player : entity.getWorld().getPlayers()) {
                            double distance = player.getLocation().distance(entity.getLocation());
                            if (!(distance < 20.0) || nearestPlayer != null && !(distance < nearestDistance)) continue;
                            nearestPlayer = player;
                            nearestDistance = distance;
                        }
                        if (nearestPlayer != null && nearestPlayer != warden.getTarget() && !nearestPlayer.getGameMode().equals((Object)GameMode.CREATIVE) && !nearestPlayer.getGameMode().equals((Object)GameMode.SPECTATOR)) {
                            warden.setTarget((LivingEntity)nearestPlayer);
                            warden.setAnger((Entity)nearestPlayer, 1000);
                        }
                    }
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 20L);
        }
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        this.setClothes(entity, entityBase);
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
        if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.SONIC_BOOM) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.PROJECTILE)) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
    }
}

