/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;

public class TankWalker
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        final LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        final IronGolem golem = (IronGolem)entity;
        entity.setCustomNameVisible(true);
        entity.setCustomName(entityBase.getName());
        entity.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1));
        entity.getEquipment().clear();
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        new BukkitRunnable(){

            public void run() {
                if (!entity.isValid()) {
                    this.cancel();
                    return;
                }
                List nearbyPlayers = golem.getNearbyEntities((double)ZombiEraSettings.IRON_GOLEM_ATTACK_PLAYER_RANGE.intValue(), (double)ZombiEraSettings.IRON_GOLEM_ATTACK_PLAYER_RANGE.intValue(), (double)ZombiEraSettings.IRON_GOLEM_ATTACK_PLAYER_RANGE.intValue());
                LivingEntity livingEntity = golem.getTarget();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (golem.getLocation().distance(player.getLocation()) > 25.0) {
                        golem.setTarget(null);
                    } else {
                        return;
                    }
                }
                if (golem.getTarget() == null) {
                    for (Entity e : nearbyPlayers) {
                        if (!(e instanceof Player)) continue;
                        golem.setTarget((LivingEntity)e);
                        break;
                    }
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, (long)ZombiEraSettings.IRON_GOLEM_UPDATE_TICKS.intValue());
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
    }
}

