/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class Thief
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        entity.setCustomNameVisible(true);
        entity.getEquipment().clear();
        entity.setCustomName(entityBase.getName());
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setCanBreakDoors(true);
            zombie.setBaby(false);
            zombie.setJumping(true);
        }
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        this.setClothes(entity, entityBase);
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
        if (MiscUtils.generateChange(25.0f)) {
            Player player = (Player)event.getEntity();
            PlayerInventory playerInventory = player.getInventory();
            ArrayList<Integer> slotNumbers = new ArrayList<Integer>();
            for (int i = 0; i < playerInventory.getSize(); ++i) {
                if (playerInventory.getItem(i) == null) continue;
                slotNumbers.add(i);
            }
            if (slotNumbers.size() > 0) {
                int randomSlot = MiscUtils.globalRandom.nextInt(0, slotNumbers.size() - 1);
                int slot = (Integer)slotNumbers.get(randomSlot);
                ItemStack item = playerInventory.getItem(slot).clone();
                playerInventory.setItem(slot, null);
                event.getDamager().getWorld().dropItem(event.getDamager().getLocation(), item);
                ZombiEraCore.playerInfo(player, "You have been robbed!");
            }
        }
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
    }
}

