/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.entity.handlers;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.EntityHandler;

public class UndeadWolf
implements EntityHandler {
    @Override
    public LivingEntity spawnEntity(Location location, EntityBase entityBase) {
        LivingEntity entity = (LivingEntity)location.getWorld().spawnEntity(location, entityBase.getEntityType());
        final Wolf wolf = (Wolf)entity;
        wolf.setAngry(true);
        entity.setCustomNameVisible(true);
        entity.setCustomName(entity.getName());
        entity.getEquipment().clear();
        if (ZombiEraSettings.HIDE_ZOMBIE_NAME_TAGS.booleanValue()) {
            entity.setCustomNameVisible(false);
        }
        if (entityBase.getMaxHealth() != -1.0) {
            entity.setMaxHealth(entityBase.getMaxHealth().doubleValue());
            entity.setHealth(entityBase.getMaxHealth().doubleValue());
        }
        new BukkitRunnable(){

            public void run() {
                if (!wolf.isValid()) {
                    this.cancel();
                    return;
                }
                List nearbyPlayers = wolf.getNearbyEntities((double)ZombiEraSettings.WOLF_ATTACK_PLAYER_RANGE.intValue(), (double)ZombiEraSettings.WOLF_ATTACK_PLAYER_RANGE.intValue(), (double)ZombiEraSettings.WOLF_ATTACK_PLAYER_RANGE.intValue());
                LivingEntity livingEntity = wolf.getTarget();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (wolf.getLocation().distance(player.getLocation()) > 25.0) {
                        wolf.setTarget(null);
                    } else {
                        return;
                    }
                }
                if (wolf.getTarget() == null) {
                    for (Entity e : nearbyPlayers) {
                        if (!(e instanceof Player)) continue;
                        wolf.setTarget((LivingEntity)e);
                        break;
                    }
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, (long)ZombiEraSettings.WOLF_UPDATE_TICKS.intValue());
        return entity;
    }

    @Override
    public void onEntityDeath(EntityDeathEvent event) {
    }

    @Override
    public void onEntityHitsPlayer(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onPlayerHitsEntity(EntityDamageByEntityEvent event) {
    }

    @Override
    public void onEntityDamage(EntityDamageEvent event) {
    }
}

