/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.ZEPropManager;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public final class ZEGoreManager {
    public static ZEPropManager propManager = ZombiEraCore.getPropManager();
    public static List<EntityType> allowedEntities = new ArrayList<EntityType>(){
        {
            this.add(EntityType.ZOMBIE);
            this.add(EntityType.HUSK);
            this.add(EntityType.DROWNED);
            this.add(EntityType.SKELETON);
            this.add(EntityType.IRON_GOLEM);
        }
    };
    public static List<String> bloodSplatter = new ArrayList<String>(){
        {
            this.add("gore_blood_stain_01");
            this.add("gore_blood_stain_02");
            this.add("gore_blood_stain_03");
            this.add("gore_blood_stain_04");
            this.add("gore_blood_stain_05");
        }
    };
    public static List<String> zombieParts = new ArrayList<String>(){
        {
            this.add("gore_zombiepart_01");
            this.add("gore_zombiepart_02");
            this.add("gore_zombiepart_03");
            this.add("gore_zombiepart_04");
        }
    };
    public static List<String> bodies = new ArrayList<String>(){
        {
            this.add("gore_zombiepart_body_01");
            this.add("gore_zombiepart_body_02");
            this.add("gore_zombiepart_body_03");
        }
    };
    public static List<String> heads = new ArrayList<String>(){
        {
            this.add("gore_zombiepart_head_01");
            this.add("gore_zombiepart_head_02");
            this.add("gore_zombiepart_head_03");
        }
    };
    public static List<String> bloodSplashSound = new ArrayList<String>(){
        {
            this.add("bloodsplash0");
            this.add("bloodsplash1");
            this.add("bloodsplash2");
        }
    };

    public static void playerBleed(Player player) {
        Location location = player.getLocation();
        ArrayList<String> propsToDrop = new ArrayList<String>();
        if (MiscUtils.generateChance(15)) {
            propsToDrop.add(MiscUtils.getRandomEntry(bloodSplatter));
            ZombiEraCore.getSoundManager().playSound(player.getLocation(), MiscUtils.getRandomEntry(bloodSplashSound));
        }
        ZEGoreManager.dropParts(propsToDrop, location);
    }

    public static void dropParts(List<String> parts, Location location) {
        for (String part : parts) {
            Location loc = location.clone();
            float randomYaw = MiscUtils.globalRandom.nextFloat() * 360.0f;
            float randomPitch = MiscUtils.globalRandom.nextFloat() * 180.0f - 90.0f;
            loc.setYaw(randomYaw);
            loc.setPitch(randomPitch);
            loc.add(0.0, 1.5, 0.0);
            Random random = new Random();
            double angle = Math.toRadians(random.nextDouble() * 360.0);
            double distance = (double)random.nextFloat() + 0.5;
            double xOffset = distance * Math.cos(angle);
            double zOffset = distance * Math.sin(angle);
            Location targetLocation = loc.add(xOffset, 0.0, zOffset);
            PropData propData = propManager.addPropToWorldNotSaved(propManager.getPropByDirName(part), targetLocation);
        }
    }

    public static void onEntityHit(EntityDamageByEntityEvent event) {
        ArrayList<String> propsToDrop = new ArrayList<String>();
        if (MiscUtils.generateChance(30)) {
            propsToDrop.add(MiscUtils.getRandomEntry(bloodSplatter));
            ZombiEraCore.getSoundManager().playSound(event.getEntity().getLocation(), MiscUtils.getRandomEntry(bloodSplashSound));
        }
        ZEGoreManager.dropParts(propsToDrop, event.getEntity().getLocation());
    }

    public static void onEntityDeath(EntityDeathEvent event) {
        if (!allowedEntities.contains(event.getEntity().getType())) {
            return;
        }
        Location entityLocation = event.getEntity().getLocation();
        ArrayList<String> propsToDrop = new ArrayList<String>();
        if (MiscUtils.generateChange(10.0f)) {
            propsToDrop.add(MiscUtils.getRandomEntry(heads));
        }
        if (MiscUtils.generateChange(30.0f)) {
            for (int i = 0; i < 2; ++i) {
                if (!MiscUtils.generateChange(50.0f)) continue;
                propsToDrop.add(MiscUtils.getRandomEntry(zombieParts));
            }
        }
        if (MiscUtils.generateChange(20.0f)) {
            propsToDrop.add(MiscUtils.getRandomEntry(bodies));
        }
        if (propsToDrop.size() == 0) {
            return;
        }
        ZombiEraCore.getSoundManager().playSound(event.getEntity().getLocation(), MiscUtils.getRandomEntry(bloodSplashSound));
        ZEGoreManager.dropParts(propsToDrop, entityLocation);
    }
}

