/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;

public class ZETimeManager {
    private static final long TICKS_PER_SECOND = 20L;
    private long dayLengthInTicks = 24000L;
    private long startTime = System.currentTimeMillis();
    private boolean enabled = false;
    BukkitTask thread = null;

    public void setDayLengthInTicks(long dayLengthInTicks) {
        this.dayLengthInTicks = dayLengthInTicks;
    }

    public boolean isDay() {
        return this.isTimeBetween(this.getCurrentArcadeTimeString(), "6:00", "19:00");
    }

    public boolean isTimeBetween(String timeToCheck, String startTime, String endTime) {
        String[] timeToCheckParts = timeToCheck.split(":");
        String[] startTimeParts = startTime.split(":");
        String[] endTimeParts = endTime.split(":");
        int checkHour = Integer.parseInt(timeToCheckParts[0]);
        int checkMinute = Integer.parseInt(timeToCheckParts[1]);
        int startHour = Integer.parseInt(startTimeParts[0]);
        int startMinute = Integer.parseInt(startTimeParts[1]);
        int endHour = Integer.parseInt(endTimeParts[0]);
        int endMinute = Integer.parseInt(endTimeParts[1]);
        int totalCheckMinutes = checkHour * 60 + checkMinute;
        int totalStartMinutes = startHour * 60 + startMinute;
        int totalEndMinutes = endHour * 60 + endMinute;
        return totalCheckMinutes >= totalStartMinutes && totalCheckMinutes <= totalEndMinutes;
    }

    public long getDayLengthInTicks() {
        return this.dayLengthInTicks;
    }

    public void enable() {
        this.enabled = true;
        this.start();
    }

    public void disable() {
        this.enabled = false;
        if (this.thread != null) {
            this.thread.cancel();
            this.thread = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private int[] getCurrentArcadeTime() {
        long currentTime = System.currentTimeMillis();
        long elapsedMillis = currentTime - this.startTime;
        long arcadeMillisPerDay = this.dayLengthInTicks * 1000L / 20L;
        long totalArcadeMinutes = elapsedMillis * 24L * 60L / arcadeMillisPerDay;
        int arcadeHour = (int)((totalArcadeMinutes %= 1440L) / 60L);
        int arcadeMinute = (int)(totalArcadeMinutes % 60L);
        return new int[]{arcadeHour, arcadeMinute};
    }

    public int[] getCurrentArcadeTimePublic() {
        return this.getCurrentArcadeTime();
    }

    private int arcadeTimeToMinecraftTicks(int arcadeHour, int arcadeMinute) {
        int currentMinutes = arcadeHour * 60 + arcadeMinute;
        int minecraftDayStartTime = 360;
        int elapsedMinutes = currentMinutes - minecraftDayStartTime;
        if (elapsedMinutes < 0) {
            elapsedMinutes += 1440;
        }
        int minecraftTicks = (int)((double)elapsedMinutes / 1440.0 * 24000.0) % 24000;
        return minecraftTicks;
    }

    public void start() {
        if (this.thread != null) {
            this.thread.cancel();
        }
        this.startTime = System.currentTimeMillis();
        this.thread = new BukkitRunnable(){

            public void run() {
                if (!ZETimeManager.this.enabled) {
                    this.cancel();
                    return;
                }
                ZETimeManager.this.syncTime();
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 20L);
    }

    private void syncTime() {
        String targetWorldName = null;
        try {
            targetWorldName = ZombiEraSettings.TIME_WORLD;
        }
        catch (Exception exception) {
            // empty catch block
        }
        World world = targetWorldName != null ? Bukkit.getWorld((String)targetWorldName) : (World)Bukkit.getWorlds().get(0);
        if (world == null) {
            return;
        }
        int[] arcadeTime = this.getCurrentArcadeTime();
        int arcadeHour = arcadeTime[0];
        int arcadeMinute = arcadeTime[1];
        int ticks = this.arcadeTimeToMinecraftTicks(arcadeHour, arcadeMinute);
        world.setTime((long)ticks);
    }

    public void resetArcadeTime() {
        this.startTime = System.currentTimeMillis();
    }

    public String getCurrentArcadeTimeString() {
        int[] time = this.getCurrentArcadeTime();
        return String.format("%02d:%02d", time[0], time[1]);
    }

    public void setArcadeTime(int hour, int minute) {
        int totalMinutes = hour * 60 + minute;
        long arcadeMillisPerDay = this.dayLengthInTicks * 1000L / 20L;
        long elapsedMillisForThisTime = (long)totalMinutes * arcadeMillisPerDay / 1440L;
        this.startTime = System.currentTimeMillis() - elapsedMillisForThisTime;
    }
}

