/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZEWorldImmersionSoundManager {
    public static final int UPDATE_TIMER = 60;
    public final Map<Player, SoundTime> soundPlaying = new HashMap<Player, SoundTime>();
    public final Map<String, SoundTime> soundTracks = ZEWorldImmersionSoundManager.createSoundTracks();
    public final List<String> soundsInside = new ArrayList<String>(List.of("wood1", "wood2"));
    public final List<String> soundsOutsideDay = new ArrayList<String>();
    public final List<String> soundsOutsideNight = new ArrayList<String>(List.of("cricket1", "cricket2", "cricket3", "cricket4"));
    public final List<String> soundsOutside = new ArrayList<String>(List.of("wind1", "wind2", "wind3", "wind4", "wind5"));

    private static Map<String, SoundTime> createSoundTracks() {
        HashMap<String, SoundTime> tracks = new HashMap<String, SoundTime>();
        tracks.put("soundtrack1", new SoundTime("soundtrack1", 800, 1.0f));
        tracks.put("soundtrack2", new SoundTime("soundtrack2", 400, 1.0f));
        tracks.put("soundtrack3", new SoundTime("soundtrack3", 600, 1.0f));
        tracks.put("soundtrack5", new SoundTime("soundtrack5", 700, 1.0f));
        tracks.put("soundtrack6", new SoundTime("soundtrack6", 700, 1.0f));
        tracks.put("soundtrack7", new SoundTime("soundtrack7", 700, 1.0f));
        tracks.put("soundtrack8", new SoundTime("soundtrack8", 700, 1.0f));
        tracks.put("soundtrack9", new SoundTime("soundtrack9", 700, 1.0f));
        tracks.put("soundtrack10", new SoundTime("soundtrack10", 700, 1.0f));
        tracks.put("soundtrack11", new SoundTime("soundtrack11", 700, 1.0f));
        return Collections.unmodifiableMap(tracks);
    }

    public static boolean hasBlockOfTypeAroundPlayer(Player player, Material type, int radius) {
        Location playerLocation = player.getLocation();
        World world = player.getWorld();
        int startX = playerLocation.getBlockX() - radius;
        int startY = playerLocation.getBlockY() - radius;
        int startZ = playerLocation.getBlockZ() - radius;
        int endX = playerLocation.getBlockX() + radius;
        int endY = playerLocation.getBlockY() + radius;
        int endZ = playerLocation.getBlockZ() + radius;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    if (world.getBlockAt(x, y, z).getType() != type) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPlayerInside(Player player, int radius, int maxHeight, int solidBlockThreshold) {
        Location playerLocation = player.getLocation();
        World world = player.getWorld();
        int playerY = playerLocation.getBlockY();
        int startY = playerY + 1;
        int endY = Math.min(startY + maxHeight, playerY + 21);
        int startX = playerLocation.getBlockX() - radius;
        int startZ = playerLocation.getBlockZ() - radius;
        int endX = playerLocation.getBlockX() + radius;
        int endZ = playerLocation.getBlockZ() + radius;
        int solidBlockCount = 0;
        for (int y = startY; y <= endY; ++y) {
            for (int x = startX; x <= endX; ++x) {
                for (int z = startZ; z <= endZ; ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    if (block.getType().isTransparent()) continue;
                    ++solidBlockCount;
                }
            }
        }
        return solidBlockCount >= solidBlockThreshold && playerLocation.getBlock().getLightFromSky() < 15;
    }

    public void run() {
        new BukkitRunnable(){

            public void run() {
                for (final Player player2 : Bukkit.getOnlinePlayers()) {
                    ZEWorldImmersionSoundManager.this.runSoundTrack(player2);
                    if (MiscUtils.generateChange(8.0f) && ZEWorldImmersionSoundManager.isPlayerInside(player2, 3, 20, 3)) {
                        ZombiEraCore.getSoundManager().playSound(player2, MiscUtils.getRandomEntry(ZEWorldImmersionSoundManager.this.soundsInside));
                    }
                    if (MiscUtils.generateChange(0.5f) && !ZEWorldImmersionSoundManager.isPlayerInside(player2, 3, 20, 3)) {
                        ZombiEraCore.getSoundManager().playSound(player2, "howl");
                    }
                    if (MiscUtils.generateChange(15.0f) && !ZEWorldImmersionSoundManager.isPlayerInside(player2, 3, 20, 3)) {
                        ZombiEraCore.getSoundManager().playSound(player2, MiscUtils.getRandomEntry(ZEWorldImmersionSoundManager.this.soundsOutside));
                    }
                    if (ZEWorldImmersionSoundManager.this.isDay(player2) || !MiscUtils.generateChange(70.0f) || ZEWorldImmersionSoundManager.isPlayerInside(player2, 3, 15, 3)) continue;
                    new BukkitRunnable(){
                        int count = 0;

                        public void run() {
                            ++this.count;
                            ZombiEraCore.getSoundManager().playSound(player2, MiscUtils.getRandomEntry(ZEWorldImmersionSoundManager.this.soundsOutsideNight), 0.1f, 1.0f);
                            if (this.count == 5) {
                                this.cancel();
                            }
                        }
                    }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 17L);
                }
                ArrayList toRemove = new ArrayList();
                ZEWorldImmersionSoundManager.this.soundPlaying.forEach((player, soundTime) -> {
                    if (soundTime.isDone()) {
                        toRemove.add(player);
                    }
                });
                toRemove.forEach(ZEWorldImmersionSoundManager.this.soundPlaying::remove);
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 60L);
    }

    public void runSoundTrack(Player player) {
        Map.Entry<String, SoundTime> entry;
        if (!this.soundPlaying.containsKey(player) && MiscUtils.generateChange(1.0f) && (entry = MiscUtils.getRandomEntry(this.soundTracks)) != null) {
            this.playSoundTime(player, entry.getValue());
        }
    }

    public void playSoundTime(Player player, SoundTime soundTime) {
        if (this.soundPlaying.containsKey(player) || soundTime == null) {
            return;
        }
        ZombiEraCore.getSoundManager().playSound(player, soundTime.sound, soundTime.volume, 1.0f);
        try {
            SoundTime clonedSoundTime = (SoundTime)soundTime.clone();
            this.soundPlaying.put(player, clonedSoundTime);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone SoundTime", e);
        }
    }

    public boolean isDay(Player player) {
        return player.getWorld().getTime() <= 12000L;
    }

    public static class SoundTime
    implements Cloneable {
        public final String sound;
        public final int lengthTicks;
        public final float volume;
        private int ticksNow = 0;

        public SoundTime(String sound, int lengthTicks, float volume) {
            this.sound = sound;
            this.lengthTicks = lengthTicks;
            this.volume = volume;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public boolean isDone() {
            if (this.ticksNow > this.lengthTicks) {
                this.ticksNow = 0;
                return true;
            }
            this.ticksNow += 60;
            return false;
        }
    }
}

