/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion.events;

import java.util.Random;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.immersion.events.EventType;

public abstract class EventBase {
    private final Integer minPlayers;
    public Integer minTicks;
    public Integer maxTicks;
    public EventType eventType;
    private Integer selectedTicks = null;
    private Integer ticks = 0;

    public EventBase(Integer minTicks, Integer maxTicks, Integer minPlayers) {
        this.minPlayers = minPlayers;
        this.minTicks = minTicks;
        this.maxTicks = maxTicks;
    }

    public Integer getMinPlayers() {
        return this.minPlayers;
    }

    public Integer getSelectedTicks() {
        return new Random().nextInt(this.minTicks, this.maxTicks);
    }

    public boolean tick() {
        if (this.selectedTicks == null) {
            this.selectedTicks = this.getSelectedTicks();
        }
        this.ticks = this.ticks + 1;
        if (this.ticks >= this.selectedTicks) {
            this.start();
            return true;
        }
        return false;
    }

    private void start() {
        ZombiEraCore.debugInfo("Event has been triggered: " + this.eventType.toString());
        this.reset();
        this.run();
    }

    private void reset() {
        this.ticks = 0;
        this.selectedTicks = null;
    }

    public abstract void run();
}

