/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion.events;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.immersion.events.EventBase;
import zombieworldproject.zombieracore.managers.immersion.events.EventType;
import zombieworldproject.zombieracore.managers.immersion.events.handlers.BombardingEvent;
import zombieworldproject.zombieracore.managers.immersion.events.handlers.NukeEvent;
import zombieworldproject.zombieracore.managers.immersion.events.handlers.SupplyDropEvent;
import zombieworldproject.zombieracore.managers.immersion.events.handlers.ZombieHorde;

public class ZEEventManager {
    public List<EventBase> events = new ArrayList<EventBase>();

    public ZEEventManager() {
        this.run();
    }

    public void clearConfigSettings() {
        this.events.clear();
    }

    public void loadEventFromConfig(EventType eventType, Integer minTicks, Integer maxTicks, Integer minPlayers) {
        EventBase event = null;
        switch (eventType) {
            case SUPPLY_DROP: {
                event = new SupplyDropEvent(minTicks, maxTicks, minPlayers);
                break;
            }
            case BOMBARDING: {
                event = new BombardingEvent(minTicks, maxTicks, minPlayers);
                break;
            }
            case ZOMBIE_HORDE: {
                event = new ZombieHorde(minTicks, maxTicks, minPlayers);
                break;
            }
            case NUKE: {
                event = new NukeEvent(minTicks, maxTicks, minPlayers);
            }
        }
        this.events.add(event);
    }

    public void run() {
        new BukkitRunnable(){

            public void run() {
                Integer playersNow = Bukkit.getOnlinePlayers().size();
                ZEEventManager.this.events.forEach(event -> {
                    if (playersNow >= event.getMinPlayers()) {
                        event.tick();
                    }
                });
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
    }
}

