/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion.events.handlers;

import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.immersion.events.EventBase;
import zombieworldproject.zombieracore.managers.immersion.events.EventType;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class BombardingEvent
extends EventBase {
    public BombardingEvent(Integer minTicks, Integer maxTicks, Integer minPlayers) {
        super(minTicks, maxTicks, minPlayers);
        this.eventType = EventType.BOMBARDING;
    }

    public static void bombardLocation(final Location location) {
        new BukkitRunnable(){
            final Integer maxTicks = 3600;
            final Integer radius = 100;
            final Integer eachTick = 5;
            Integer ticks = 0;

            public void run() {
                this.ticks = this.ticks + 1;
                if (this.ticks > this.maxTicks) {
                    this.cancel();
                } else if (this.ticks % this.eachTick == 0) {
                    Location bombLoc = location.clone().add((double)(MiscUtils.randomNegativePositiveInt() * MiscUtils.generateBetweenNumbers(0, this.radius)), 0.0, (double)(MiscUtils.randomNegativePositiveInt() * MiscUtils.generateBetweenNumbers(0, this.radius)));
                    bombLoc = bombLoc.add(0.0, (double)BombardingEvent.getYCoords(bombLoc).intValue(), 0.0);
                    PropData propData = ZombiEraCore.getPropManager().addPropToWorldNotSaved(ZombiEraCore.getPropManager().getPropByDirName("air_bomb"), bombLoc);
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
    }

    public static Integer getYCoords(Location location) {
        Integer highestY = location.getWorld().getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
        if ((highestY = Integer.valueOf(highestY + 100)) < 250) {
            return highestY;
        }
        return -1;
    }

    @Override
    public void run() {
        this.randomlyBombard();
    }

    public void randomlyBombard() {
        Location location = ZombiEraCore.getZoneManager().getRandomLivableZoneLocation();
        if (location != null) {
            BombardingEvent.bombardLocation(location);
        }
    }
}

