/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion.events.handlers;

import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.immersion.events.EventBase;
import zombieworldproject.zombieracore.managers.immersion.events.EventType;
import zombieworldproject.zombieracore.misc.utils.BlockUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class NukeEvent
extends EventBase {
    public NukeEvent(Integer minTicks, Integer maxTicks, Integer minPlayers) {
        super(minTicks, maxTicks, minPlayers);
        this.eventType = EventType.BOMBARDING;
    }

    public static void spawnNukeAtLocation(Location location) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals((Object)location.getWorld()) || !(player.getLocation().distance(location) < 700.0)) continue;
            ZombiEraCore.getSoundManager().playSound(player, "atomicbomb");
        }
        location.add(0.0, 1.0, 0.0);
        NukeEvent.spawnMushroom(location.clone());
        NukeEvent.boom(location.clone());
    }

    public static void spawnMushroom(Location location) {
        final Location startLoc = location.clone();
        new BukkitRunnable(){
            final Integer maxTicks = 300;
            final Integer eachTick = 5;
            double radius = 0.0;
            double ovalRadius = 0.2;
            double height = 1.0;
            Integer ticks = 0;

            public void run() {
                this.ticks = this.ticks + 1;
                if (this.ticks > this.maxTicks) {
                    this.cancel();
                } else if (this.ticks % this.eachTick == 0 && this.ticks % 5 == 0) {
                    this.radius += 0.3;
                    this.ovalRadius += 0.125;
                    this.height += 2.0;
                    this.height = Math.min(this.height, 30.0);
                    NukeEvent.spawnParticleMushroomCloud(startLoc.clone().add(0.0, this.height, 0.0), this.radius, 1, 1.5);
                    if (this.ticks % 10 == 0) {
                        NukeEvent.spawnParticleCylinder(startLoc, this.ovalRadius, this.height + 10.0, 1);
                    }
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
    }

    public static void spawnParticleCylinder(Location center, double radius, double height, int density) {
        World world = center.getWorld();
        int numParticles = (int)(Math.PI * 2 * radius * height * (double)density);
        for (int i = 0; i < numParticles; ++i) {
            double u = Math.random();
            double v = Math.random();
            double theta = Math.PI * 2 * u;
            double z = height * (v - 0.5);
            double x = radius * Math.cos(theta);
            double y = radius * Math.sin(theta);
            Location particleLocation = center.clone().add(x, z, y);
            world.spawnParticle(Particle.REDSTONE, particleLocation, 0, 0.001, 1.0, 0.0, 1.0, (Object)new Particle.DustOptions(Color.GRAY, 2.0f), true);
        }
    }

    public static void spawnParticleMushroomCloud(Location center, double radius, int density, double verticalStretch) {
        World world = center.getWorld();
        int numParticles = (int)(Math.PI * 4 * radius * radius * (double)density);
        for (int i = 0; i < numParticles; ++i) {
            double u = Math.random();
            double v = Math.random();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(1.0 - 2.0 * v);
            double x = radius * Math.sin(phi) * Math.cos(theta);
            double y = radius * Math.sin(phi) * Math.sin(theta);
            double z = verticalStretch * radius * Math.cos(phi);
            Location particleLocation = center.clone().add(x, y, z);
            world.spawnParticle(Particle.FLAME, particleLocation, 5, 0.0, 0.0, 0.0, 0.0, null, true);
        }
    }

    public static void boom(final Location location) {
        new BukkitRunnable(){
            final Integer maxTicks = 300;
            final Integer eachTick = 5;
            double radius = 0.0;
            Integer layers = 1;
            Integer ticks = 0;

            public void run() {
                this.ticks = this.ticks + 1;
                if (this.ticks > this.maxTicks) {
                    this.cancel();
                } else if (this.ticks % this.eachTick == 0) {
                    if (this.ticks % 30 == 0) {
                        this.layers = this.layers + 1;
                    }
                    this.radius += 1.0;
                    for (int i = 0; i < 2; ++i) {
                        final double tempRadius = this.radius;
                        new BukkitRunnable(){

                            public void run() {
                                NukeEvent.spreadBoom(location, tempRadius, layers, 2.0);
                            }
                        }.runTaskLater((Plugin)ZombiEraCore.instance, (long)(40 * i));
                    }
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
    }

    public static void spreadBoom(Location center, double radius, int layers, double density) {
        float power = 2.0f;
        int numExplosions = (int)(radius * Math.PI * density);
        for (int explosionCount = 0; explosionCount < numExplosions; ++explosionCount) {
            double randomAngle = Math.random() * 2.0 * Math.PI;
            double x = center.getX() + radius * Math.cos(randomAngle);
            double y = center.getY();
            double z = center.getZ() + radius * Math.sin(randomAngle);
            Location explosionLocation = new Location(center.getWorld(), x, y, z);
            int yHighest = center.getWorld().getHighestBlockAt(explosionLocation).getY();
            explosionLocation.setY((double)yHighest);
            if (MiscUtils.generateChange(5.0f)) {
                BlockUtils.detectAndLaunchBlocks(explosionLocation, 5, 200L);
            }
            explosionLocation.add(0.0, (double)MiscUtils.generateBetweenNumbers(0, layers).intValue(), 0.0);
            center.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, explosionLocation, 1, 0.0, 0.0, 0.0, 0.0, null, true);
            if (MiscUtils.generateChange(30.0f)) {
                NukeEvent.spreadFire(explosionLocation, 3.0, 5.0);
            }
            explosionLocation.getWorld().playSound(explosionLocation, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 0.6f);
            explosionLocation.getNearbyPlayers(3.0).forEach(player -> player.damage(10.0));
        }
    }

    public static void spreadFire(Location center, double radius, double chance) {
        World world = center.getWorld();
        chance /= 100.0;
        int x = (int)(center.getX() - radius);
        while ((double)x <= center.getX() + radius) {
            int y = (int)(center.getY() - radius);
            while ((double)y <= center.getY() + radius) {
                int z = (int)(center.getZ() - radius);
                while ((double)z <= center.getZ() + radius) {
                    Block block;
                    Location currentLoc = new Location(world, (double)x, (double)y, (double)z);
                    if (center.distance(currentLoc) <= radius && (block = currentLoc.getBlock()).getType() == Material.AIR && BlockUtils.hasSolidBlockUnderneath(block.getLocation()) && Math.random() < chance) {
                        block.setType(Material.FIRE);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void run() {
    }
}

