/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion.events.handlers;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.immersion.events.EventBase;
import zombieworldproject.zombieracore.managers.immersion.events.EventType;

public class SupplyDropEvent
extends EventBase {
    public SupplyDropEvent(Integer minTicks, Integer maxTicks, Integer minPlayers) {
        super(minTicks, maxTicks, minPlayers);
        this.eventType = EventType.SUPPLY_DROP;
    }

    public static void spawnSupplyDropAtLocation(Location location) {
        ZombiEraCore.getSoundManager().playSound(location, "plane", (Double)800.0);
        Integer y = SupplyDropEvent.getYCoordsForSupplyDrop(location);
        if (y == -1) {
            return;
        }
        location.setY((double)y.intValue());
        ZombiEraCore.getPropManager().addPropToWorldNotSaved(ZombiEraCore.getPropManager().getPropByDirName("loot_supplydrop_closed"), location);
        ZombiEraCore.allPlayerInfo("\n-------------------------------------\n" + String.valueOf(ChatColor.AQUA) + "SupplyDrop Manager" + String.format("%s: [%sInfo%s]", ChatColor.WHITE, ChatColor.GREEN, ChatColor.WHITE) + "\n" + String.valueOf(ChatColor.GREEN) + "INCOMING SUPPLY DROP\n" + String.valueOf(ChatColor.WHITE) + "x: " + location.getBlockX() + " y: " + location.getBlockY() + " z: " + location.getBlockZ() + "\n-------------------------------------");
    }

    public static void randomlySpawnSupplyDropInLiveableZones() {
        Location location = ZombiEraCore.getZoneManager().getRandomLivableZoneLocation();
        if (location != null) {
            SupplyDropEvent.spawnSupplyDropAtLocation(location);
        }
    }

    public static Integer getYCoordsForSupplyDrop(Location location) {
        Integer highestY = location.getWorld().getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
        if ((highestY = Integer.valueOf(highestY + 100)) < 250) {
            return highestY;
        }
        return -1;
    }

    @Override
    public void run() {
        SupplyDropEvent.randomlySpawnSupplyDropInLiveableZones();
    }
}

