/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion.events.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.entity.ZEEntityManager;
import zombieworldproject.zombieracore.managers.immersion.events.EventBase;
import zombieworldproject.zombieracore.managers.immersion.events.EventType;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.zones.ZoneTypes;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZombieHorde
extends EventBase {
    public ZombieHorde(Integer minTicks, Integer maxTicks, Integer minPlayers) {
        super(minTicks, maxTicks, minPlayers);
        this.eventType = EventType.ZOMBIE_HORDE;
    }

    public static Location getRandomEmptyLocation(Player player, int locationRadius, int playerRadius) {
        Location playerLocation = player.getLocation();
        World world = player.getWorld();
        int x = playerLocation.getBlockX();
        int y = playerLocation.getBlockY();
        int z = playerLocation.getBlockZ();
        Random random = new Random();
        int maxAttempts = 20;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            int offsetZ;
            int offsetY;
            int offsetX = random.nextInt(2 * locationRadius + 1) - locationRadius;
            Location loc = new Location(world, (double)(x + offsetX), (double)(y + (offsetY = random.nextInt(2 * locationRadius + 1) - locationRadius)), (double)(z + (offsetZ = random.nextInt(2 * locationRadius + 1) - locationRadius)));
            if (!(playerLocation.distance(loc) <= (double)locationRadius)) continue;
            boolean playersNearby = false;
            for (Player nearbyPlayer : Bukkit.getOnlinePlayers()) {
                if (!(nearbyPlayer.getLocation().distance(loc) <= (double)playerRadius)) continue;
                playersNearby = true;
                break;
            }
            if (playersNearby) continue;
            return loc;
        }
        return null;
    }

    public static void spawnHorde(Location location) {
        ZEEntityManager entityManager = ZombiEraCore.getEntityManager();
        for (int j = 0; j < MiscUtils.generateBetweenNumbers(4, 8); ++j) {
            boolean canSpawn = false;
            Location newLoc = location.clone();
            for (int attempt = 0; attempt < 4; ++attempt) {
                newLoc.add((double)(MiscUtils.randomNegativePositiveInt() * MiscUtils.generateBetweenNumbers(7, 15)), 0.0, (double)(MiscUtils.randomNegativePositiveInt() * MiscUtils.generateBetweenNumbers(7, 15)));
                if (!entityManager.canSpawn(EntityType.ZOMBIE, newLoc)) continue;
                canSpawn = true;
                break;
            }
            if (!canSpawn) {
                ZombiEraCore.debugInfo("ZombieHorde -> did not find location to spawn");
                continue;
            }
            if (ZombiEraCore.getZoneManager().checkForZoneAtLocation(ZoneTypes.SAFE, newLoc)) {
                ZombiEraCore.debugInfo("ZombieHorde -> spawn location is safe zone, can't spawn!");
                continue;
            }
            ZombiEraCore.debugInfo("ZombieHorde -> spawn");
            final Villager villager = (Villager)newLoc.getWorld().spawnEntity(newLoc, EntityType.VILLAGER);
            villager.setInvisible(true);
            villager.setAI(false);
            villager.setInvulnerable(true);
            villager.setPersistent(true);
            final ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
            for (int i = 0; i < MiscUtils.generateBetweenNumbers(25, 45); ++i) {
                EntityBase entityBase = entityManager.getRandomGlobalEntityBase();
                LivingEntity livingEntity = entityManager.spawnEntity(entityBase, newLoc);
                entities.add(livingEntity);
            }
            new BukkitRunnable(){

                public void run() {
                    ArrayList toDelete = new ArrayList();
                    entities.forEach(entity -> {
                        if (!entity.isValid()) {
                            toDelete.add(entity);
                            return;
                        }
                        Mob mob = (Mob)entity;
                        LivingEntity target = mob.getTarget();
                        if (target == null || !target.getType().equals((Object)EntityType.PLAYER)) {
                            mob.setTarget((LivingEntity)villager);
                        }
                    });
                    toDelete.forEach(entity -> entities.remove(entity));
                    if (entities.size() == 0) {
                        villager.remove();
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 5L);
        }
    }

    @Override
    public void run() {
        List onlinePlayers = (List)Bukkit.getOnlinePlayers();
        if (onlinePlayers.size() == 0) {
            return;
        }
        Player player = null;
        for (int attempts = 0; attempts < 5; ++attempts) {
            player = (Player)onlinePlayers.get(MiscUtils.globalRandom.nextInt(0, onlinePlayers.size()));
            PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
            if (!ph.isInSafeZone() && !player.getGameMode().equals((Object)GameMode.CREATIVE) && !player.getGameMode().equals((Object)GameMode.SPECTATOR)) break;
            player = null;
        }
        if (player == null) {
            return;
        }
        Location location = ZombieHorde.getRandomEmptyLocation(player, 50, 40);
        int y = location.getWorld().getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
        location = new Location(location.getWorld(), (double)location.getBlockX(), (double)(y + 1), (double)location.getBlockZ());
        ZombieHorde.spawnHorde(location);
    }
}

