/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.immersion.weather;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.immersion.ZEWorldImmersionSoundManager;
import zombieworldproject.zombieracore.managers.immersion.weather.WeatherTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public final class ZEWeatherManager {
    public static Double defaultTemperature = 22.0;
    public static Integer weatherUpdateTicks = 100;
    public static Integer weatherTicks = 20;
    public static Map<WeatherTypes, Integer> weatherTypeTicks = new HashMap<WeatherTypes, Integer>();
    private final List<WeatherTypes> weatherTypesWeightList = new ArrayList<WeatherTypes>();
    public WeatherTypes currentWeather = WeatherTypes.SUNNY;
    public boolean running = false;
    public BukkitTask weatherTask = null;

    public ZEWeatherManager() {
        this.reload();
    }

    public void reload() {
        int i;
        this.weatherTypesWeightList.clear();
        weatherTypeTicks.clear();
        weatherTypeTicks.put(WeatherTypes.SUNNY, ZombiEraSettings.WEATHER_SUNNY_DURATION);
        weatherTypeTicks.put(WeatherTypes.RAIN, ZombiEraSettings.WEATHER_RAIN_DURATION);
        weatherTypeTicks.put(WeatherTypes.RADIATION_RAIN, ZombiEraSettings.WEATHER_RADIATION_RAIN_DURATION);
        weatherTypeTicks.put(WeatherTypes.STORM, ZombiEraSettings.WEATHER_STORM_DURATION);
        for (i = 0; i < ZombiEraSettings.WEATHER_SUNNY_WEIGHT; ++i) {
            this.weatherTypesWeightList.add(WeatherTypes.SUNNY);
        }
        for (i = 0; i < ZombiEraSettings.WEATHER_RAIN_WEIGHT; ++i) {
            this.weatherTypesWeightList.add(WeatherTypes.RAIN);
        }
        for (i = 0; i < ZombiEraSettings.WEATHER_RADIATION_RAIN_WEIGHT; ++i) {
            this.weatherTypesWeightList.add(WeatherTypes.RADIATION_RAIN);
        }
        for (i = 0; i < ZombiEraSettings.WEATHER_STORM_WEIGHT; ++i) {
            this.weatherTypesWeightList.add(WeatherTypes.STORM);
        }
    }

    public void run() {
        new BukkitRunnable(){

            public void run() {
                if (!ZEWeatherManager.this.running && MiscUtils.generateChange(50.0f)) {
                    ZEWeatherManager.this.changeWeather();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, (long)weatherUpdateTicks.intValue());
    }

    public void setWeather(WeatherTypes type) {
        this.currentWeather = type;
        for (World world : Bukkit.getWorlds()) {
            switch (type) {
                case SUNNY: {
                    world.setStorm(false);
                    world.setThundering(false);
                    break;
                }
                case RAIN: {
                    world.setStorm(true);
                    world.setThundering(false);
                    break;
                }
                case STORM: {
                    world.setStorm(true);
                    world.setThundering(true);
                    break;
                }
                case RADIATION_RAIN: {
                    world.setStorm(true);
                    world.setThundering(false);
                }
            }
        }
    }

    public void changeWeather() {
        WeatherTypes type = MiscUtils.getRandomEntry(this.weatherTypesWeightList);
        this.changeWeather(type);
    }

    public void changeWeather(final WeatherTypes type) {
        if (this.weatherTask != null && this.running) {
            this.weatherTask.cancel();
        }
        this.running = true;
        this.setWeather(type);
        Integer minTicks = weatherTypeTicks.get((Object)type);
        final Integer nowTicks = MiscUtils.generateBetweenNumbers(minTicks, minTicks + minTicks / 2);
        this.weatherTask = new BukkitRunnable(){
            float count = 0.0f;

            public void run() {
                this.count += (float)weatherTicks.intValue();
                switch (type) {
                    case STORM: {
                        ZEWeatherManager.this.stormTick();
                    }
                }
                switch (type) {
                    case RADIATION_RAIN: {
                        ZEWeatherManager.this.radiationStormTick();
                    }
                }
                if (this.count > (float)nowTicks.intValue()) {
                    ZEWeatherManager.this.running = false;
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, (long)weatherTicks.intValue());
    }

    public void radiationStormTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (ZEWorldImmersionSoundManager.isPlayerInside(player, 3, 20, 3)) continue;
            ZombiEraCore.getTitleOverlayManager().sendRadiationOverlay(player);
            if (!MiscUtils.generateChance(20) || ZEEquipmentsManager.playerEquipmentInventories.get(player).getTotalRadiationProtection() > 0.0) continue;
            player.damage(0.5);
            ZombiEraCore.getSoundManager().playSound(player, "radiationhit");
        }
    }

    public void stormTick() {
        int count = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (MiscUtils.generateChange(20.0f)) {
                Location loc = player.getLocation().clone();
                loc.add((double)((float)MiscUtils.randomNegativePositiveInt().intValue() * MiscUtils.globalRandom.nextFloat() * 60.0f), 0.0, (double)((float)MiscUtils.randomNegativePositiveInt().intValue() * MiscUtils.globalRandom.nextFloat() * 60.0f));
                int y = loc.getWorld().getHighestBlockYAt(loc);
                loc.setY((double)y);
                player.getWorld().spawn(loc, LightningStrike.class);
                ++count;
            }
            if (count <= 5) continue;
            break;
        }
    }
}

