/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.door.DoorTypes;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.ThrowableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.food.CannedFoodItemBase;
import zombieworldproject.zombieracore.managers.item.bases.food.FoodItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.AmmoTypes;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.BulletShootHandler;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.EnergyShootHandler;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.FlameThrowerShootHandler;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.GrenadeShootHandler;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.NormalShootHandler;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.handlers.ShotgunShootHandler;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.item.builtIn.admin.StructureSelector;
import zombieworldproject.zombieracore.managers.item.builtIn.ammo.AmmoBox;
import zombieworldproject.zombieracore.managers.item.builtIn.ammo.AmmoItem;
import zombieworldproject.zombieracore.managers.item.builtIn.building.Barricade;
import zombieworldproject.zombieracore.managers.item.builtIn.building.BuildHammer;
import zombieworldproject.zombieracore.managers.item.builtIn.door.keycards.Keycard;
import zombieworldproject.zombieracore.managers.item.builtIn.door.player.PlayerLock;
import zombieworldproject.zombieracore.managers.item.builtIn.eletric.Battery;
import zombieworldproject.zombieracore.managers.item.builtIn.eletric.Flashlight;
import zombieworldproject.zombieracore.managers.item.builtIn.eletric.Taser;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.Adrenaline;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.Antibiotics;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.Bandage;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.CleanRag;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.DirtyRag;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.HealInjection;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.InfectionInjection;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.Medkit;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.Painkillers;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.SpeedInjection;
import zombieworldproject.zombieracore.managers.item.builtIn.medical.Splint;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.BarbedWire;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.Blueprint;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.BoozleBottle;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.CanOpener;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.EquipmentSettings;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.GasCanister;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.Lighter;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.LuckyChestKey;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.Sandbag;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.Shield;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.watercanteen.WaterCanteenEmpty;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.watercanteen.WaterCanteenFilled;
import zombieworldproject.zombieracore.managers.item.builtIn.repairkits.RepairGunKit;
import zombieworldproject.zombieracore.managers.item.builtIn.repairkits.RepairMeleeKit;
import zombieworldproject.zombieracore.managers.item.builtIn.repairkits.SewingKit;
import zombieworldproject.zombieracore.managers.item.builtIn.throwable.Dynamite;
import zombieworldproject.zombieracore.managers.item.builtIn.throwable.FireCrackers;
import zombieworldproject.zombieracore.managers.item.builtIn.throwable.FlashBang;
import zombieworldproject.zombieracore.managers.item.builtIn.throwable.Grenade;
import zombieworldproject.zombieracore.managers.item.builtIn.throwable.InfectionBomb;
import zombieworldproject.zombieracore.managers.item.builtIn.throwable.Molotov;
import zombieworldproject.zombieracore.managers.item.builtIn.throwable.PipeBomb;
import zombieworldproject.zombieracore.managers.item.builtIn.throwable.SmokeGrenade;

public class ZEItemManager {
    public Map<String, ItemBase> usableItems = new HashMap<String, ItemBase>();
    public Map<String, ItemBase> meleeWeapons = new HashMap<String, ItemBase>();
    public Map<String, ItemBase> foodItems = new HashMap<String, ItemBase>();
    public Map<String, CannedFoodItemBase> cannedFoodItems = new HashMap<String, CannedFoodItemBase>();
    public Map<String, ThrowableItemBase> throwableItems = new HashMap<String, ThrowableItemBase>();
    public Map<Integer, ArmedGunItemBase> armedItems = new HashMap<Integer, ArmedGunItemBase>();
    public Map<Integer, EquitableItemBase> equipmentItems = new HashMap<Integer, EquitableItemBase>();
    public Map<DoorTypes, ItemBase> keycardItems = new HashMap<DoorTypes, ItemBase>();
    public Map<AmmoTypes, ItemBase> ammoTypesItems = new HashMap<AmmoTypes, ItemBase>();
    public Map<Integer, ItemBase> ammoTypesNBTIds = new HashMap<Integer, ItemBase>();
    public Map<AmmoTypes, BulletShootHandler> shootHandlerMap = new HashMap<AmmoTypes, BulletShootHandler>();
    private Map<String, ItemBase> mappedItemBasesByName = new HashMap<String, ItemBase>();
    private Map<Integer, ItemBase> mappedItemBasesByNbt = new HashMap<Integer, ItemBase>();

    public void Initialize() {
        this.registerMedicalItems();
        this.registerWaterItems();
        this.registerAdminItems();
        this.registerMiscItems();
        this.registerThrowableItems();
        this.registerElectricalItems();
        this.registerOtherItems();
        this.registerRepairKits();
        this.registerBuildingItems();
        this.registerAmmoSystem();
        this.logBuiltInItems();
    }

    private void registerMedicalItems() {
        new Medkit();
        new Adrenaline();
        new Bandage();
        new Antibiotics();
        new CleanRag();
        new InfectionInjection();
        new DirtyRag();
        new HealInjection();
        new Painkillers();
        new SpeedInjection();
        new Splint();
        new EquipmentSettings();
    }

    private void registerWaterItems() {
        new WaterCanteenFilled();
        new WaterCanteenEmpty();
        new GasCanister();
    }

    private void registerAdminItems() {
        new StructureSelector();
    }

    private void registerMiscItems() {
        new BarbedWire();
        new Sandbag();
        new CanOpener();
    }

    private void registerThrowableItems() {
        new Grenade();
        new FlashBang();
        new InfectionBomb();
        new Molotov();
        new Dynamite();
        new SmokeGrenade();
        new FireCrackers();
        new PipeBomb();
        new BoozleBottle();
        new Lighter();
    }

    private void registerElectricalItems() {
        new Flashlight();
        new Battery();
        new Taser();
    }

    private void registerOtherItems() {
        new LuckyChestKey();
        new Shield();
        new PlayerLock();
    }

    private void registerRepairKits() {
        new RepairMeleeKit();
        new RepairGunKit();
        new SewingKit();
    }

    private void registerBuildingItems() {
        new Barricade();
        new BuildHammer();
    }

    private void registerAmmoSystem() {
        this.loadAmmoTypes();
        this.loadShootHandlers();
        this.loadKeycards();
    }

    private void logBuiltInItems() {
        this.usableItems.forEach((key, value) -> ZombiEraCore.debugInfo(String.format("BuiltIn item %s loaded", key)));
    }

    private void loadAmmoTypes() {
        this.registerAmmoType(AmmoTypes.PISTOL, "Pistol Ammo", 4532001, "pistolammo");
        this.registerAmmoType(AmmoTypes.RIFLE, "Rifle Ammo", 4532002, "rifleammo");
        this.registerAmmoType(AmmoTypes.SHOTGUN, "Shotgun Ammo", 4532003, "shotgunammo");
        this.registerAmmoType(AmmoTypes.SNIPER, "Sniper Ammo", 4532004, "sniperammo");
        this.registerAmmoType(AmmoTypes.M82, "M82 Ammo", 4532005, "m82ammo");
        this.registerAmmoType(AmmoTypes.GRENADE, "Grenade Projectile", 4532006, "grenadeprojectileammo");
        this.registerAmmoType(AmmoTypes.ENERGY, "Energy Ammo", 4532007, "energyammo");
        this.registerAmmoBoxes();
    }

    private void registerAmmoType(AmmoTypes type, String name, int nbtId, String dirName) {
        this.ammoTypesItems.put(type, new AmmoItem(type, name, nbtId, dirName, 1));
    }

    private void registerAmmoBoxes() {
        new AmmoBox(6, AmmoTypes.GRENADE, "Grenade Projectile Ammo Box", 9999006);
        new AmmoBox(5, AmmoTypes.M82, "M82 Ammo Box", 9999005);
        new AmmoBox(15, AmmoTypes.PISTOL, "Pistol Ammo Box", 0x989299);
        new AmmoBox(25, AmmoTypes.RIFLE, "Rifle Ammo Box", 9999002);
        new AmmoBox(16, AmmoTypes.SHOTGUN, "Shotgun Ammo Box", 9999003);
        new AmmoBox(12, AmmoTypes.SNIPER, "Sniper Ammo Box", 9999004);
        new AmmoBox(7, AmmoTypes.ENERGY, "Energy Ammo Box", 9999007);
    }

    private void loadShootHandlers() {
        NormalShootHandler normalShootHandler = new NormalShootHandler();
        this.shootHandlerMap.put(AmmoTypes.PISTOL, normalShootHandler);
        this.shootHandlerMap.put(AmmoTypes.M82, normalShootHandler);
        this.shootHandlerMap.put(AmmoTypes.RIFLE, normalShootHandler);
        this.shootHandlerMap.put(AmmoTypes.SNIPER, normalShootHandler);
        this.shootHandlerMap.put(AmmoTypes.SHOTGUN, new ShotgunShootHandler());
        this.shootHandlerMap.put(AmmoTypes.FLAMETHROWER, new FlameThrowerShootHandler());
        this.shootHandlerMap.put(AmmoTypes.GRENADE, new GrenadeShootHandler());
        this.shootHandlerMap.put(AmmoTypes.ENERGY, new EnergyShootHandler());
    }

    public BulletShootHandler getShootHandler(AmmoTypes type) {
        return this.shootHandlerMap.get((Object)type);
    }

    private void loadKeycards() {
        this.keycardItems.put(DoorTypes.GREEN, new Keycard(2300021, "KeyCard Green", DoorTypes.GREEN));
        this.keycardItems.put(DoorTypes.BLUE, new Keycard(2300022, "KeyCard Blue", DoorTypes.BLUE));
        this.keycardItems.put(DoorTypes.RED, new Keycard(2300023, "KeyCard Red", DoorTypes.RED));
    }

    public void addBlueprint(String recipeName, String bpName, String row1, String row2, String row3, Map<Character, String> itemIngredients) {
        new Blueprint(recipeName, bpName, row1, row2, row3, itemIngredients);
    }

    public void updateMappedItemBases() {
        this.mappedItemBasesByName.clear();
        this.mappedItemBasesByNbt.clear();
        List<ItemBase> allItems = this.getAllItemBases();
        for (ItemBase item : allItems) {
            if (item == null || item.getDirName() == null) continue;
            this.mapItemByType(item);
        }
    }

    private void mapItemByType(ItemBase item) {
        if (item instanceof ArmedGunItemBase) {
            ArmedGunItemBase gun = (ArmedGunItemBase)item;
            this.mapGunItem(gun);
        } else if (item instanceof CannedFoodItemBase) {
            CannedFoodItemBase food = (CannedFoodItemBase)item;
            this.mapCannedFoodItem(food);
        } else {
            this.mapStandardItem(item);
        }
    }

    private void mapGunItem(ArmedGunItemBase gun) {
        this.mappedItemBasesByNbt.put(gun.id, gun);
        this.mappedItemBasesByNbt.put(gun.nbtZoomId, gun);
        this.mappedItemBasesByName.put(gun.getDirName(), gun);
    }

    private void mapCannedFoodItem(CannedFoodItemBase food) {
        this.mappedItemBasesByNbt.put(food.nbtClosed, food);
        this.mappedItemBasesByNbt.put(food.nbtOpened, food);
        this.mappedItemBasesByName.put(food.dirName, food);
        this.mappedItemBasesByName.put(food.dirNameClosed, food);
    }

    private void mapStandardItem(ItemBase item) {
        this.mappedItemBasesByName.put(item.getDirName(), item);
        this.mappedItemBasesByNbt.put(item.getNBTTag(), item);
    }

    public Map<String, ItemBase> getMappedItemBasesByName() {
        return this.mappedItemBasesByName;
    }

    public Map<Integer, ItemBase> getMappedItemBasesByNBT() {
        return this.mappedItemBasesByNbt;
    }

    public ItemBase getItemBase(String name) {
        return this.mappedItemBasesByName.get(name);
    }

    public ItemBase getItemBase(Integer nbtId) {
        return this.mappedItemBasesByNbt.get(nbtId);
    }

    public List<ItemBase> getAllItemBases() {
        ArrayList<ItemBase> allItems = new ArrayList<ItemBase>();
        allItems.addAll(this.usableItems.values());
        allItems.addAll(this.meleeWeapons.values());
        allItems.addAll(this.foodItems.values());
        allItems.addAll(this.throwableItems.values());
        allItems.addAll(this.equipmentItems.values());
        allItems.addAll(this.ammoTypesItems.values());
        allItems.addAll(this.armedItems.values());
        allItems.addAll(this.keycardItems.values());
        return allItems;
    }

    public void handleItem(Location location, Integer nbtId) {
        ItemBase itemBase = this.getItemBase(nbtId);
        if (itemBase == null) {
            return;
        }
        if (itemBase instanceof ThrowableItemBase) {
            ThrowableItemBase throwableItem = (ThrowableItemBase)itemBase;
            throwableItem.onCollisionHandle(location);
        }
    }

    public void handleItem(Integer nbtId, PlayerInteractEvent event) {
        UsableItemBase usable;
        ItemBase itemBase = this.getItemBase(nbtId);
        if (itemBase == null) {
            return;
        }
        if (itemBase instanceof UsableItemBase && !((usable = (UsableItemBase)itemBase) instanceof CannedFoodItemBase)) {
            usable.playerItemUseByEvent(event);
        }
    }

    public void handleItem(Integer nbtId, PlayerItemConsumeEvent event) {
        ItemBase itemBase = this.getItemBase(nbtId);
        if (itemBase == null) {
            return;
        }
        if (itemBase instanceof FoodItemBase) {
            FoodItemBase food = (FoodItemBase)itemBase;
            food.playerItemUseByEvent(event);
        } else if (itemBase instanceof CannedFoodItemBase) {
            CannedFoodItemBase cannedFood = (CannedFoodItemBase)itemBase;
            cannedFood.playerItemUseByEvent(event);
        }
    }

    public void clearAll() {
        this.usableItems.clear();
        this.meleeWeapons.clear();
        this.foodItems.clear();
        this.cannedFoodItems.clear();
        this.throwableItems.clear();
        this.armedItems.clear();
        this.equipmentItems.clear();
        this.ammoTypesItems.clear();
        this.ammoTypesNBTIds.clear();
        this.shootHandlerMap.clear();
        this.keycardItems.clear();
        this.mappedItemBasesByName.clear();
        this.mappedItemBasesByNbt.clear();
    }
}

