/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.food.CannedFoodItemBase;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZERarityDropManager {
    private static final String DEFAULT_RARITY = "default";
    private static final String RARITY_DELIMITER = ",";
    public Map<String, Rarity> possibleRarities = new HashMap<String, Rarity>();
    public Map<String, RarityGroup> groupRarities = new HashMap<String, RarityGroup>();
    public Map<String, EntityDrop> entityDrops = new HashMap<String, EntityDrop>();

    public void Initialize() {
        this.possibleRarities.put(DEFAULT_RARITY, new Rarity(DEFAULT_RARITY, ChatColor.WHITE));
    }

    public void clear() {
        this.possibleRarities.clear();
        this.entityDrops.clear();
        this.groupRarities.clear();
        this.Initialize();
    }

    public ChatColor getColor(String rarityName) {
        if (rarityName == null) {
            return ChatColor.WHITE;
        }
        String normalizedName = this.extractLastRarity(rarityName);
        if (this.possibleRarities.containsKey(normalizedName)) {
            return this.possibleRarities.get((Object)normalizedName).color;
        }
        return ChatColor.WHITE;
    }

    private String extractLastRarity(String rarityName) {
        String[] rarities = rarityName.split(RARITY_DELIMITER);
        String lastRarity = rarities[rarities.length - 1];
        return lastRarity.trim().strip();
    }

    public void addRarity(String rarityName, String color) {
        ChatColor rarityColor = ChatColor.valueOf((String)color);
        this.possibleRarities.put(rarityName, new Rarity(rarityName, rarityColor));
    }

    public void addGroup(String groupName, String rarity, Integer rarityWeight, Integer itemCountMin, Integer itemCountMax, Integer crateRespawnLootSeconds, Integer maxIterations) {
        Rarity rarityObject;
        RarityGroup group = this.groupRarities.get(groupName);
        if (group == null) {
            group = new RarityGroup(groupName, crateRespawnLootSeconds, maxIterations);
            this.groupRarities.put(groupName, group);
        }
        if ((rarityObject = this.possibleRarities.get(rarity)) != null) {
            group.addRarity(rarityObject, rarityWeight, itemCountMin, itemCountMax);
        }
    }

    public void addEntityRarityGroup(String entityName, String groupName, Integer dropChance) {
        if (!this.entityDrops.containsKey(entityName)) {
            this.entityDrops.put(entityName, new EntityDrop(dropChance, groupName));
        }
    }

    public void generateRarities() {
        ZombiEraCore.debugInfo("Generating item rarities...");
        List<ItemBase> itemBases = ZombiEraCore.getItemManager().getAllItemBases();
        this.processItemBases(itemBases);
        this.logRarityGeneration();
        ZombiEraCore.debugInfo("Finished generating item rarities");
    }

    private void processItemBases(List<ItemBase> itemBases) {
        for (ItemBase itemBase : itemBases) {
            String rarityString = itemBase.getRarity();
            Integer dropWeight = itemBase.getDropWeight();
            if (rarityString == null) continue;
            this.assignItemToRarities(itemBase, rarityString, dropWeight);
        }
    }

    private void assignItemToRarities(ItemBase itemBase, String rarityString, Integer dropWeight) {
        String[] rarities;
        for (String rarityName : rarities = rarityString.split(RARITY_DELIMITER)) {
            rarityName = rarityName.trim();
            Rarity rarity = this.getOrCreateRarity(rarityName);
            rarity.addItem(itemBase, dropWeight);
        }
    }

    private Rarity getOrCreateRarity(String rarityName) {
        if (!this.possibleRarities.containsKey(rarityName)) {
            this.possibleRarities.put(rarityName, new Rarity(rarityName, ChatColor.WHITE));
        }
        return this.possibleRarities.get(rarityName);
    }

    private void logRarityGeneration() {
        ZombiEraCore.debugInfo(String.format("Generated: %s rarities", this.possibleRarities.size()));
        this.possibleRarities.forEach((name, rarity) -> ZombiEraCore.debugInfo(String.format("Rarity: %s -> item-count: %s", name, rarity.itemThreshold.size())));
    }

    public static class Rarity {
        public String rarityName;
        public ChatColor color;
        public List<ItemBase> itemThreshold;
        private final Random random;

        public Rarity(String rarityName, ChatColor color) {
            this.rarityName = rarityName;
            this.color = color;
            this.itemThreshold = new ArrayList<ItemBase>();
            this.random = new Random();
        }

        public void addItem(ItemBase item, Integer itemDropWeight) {
            for (int i = 0; i < itemDropWeight; ++i) {
                this.itemThreshold.add(item);
            }
        }

        public ItemBase getRandomItem() {
            if (this.itemThreshold.isEmpty()) {
                return null;
            }
            return this.itemThreshold.get(this.random.nextInt(this.itemThreshold.size()));
        }
    }

    public static class RarityGroup {
        public String groupName;
        public List<Rarity> rarityThreshold;
        public Map<Rarity, ItemCountTuple> itemCountMinMax;
        public Integer crateRespawnLootSeconds;
        public Integer maxIterations;
        private final Random random;

        public RarityGroup(String groupName, Integer crateRespawnLootSeconds, Integer maxIterations) {
            this.groupName = groupName;
            this.crateRespawnLootSeconds = crateRespawnLootSeconds;
            this.maxIterations = maxIterations;
            this.rarityThreshold = new ArrayList<Rarity>();
            this.itemCountMinMax = new HashMap<Rarity, ItemCountTuple>();
            this.random = new Random();
        }

        public void addRarity(Rarity rarity, Integer rarityWeight, Integer itemCountMin, Integer itemCountMax) {
            for (int i = 0; i < rarityWeight; ++i) {
                this.rarityThreshold.add(rarity);
            }
            this.itemCountMinMax.put(rarity, new ItemCountTuple(itemCountMin, itemCountMax));
        }

        public List<ItemBase> generateItemBases() {
            ArrayList<ItemBase> items = new ArrayList<ItemBase>();
            ArrayList<Rarity> raritiesCopy = new ArrayList<Rarity>(this.rarityThreshold);
            for (int iteration = 0; iteration < this.maxIterations && !raritiesCopy.isEmpty(); ++iteration) {
                Rarity selectedRarity = this.selectRandomRarity(raritiesCopy);
                if (selectedRarity == null) continue;
                this.addItemsFromRarity(items, selectedRarity);
                this.removeRarityFromPool(raritiesCopy, selectedRarity);
            }
            return items;
        }

        private Rarity selectRandomRarity(List<Rarity> raritiesPool) {
            if (raritiesPool.isEmpty()) {
                return null;
            }
            return raritiesPool.get(this.random.nextInt(raritiesPool.size()));
        }

        private void addItemsFromRarity(List<ItemBase> items, Rarity rarity) {
            ItemCountTuple minMax = this.itemCountMinMax.get(rarity);
            if (minMax == null) {
                return;
            }
            int itemCount = MiscUtils.generateBetweenNumbers(minMax.min, minMax.max);
            for (int i = 0; i < itemCount; ++i) {
                ItemBase item = rarity.getRandomItem();
                if (item == null) continue;
                items.add(item);
            }
        }

        private void removeRarityFromPool(List<Rarity> raritiesPool, Rarity rarityToRemove) {
            if (this.maxIterations <= 1 || rarityToRemove == null) {
                return;
            }
            raritiesPool.replaceAll(rarity -> rarity != null && rarity.rarityName.equals(rarityToRemove.rarityName) ? null : rarity);
        }

        public List<ItemStack> generateItemStacks() {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            List<ItemBase> itemBases = this.generateItemBases();
            for (ItemBase itemBase : itemBases) {
                ItemStack itemStack = this.createItemStack(itemBase);
                if (itemStack == null) continue;
                itemStacks.add(itemStack);
            }
            return itemStacks;
        }

        private ItemStack createItemStack(ItemBase itemBase) {
            if (itemBase instanceof CannedFoodItemBase) {
                CannedFoodItemBase cannedItem = (CannedFoodItemBase)itemBase;
                return cannedItem.getItem(false);
            }
            return itemBase.getItem();
        }
    }

    public class EntityDrop {
        private final List<RarityGroup> entityDropsList;
        private final Integer dropChance;
        private final String groupName;

        public EntityDrop(Integer dropChance, String groupName) {
            this.dropChance = dropChance;
            this.groupName = groupName;
            this.entityDropsList = new ArrayList<RarityGroup>();
            this.buildDropsList();
        }

        private void buildDropsList() {
            RarityGroup group = ZERarityDropManager.this.groupRarities.get(this.groupName);
            if (group == null) {
                return;
            }
            for (int i = 0; i < this.dropChance; ++i) {
                this.entityDropsList.add(group);
            }
        }

        public List<ItemStack> getDrops() {
            if (!MiscUtils.generateChance(this.dropChance) || this.entityDropsList.isEmpty()) {
                return new ArrayList<ItemStack>();
            }
            RarityGroup selectedGroup = this.entityDropsList.get(MiscUtils.globalRandom.nextInt(this.entityDropsList.size()));
            return selectedGroup.generateItemStacks();
        }
    }

    public static class ItemCountTuple {
        public Integer min;
        public Integer max;

        public ItemCountTuple(Integer min, Integer max) {
            this.min = min;
            this.max = max;
        }
    }
}

