/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.equitable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.BackpackItemBase;

public class ZEBackpackManager {
    private final Map<Integer, Inventory> loadedBackpacks = new HashMap<Integer, Inventory>();
    private int counter = 0;

    public ZEBackpackManager() {
        this.init();
    }

    public Integer getID(ItemStack backpackItem) {
        if (backpackItem == null || !backpackItem.hasItemMeta()) {
            return -2;
        }
        ItemMeta meta = backpackItem.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            return -2;
        }
        for (String line : meta.getLore()) {
            if (!line.contains("Backpack-ID")) continue;
            try {
                return Integer.parseInt(line.substring(line.indexOf("<") + 1, line.indexOf(">")));
            }
            catch (NumberFormatException e) {
                return -2;
            }
        }
        return -2;
    }

    public boolean giveBackpackItemsBack(Player player, Integer id) {
        Inventory backpackInv = this.loadedBackpacks.get(id);
        if (backpackInv == null) {
            return false;
        }
        PlayerInventory playerInventory = player.getInventory();
        boolean deleted = false;
        for (int i = 0; i < backpackInv.getSize(); ++i) {
            ItemStack item = backpackInv.getItem(i);
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || !(ZombiEraCore.getItemManager().getItemBase(item.getItemMeta().getCustomModelData()) instanceof BackpackItemBase)) continue;
            if (playerInventory.firstEmpty() == -1) {
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            } else {
                playerInventory.addItem(new ItemStack[]{item});
            }
            backpackInv.setItem(i, null);
            deleted = true;
        }
        return deleted;
    }

    public void setBackpackID(ItemStack item, Integer id) {
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            return;
        }
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!line.contains("Backpack-ID")) continue;
            lore.set(i, line.replace(String.format("<%s>", this.getID(item)), String.format("<%s>", id)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public void saveBackpackToFile(Integer id, Player player) {
        ItemStack backpackItem;
        ZEEquipmentsManager.EquipmentInventory equipmentInventory;
        Inventory inventory = this.loadedBackpacks.get(id);
        if (inventory == null) {
            return;
        }
        File file = this.getBackpackFile(id);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("inventory.size", (Object)inventory.getSize());
        config.set("inventory.content", (Object)inventory.getContents());
        if (player != null && (equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player)) != null && (backpackItem = equipmentInventory.getBackPack()) != null && backpackItem.hasItemMeta()) {
            this.updateBackpackLoreWithContents(backpackItem, inventory);
        }
        try {
            config.save(file);
            ZombiEraCore.debugInfo("Saved backpack: " + id);
        }
        catch (IOException e) {
            ZombiEraCore.instance.getLogger().warning("Failed to save backpack file: " + id);
        }
    }

    private void updateBackpackLoreWithContents(ItemStack backpackItem, Inventory inventory) {
        ItemStack[] line;
        ItemMeta meta = backpackItem.getItemMeta();
        if (meta == null) {
            return;
        }
        ArrayList lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList();
        }
        ArrayList<Object> newLore = new ArrayList<Object>();
        Iterator iterator = lore.iterator();
        while (iterator.hasNext() && !(line = (ItemStack[])iterator.next()).contains("Contains")) {
            newLore.add(line);
        }
        newLore.add(String.valueOf(ChatColor.GRAY) + "Contains:");
        HashMap<String, Integer> itemCountMap = new HashMap<String, Integer>();
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !item.hasItemMeta()) continue;
            String name = item.getItemMeta().getDisplayName();
            itemCountMap.put(name, itemCountMap.getOrDefault(name, 0) + item.getAmount());
        }
        StringBuilder lineBuilder = new StringBuilder();
        int count = 0;
        for (Map.Entry entry : itemCountMap.entrySet()) {
            lineBuilder.append(entry.getValue()).append("x ").append((String)entry.getKey()).append(ChatColor.WHITE).append(" ");
            if (++count != 3) continue;
            newLore.add(String.valueOf(ChatColor.WHITE) + lineBuilder.toString().trim());
            lineBuilder.setLength(0);
            count = 0;
        }
        if (lineBuilder.length() > 0) {
            newLore.add(String.valueOf(ChatColor.WHITE) + lineBuilder.toString().trim());
        }
        meta.setLore(newLore);
        backpackItem.setItemMeta(meta);
    }

    public void loadBackpackFromFile(Integer id) {
        File file = this.getBackpackFile(id);
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        int size = config.getInt("inventory.size", 9);
        Inventory backpackInventory = Bukkit.createInventory(null, (int)size, (String)String.format("b%s", id));
        List contentList = (List)config.get("inventory.content");
        if (contentList != null) {
            ItemStack[] contents = contentList.toArray(new ItemStack[0]);
            backpackInventory.setContents(contents);
        }
        this.loadedBackpacks.put(id, backpackInventory);
    }

    public Integer createBackpack(BackpackItemBase backpackItemBase, ItemStack backpackItem) {
        ++this.counter;
        int size = backpackItemBase.inventorySize != null ? backpackItemBase.inventorySize : 9;
        Inventory backpackInventory = Bukkit.createInventory(null, (int)size, (String)String.format("b%s", this.counter));
        this.setBackpackID(backpackItem, this.counter);
        this.loadedBackpacks.put(this.counter, backpackInventory);
        this.saveBackpackToFile(this.counter, null);
        return this.counter;
    }

    public void openBackPack(Player player, Integer id) {
        if (this.loadedBackpacks.containsKey(id)) {
            player.openInventory(this.loadedBackpacks.get(id));
        } else {
            this.loadBackpackFromFile(id);
            player.openInventory(this.loadedBackpacks.get(id));
        }
    }

    public void init() {
        File dir = new File(ZombiEraCore.instance.getDataFolder(), "data/backpacks/");
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        ZombiEraCore.debugInfo("Checking backpack data files...");
        File[] files = dir.listFiles((d, name) -> name.endsWith(".yml"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName().replace(".yml", "");
            try {
                int id = Integer.parseInt(fileName);
                this.counter = Math.max(this.counter, id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ZombiEraCore.debugInfo("Backpack data files check finished!");
    }

    private File getBackpackFile(Integer id) {
        return new File(ZombiEraCore.instance.getDataFolder(), "data/backpacks/" + id + ".yml");
    }
}

