/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.equitable;

import com.comphenix.protocol.wrappers.Pair;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ArmorTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.EquitableTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BodyPart;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public final class ZEEquipmentsManager {
    public static ItemStack freeItemBackpack = new ItemStack(Material.LIME_STAINED_GLASS_PANE){
        {
            ItemMeta meta = this.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("Backpack Slot");
                this.setItemMeta(meta);
            }
        }
    };
    public static ItemStack lockedItemSlot = new ItemStack(Material.GRAY_STAINED_GLASS_PANE){
        {
            ItemMeta meta = this.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("Locked Slot");
                this.setItemMeta(meta);
            }
        }
    };
    public static String EquipmentTitle = "Equipment";
    public static Map<String, ItemStack> defaultItems = new HashMap<String, ItemStack>(){
        {
            this.put("showEquipment", ZEEquipmentsManager.createLabeledItem(String.valueOf(ChatColor.BLUE) + "Show Equipment", (List<String>)new ArrayList<String>(){
                {
                    this.add(String.valueOf(ChatColor.WHITE) + "Click to toggle local equipment visibility.");
                }
            }, Material.CLOCK));
        }
    };
    public static Map<Player, EquipmentInventory> playerEquipmentInventories = new HashMap<Player, EquipmentInventory>();
    public static Map<Integer, Player> playerASEntityIds = new HashMap<Integer, Player>();
    public static List<Player> hideEquipment = new ArrayList<Player>();

    public static ItemStack createLabeledItem(String name, List<String> lore, Material itemType) {
        ItemStack item = new ItemStack(itemType);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(name);
            itemMeta.setLore(lore);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            item.setItemMeta(itemMeta);
        }
        return item;
    }

    public static void createInventory(Player player) {
        if (!playerEquipmentInventories.containsKey(player)) {
            EquipmentInventory eqpInv = new EquipmentInventory(player);
            playerEquipmentInventories.put(player, eqpInv);
        }
    }

    public static EquipmentInventory addInventoryManually(Player player) {
        if (!playerEquipmentInventories.containsKey(player)) {
            EquipmentInventory equipInv = new EquipmentInventory(player);
            playerEquipmentInventories.put(player, equipInv);
            equipInv.setItems();
        }
        return playerEquipmentInventories.get(player);
    }

    public static void openInventory(Player player) {
        ZEEquipmentsManager.createInventory(player);
        EquipmentInventory eqpInv = playerEquipmentInventories.get(player);
        if (eqpInv != null) {
            eqpInv.open(player);
        }
    }

    public static class EquipmentInventory {
        public Inventory inventory = Bukkit.createInventory(null, (int)9, (String)EquipmentTitle);
        public ArmorStand armorStand;
        Integer entityId;
        Player owner;
        private EulerAngle previousAngle;
        private Double headProtection = 0.0;
        private Double chestProtection = 0.0;
        private Double legProtection = 0.0;
        private Double radProtection = 0.0;
        private Double scratchProtection = 0.0;
        private Double biteProtection = 0.0;
        private Double sneakDistance = 0.0;

        public EquipmentInventory(Player owner) {
            this.owner = owner;
            Entity passenger = owner.getPassenger();
            if (passenger != null) {
                owner.removePassenger(passenger);
            }
            this.createArmorStand();
            this.playerRespawn();
            this.setDefaultItems();
        }

        public Pair<ItemStack, ArmorTypes> getPart(BodyPart bodyPart) {
            ItemStack equip = null;
            ArmorTypes armorType = null;
            switch (bodyPart) {
                case HEAD: {
                    equip = this.getHead();
                    armorType = ArmorTypes.HELMET;
                    break;
                }
                case BODY: {
                    equip = this.getChest();
                    armorType = ArmorTypes.CHEST;
                    break;
                }
                case LEG: {
                    if (new Random().nextBoolean()) {
                        equip = this.getLeg();
                        armorType = ArmorTypes.LEG;
                        break;
                    }
                    equip = this.getBoots();
                    armorType = ArmorTypes.BOOTS;
                }
            }
            return new Pair((Object)equip, (Object)armorType);
        }

        public void damageBodyPartEquipment(BodyPart bodyPart) {
            BodyPart randomBodyPart;
            Pair<ItemStack, ArmorTypes> randomPart;
            Pair<ItemStack, ArmorTypes> part = this.getPart(bodyPart);
            ItemStack equip = (ItemStack)part.getFirst();
            ArmorTypes armorType = (ArmorTypes)((Object)part.getSecond());
            if (MiscUtils.generateChance(50) && (randomPart = this.getPart(randomBodyPart = BodyPart.values()[new Random().nextInt(BodyPart.values().length)])).getFirst() != null && randomPart.getSecond() != null) {
                this.damageEquipPart((ItemStack)randomPart.getFirst(), (ArmorTypes)((Object)randomPart.getSecond()));
            }
            if (equip == null || armorType == null) {
                return;
            }
            this.damageEquipPart(equip, armorType);
        }

        public void damageEquipPart(ItemStack item, ArmorTypes armorType) {
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData()) {
                return;
            }
            int id = item.getItemMeta().getCustomModelData();
            ItemBase base = ZombiEraCore.getItemManager().getItemBase(id);
            if (base instanceof EquitableItemBase) {
                int dur = ItemUtils.getDurability(item) - 1;
                if (dur < 1) {
                    ZombiEraCore.getSoundManager().playSound(this.owner, "cloth_break");
                    ItemUtils.setDurability(item, 0);
                    if (this.owner.getInventory().firstEmpty() == -1) {
                        this.owner.getLocation().getWorld().dropItem(this.owner.getLocation(), item);
                    } else {
                        this.owner.getInventory().addItem(new ItemStack[]{item});
                    }
                    switch (armorType) {
                        case HELMET: {
                            this.owner.getInventory().setHelmet(null);
                            break;
                        }
                        case CHEST: {
                            this.owner.getInventory().setChestplate(null);
                            break;
                        }
                        case LEG: {
                            this.owner.getInventory().setLeggings(null);
                            break;
                        }
                        case BOOTS: {
                            this.owner.getInventory().setBoots(null);
                        }
                    }
                    this.setItems();
                } else {
                    ItemUtils.setDurability(item, dur);
                }
            }
        }

        public ItemStack getHead() {
            return this.owner.getInventory().getHelmet();
        }

        public ItemStack getLeg() {
            return this.owner.getInventory().getLeggings();
        }

        public ItemStack getBoots() {
            return this.owner.getInventory().getBoots();
        }

        public ItemStack getChest() {
            return this.owner.getInventory().getChestplate();
        }

        public Double getHeadProtection() {
            return this.headProtection;
        }

        public Double getChestProtection() {
            return this.chestProtection;
        }

        public Double getLegProtection() {
            return this.legProtection;
        }

        public Double getTotalMeleeProtection() {
            return this.chestProtection + this.legProtection;
        }

        public Double getTotalRadiationProtection() {
            return this.radProtection;
        }

        public Double getScratchProtection() {
            return this.scratchProtection;
        }

        public Double getBiteProtection() {
            return this.biteProtection;
        }

        public Double getSneakDistance() {
            return this.sneakDistance;
        }

        public void setItems() {
            EquitableItemBase equipItem;
            ItemStack backpackItem;
            EquitableItemBase equipItem2;
            ItemStack boots;
            EquitableItemBase equipItem3;
            ItemStack leggings;
            EquitableItemBase equipItem4;
            ItemStack head;
            EquitableItemBase equipItem5;
            ItemStack chest;
            this.legProtection = 0.0;
            this.chestProtection = 0.0;
            this.headProtection = 0.0;
            this.radProtection = 0.0;
            this.biteProtection = 0.0;
            this.scratchProtection = 0.0;
            this.sneakDistance = 0.0;
            this.reset();
            if (this.armorStand != null) {
                this.armorStand.setItem(EquipmentSlot.OFF_HAND, null);
            }
            if ((chest = this.owner.getInventory().getChestplate()) != null && chest.hasItemMeta() && chest.getItemMeta().hasCustomModelData() && (equipItem5 = ZombiEraCore.getItemManager().equipmentItems.get(chest.getItemMeta().getCustomModelData())) != null) {
                if (equipItem5.type == EquitableTypes.CHEST && this.armorStand != null) {
                    this.armorStand.setItem(EquipmentSlot.OFF_HAND, chest);
                }
                this.chestProtection = this.chestProtection + equipItem5.armor;
                this.radProtection = this.radProtection + equipItem5.radProtection;
                this.scratchProtection = this.scratchProtection + equipItem5.scratchArmor;
                this.biteProtection = this.biteProtection + equipItem5.biteArmor;
                this.sneakDistance = this.sneakDistance + equipItem5.sneakDistance;
            }
            if ((head = this.owner.getInventory().getHelmet()) != null && head.hasItemMeta() && head.getItemMeta().hasCustomModelData() && (equipItem4 = ZombiEraCore.getItemManager().equipmentItems.get(head.getItemMeta().getCustomModelData())) != null) {
                this.headProtection = this.headProtection + equipItem4.armor;
                this.radProtection = this.radProtection + equipItem4.radProtection;
                this.scratchProtection = this.scratchProtection + equipItem4.scratchArmor;
                this.biteProtection = this.biteProtection + equipItem4.biteArmor;
                this.sneakDistance = this.sneakDistance + equipItem4.sneakDistance;
            }
            if ((leggings = this.owner.getInventory().getLeggings()) != null && leggings.hasItemMeta() && leggings.getItemMeta().hasCustomModelData() && (equipItem3 = ZombiEraCore.getItemManager().equipmentItems.get(leggings.getItemMeta().getCustomModelData())) != null) {
                this.legProtection = this.legProtection + equipItem3.armor;
                this.radProtection = this.radProtection + equipItem3.radProtection;
                this.scratchProtection = this.scratchProtection + equipItem3.scratchArmor;
                this.biteProtection = this.biteProtection + equipItem3.biteArmor;
                this.sneakDistance = this.sneakDistance + equipItem3.sneakDistance;
            }
            if ((boots = this.owner.getInventory().getBoots()) != null && boots.hasItemMeta() && boots.getItemMeta().hasCustomModelData() && (equipItem2 = ZombiEraCore.getItemManager().equipmentItems.get(boots.getItemMeta().getCustomModelData())) != null) {
                this.legProtection = this.legProtection + equipItem2.armor;
                this.radProtection = this.radProtection + equipItem2.radProtection;
                this.scratchProtection = this.scratchProtection + equipItem2.scratchArmor;
                this.biteProtection = this.biteProtection + equipItem2.biteArmor;
                this.sneakDistance = this.sneakDistance + equipItem2.sneakDistance;
            }
            if ((backpackItem = this.getBackPack()) != null && backpackItem.hasItemMeta() && backpackItem.getItemMeta().hasCustomModelData() && (equipItem = ZombiEraCore.getItemManager().equipmentItems.get(backpackItem.getItemMeta().getCustomModelData())) != null && equipItem.type == EquitableTypes.BACKPACK) {
                if (this.armorStand != null) {
                    this.armorStand.setItem(EquipmentSlot.HEAD, backpackItem);
                }
                this.chestProtection = this.chestProtection + equipItem.armor;
                this.radProtection = this.radProtection + equipItem.radProtection;
                this.scratchProtection = this.scratchProtection + equipItem.scratchArmor;
                this.biteProtection = this.biteProtection + equipItem.biteArmor;
                this.sneakDistance = this.sneakDistance + equipItem.sneakDistance;
            }
        }

        public void setDefaultItems() {
            this.inventory.setItem(0, defaultItems.get("showEquipment"));
            this.inventory.setItem(1, freeItemBackpack);
            for (int i = 2; i < 9; ++i) {
                this.inventory.setItem(i, lockedItemSlot);
            }
        }

        public ItemStack getBackPack() {
            return this.inventory.getItem(1);
        }

        public void setBackPack(ItemStack backpackItem) {
            this.inventory.setItem(1, backpackItem);
        }

        public void playerLeave() {
            if (this.armorStand != null) {
                this.reset();
                this.armorStand.remove();
                playerEquipmentInventories.remove(this.owner);
            }
        }

        public void hideToggle() {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.createArmorStand();
            this.setItems();
        }

        public void reset() {
            if (this.armorStand != null) {
                this.armorStand.setItem(EquipmentSlot.OFF_HAND, null);
                this.armorStand.setItem(EquipmentSlot.HEAD, null);
            }
        }

        public List<ItemStack> playerDeath() {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack backpackItem = this.getBackPack();
            if (backpackItem != null && !backpackItem.getType().equals((Object)freeItemBackpack.getType())) {
                items.add(backpackItem);
                this.inventory.setItem(1, null);
            }
            this.reset();
            this.hideToggle();
            return items;
        }

        public void playerRespawn() {
            this.setItems();
            new BukkitRunnable(){

                public void run() {
                    this.hideToggle();
                    Entity passenger = owner.getPassenger();
                    if (passenger != null) {
                        owner.removePassenger(passenger);
                        armorStand.teleport(owner.getLocation());
                    }
                    owner.addPassenger((Entity)armorStand);
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 5L);
        }

        public void toggleSneak(Boolean enabled) {
            if (this.armorStand == null || !this.armorStand.isValid()) {
                return;
            }
            if (enabled.booleanValue()) {
                EulerAngle newAngle = this.previousAngle;
                newAngle = newAngle.add(0.125, 0.0, 0.0);
                this.armorStand.setLeftArmPose(newAngle);
            } else {
                this.armorStand.setLeftArmPose(this.previousAngle);
            }
        }

        public void createArmorStand() {
            this.armorStand = (ArmorStand)this.owner.getWorld().spawn(this.owner.getLocation(), ArmorStand.class, as -> {
                as.setMarker(true);
                as.setGravity(false);
                as.setVisible(false);
                as.setSmall(true);
                as.setCustomNameVisible(false);
                as.setInvulnerable(true);
                as.setAI(false);
            });
            this.armorStand.setLeftArmPose(new EulerAngle(0.0, 0.0, 0.0));
            this.previousAngle = this.armorStand.getLeftArmPose();
            this.armorStand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            this.toggleSneak(false);
            this.entityId = this.armorStand.getEntityId();
            playerASEntityIds.put(this.entityId, this.owner);
            new BukkitRunnable(){

                public void run() {
                    if (!owner.isOnline() || armorStand == null || !armorStand.isValid()) {
                        playerASEntityIds.remove(entityId);
                        this.cancel();
                        return;
                    }
                    Location pLoc = owner.getLocation();
                    Entity entity = owner.getPassenger();
                    if (entity == null || entity.getType() != EntityType.ARMOR_STAND) {
                        armorStand.teleport((Entity)owner);
                        owner.addPassenger((Entity)armorStand);
                        return;
                    }
                    armorStand.setRotation(pLoc.getYaw(), pLoc.getPitch());
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 2L);
            new BukkitRunnable(){

                public void run() {
                    this.setItems();
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 1L);
        }

        public void open(Player player) {
            ItemStack showEquipment = defaultItems.get("showEquipment").clone();
            ItemMeta meta = showEquipment.getItemMeta();
            if (meta != null) {
                ArrayList<CallSite> lore = meta.getLore();
                if (lore == null) {
                    lore = new ArrayList<CallSite>();
                }
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Now: " + !hideEquipment.contains(player))));
                meta.setLore(lore);
                showEquipment.setItemMeta(meta);
            }
            this.inventory.setItem(0, showEquipment);
            player.openInventory(this.inventory);
        }
    }
}

