/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.equitable.items;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.equitable.EquitableTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class BackpackItemBase
extends EquitableItemBase {
    public final Integer inventorySize;

    public BackpackItemBase(String dirName, String displayName, Integer ntbId, EquitableTypes type, String rarity, Integer dropWeight, Double armor, Double radProtection, Integer inventorySize, Double scratchArmor, Double biteArmor, Double sneakDistance, Integer maxDurability) {
        super(dirName, displayName, ntbId, type, rarity, dropWeight, armor, radProtection, 0.0, scratchArmor, biteArmor, sneakDistance, maxDurability);
        this.inventorySize = inventorySize;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        PlayerInventory playerInventory = player.getInventory();
        if (equipmentInventory == null || !event.getAction().isRightClick()) {
            return;
        }
        ItemStack currentBackpack = equipmentInventory.getBackPack();
        if (currentBackpack != null && !currentBackpack.getType().equals((Object)ZEEquipmentsManager.freeItemBackpack.getType())) {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Backpack limit reached!", 5);
            return;
        }
        ItemStack backpackItem = playerInventory.getItemInMainHand();
        if (ZombiEraCore.getBackpackManager().getID(backpackItem) == -1) {
            ZombiEraCore.getBackpackManager().createBackpack(this, backpackItem);
        }
        equipmentInventory.setBackPack(backpackItem);
        playerInventory.setItemInMainHand(null);
        equipmentInventory.setItems();
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.SKULL_BANNER_PATTERN);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.rarity), this.displayName));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Equipment");
        this.addStatLore(lore, "Armor", this.armor);
        this.addStatLore(lore, "Scratch Armor", this.scratchArmor);
        this.addStatLore(lore, "Bite Armor", this.biteArmor);
        this.addStatLore(lore, "Sneak", this.sneakDistance);
        if (this.radProtection > 0.0) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "\u2623" + String.valueOf(ChatColor.GREEN) + " Anti-radiation" + String.valueOf(ChatColor.YELLOW) + " \u2623" + String.valueOf(ChatColor.WHITE) + ": <" + this.radProtection + ">");
        }
        lore.add(String.valueOf(ChatColor.WHITE) + "Inventory Size: <" + this.inventorySize + ">");
        lore.add(String.valueOf(ChatColor.WHITE) + "Backpack-ID: <-1>");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click in hand to equip!");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click in equipment settings to open!");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left click in equipment settings to un-equip!");
        meta.setLore(lore);
        meta.setCustomModelData(this.nbtId);
        item.setItemMeta(meta);
        return item;
    }

    private void addStatLore(List<String> lore, String label, Double value) {
        if (value != null && value > 0.0) {
            lore.add(String.valueOf(ChatColor.WHITE) + label + " <" + value + ">");
        }
    }
}

