/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.item.bases.equitable.items;

import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.equitable.EquitableTypes;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class CustomLeatherArmorItemBase
extends EquitableItemBase {
    public final String hexColor;
    public org.bukkit.Color armorColor;

    public CustomLeatherArmorItemBase(String dirName, String displayName, Integer ntbId, EquitableTypes type, String rarity, Integer dropWeight, Double armor, Double radProtection, Double walkSpeed, String hexColor, Double scratchArmor, Double biteArmor, Double sneakDistance, Integer maxDurability) {
        super(dirName, displayName, ntbId, type, rarity, dropWeight, armor, radProtection, walkSpeed, scratchArmor, biteArmor, sneakDistance, maxDurability);
        this.hexColor = hexColor;
    }

    public static Color hex2Rgb(String colorStr) {
        return new Color(Integer.parseInt(colorStr, 16));
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player);
        PlayerInventory playerInventory = player.getInventory();
        if (equipmentInventory == null || !event.getAction().isRightClick()) {
            return;
        }
        ItemStack item = playerInventory.getItemInMainHand();
        switch (this.type) {
            case LEATHER_HELMET: {
                this.equipArmorPiece(player, playerInventory.getHelmet(), item, slotItem -> playerInventory.setHelmet(slotItem), "head");
                break;
            }
            case LEATHER_CHESTPLATE: {
                this.equipArmorPiece(player, playerInventory.getChestplate(), item, slotItem -> playerInventory.setChestplate(slotItem), "chest");
                break;
            }
            case LEATHER_LEGGINGS: {
                this.equipArmorPiece(player, playerInventory.getLeggings(), item, slotItem -> playerInventory.setLeggings(slotItem), "legs");
                break;
            }
            case LEATHER_BOOTS: {
                this.equipArmorPiece(player, playerInventory.getBoots(), item, slotItem -> playerInventory.setBoots(slotItem), "feet");
            }
        }
        equipmentInventory.setItems();
    }

    private void equipArmorPiece(Player player, ItemStack equippedItem, ItemStack newItem, Consumer<ItemStack> equipAction, String bodyPart) {
        if (equippedItem == null) {
            equipAction.accept(newItem);
            player.getInventory().setItemInMainHand(null);
        } else {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Something's already on your " + bodyPart + "!", 5);
        }
    }

    @Override
    public ItemStack createItem() {
        Material material;
        switch (this.type) {
            case LEATHER_HELMET: {
                Material material2 = Material.LEATHER_HELMET;
                break;
            }
            case LEATHER_CHESTPLATE: {
                Material material2 = Material.LEATHER_CHESTPLATE;
                break;
            }
            case LEATHER_LEGGINGS: {
                Material material2 = Material.LEATHER_LEGGINGS;
                break;
            }
            case LEATHER_BOOTS: {
                Material material2 = Material.LEATHER_BOOTS;
                break;
            }
            default: {
                Material material2 = material = null;
            }
        }
        if (material == null) {
            return new ItemStack(Material.LEATHER_CHESTPLATE);
        }
        ItemStack item = new ItemStack(material);
        LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
        if (meta == null) {
            return item;
        }
        Color rgbColor = CustomLeatherArmorItemBase.hex2Rgb(this.hexColor);
        this.armorColor = org.bukkit.Color.fromRGB((int)rgbColor.getRed(), (int)rgbColor.getGreen(), (int)rgbColor.getBlue());
        meta.setColor(this.armorColor);
        meta.setDisplayName(String.valueOf(ZombiEraCore.getRarityDropManager().getColor(this.rarity)) + this.displayName);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DYE, ItemFlag.HIDE_UNBREAKABLE});
        meta.setUnbreakable(true);
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Equipment");
        lore.add(ItemUtils.generatedurability(this.maxDurability, this.maxDurability));
        this.addStatLore(lore, "Armor", this.armor);
        this.addStatLore(lore, "Scratch Armor", this.scratchArmor);
        this.addStatLore(lore, "Bite Armor", this.biteArmor);
        this.addStatLore(lore, "Sneak", this.sneakDistance);
        if (this.radProtection > 0.0) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "\u2623" + String.valueOf(ChatColor.GREEN) + " Anti-radiation" + String.valueOf(ChatColor.YELLOW) + " \u2623" + String.valueOf(ChatColor.WHITE) + ": <" + this.radProtection + ">");
        }
        if (this.walkSpeed != 0.0) {
            lore.add(String.valueOf(ChatColor.WHITE) + "Speed Modifier: " + this.walkSpeed + " %");
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click in hand to equip!");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left click in armor slot to un-equip!");
        meta.setLore(lore);
        meta.setCustomModelData(this.nbtId);
        if (this.walkSpeed != 0.0) {
            meta.addAttributeModifier(Attribute.GENERIC_MOVEMENT_SPEED, new AttributeModifier("generic.movementSpeed", this.walkSpeed / 100.0, AttributeModifier.Operation.ADD_SCALAR));
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    private void addStatLore(List<String> lore, String label, Double value) {
        if (value != null && value > 0.0) {
            lore.add(String.valueOf(ChatColor.WHITE) + label + " <" + value + ">");
        }
    }
}

